/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.web.flow.mdui;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.jasig.cas.support.saml.OpenSamlConfigBean;
import org.jasig.cas.support.saml.web.flow.mdui.MetadataResolverAdapter;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractMetadataResolverAdapter
implements MetadataResolverAdapter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    protected final Map<Resource, MetadataFilterChain> metadataResources;
    protected boolean requireValidMetadata = true;
    @Autowired
    @NotNull
    protected OpenSamlConfigBean configBean;
    private ChainingMetadataResolver metadataResolver;
    private final Object lock = new Object();

    public AbstractMetadataResolverAdapter() {
        this.metadataResources = new HashMap<Resource, MetadataFilterChain>();
    }

    public AbstractMetadataResolverAdapter(Map<Resource, MetadataFilterChain> metadataResources) {
        this.metadataResources = metadataResources;
    }

    public void setRequireValidMetadata(boolean requireValidMetadata) {
        this.requireValidMetadata = requireValidMetadata;
    }

    protected InputStream getResourceInputStream(Resource resource, String entityId) throws IOException {
        this.logger.debug("Locating metadata resource from input stream.");
        if (!resource.exists() || !resource.isReadable()) {
            throw new FileNotFoundException("Resource does not exist or is unreadable");
        }
        return resource.getInputStream();
    }

    @Override
    public EntityDescriptor getEntityDescriptorForEntityId(String entityId) {
        try {
            CriteriaSet criterions = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId)});
            if (this.metadataResolver != null) {
                return this.metadataResolver.resolveSingle(criterions);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return null;
    }

    protected final void buildMetadataResolverAggregate() {
        this.buildMetadataResolverAggregate(null);
    }

    public final void buildMetadataResolverAggregate(String entityId) {
        try {
            Set<Map.Entry<Resource, MetadataFilterChain>> entries = this.metadataResources.entrySet();
            for (Map.Entry<Resource, MetadataFilterChain> entry : entries) {
                Resource resource = entry.getKey();
                this.logger.debug("Loading [{}]", (Object)resource.getFilename());
                this.loadMetadataFromResource((MetadataFilter)entry.getValue(), resource, entityId);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadataFromResource(MetadataFilter metadataFilter, Resource resource, String entityId) {
        try (InputStream in = this.getResourceInputStream(resource, entityId);){
            this.logger.debug("Parsing [{}]", (Object)resource.getFilename());
            Document document = this.configBean.getParserPool().parse(in);
            List<MetadataResolver> resolvers = this.buildSingleMetadataResolver(metadataFilter, resource, document);
            this.metadataResolver = new ChainingMetadataResolver();
            Object object = this.lock;
            synchronized (object) {
                this.metadataResolver.setId(ChainingMetadataResolver.class.getCanonicalName());
                this.metadataResolver.setResolvers(resolvers);
                this.logger.info("Collected metadata from [{}] resource(s). Initializing aggregate resolver...", (Object)resolvers.size());
                this.metadataResolver.initialize();
                this.logger.info("Metadata aggregate initialized successfully.", (Object)resolvers.size());
            }
        }
        catch (Exception e) {
            this.logger.warn("Could not retrieve input stream from resource. Moving on...", (Throwable)e);
        }
    }

    private List<MetadataResolver> buildSingleMetadataResolver(MetadataFilter metadataFilterChain, Resource resource, Document document) throws IOException {
        ArrayList<MetadataResolver> resolvers = new ArrayList<MetadataResolver>();
        Element metadataRoot = document.getDocumentElement();
        DOMMetadataResolver metadataProvider = new DOMMetadataResolver(metadataRoot);
        metadataProvider.setParserPool(this.configBean.getParserPool());
        metadataProvider.setFailFastInitialization(true);
        metadataProvider.setRequireValidMetadata(this.requireValidMetadata);
        metadataProvider.setId(metadataProvider.getClass().getCanonicalName());
        if (metadataFilterChain != null) {
            metadataProvider.setMetadataFilter(metadataFilterChain);
        }
        this.logger.debug("Initializing metadata resolver for [{}]", (Object)resource.getURL());
        try {
            metadataProvider.initialize();
        }
        catch (ComponentInitializationException ex) {
            this.logger.warn("Could not initialize metadata resolver. Resource will be ignored", (Throwable)ex);
        }
        resolvers.add((MetadataResolver)metadataProvider);
        return resolvers;
    }
}

