/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;

public final class SamlCompliantUniqueTicketIdGenerator
implements UniqueTicketIdGenerator {
    private static final int ASSERTION_HANDLE_SIZE = 20;
    private static final byte[] ENDPOINT_ID = new byte[]{0, 1};
    private final byte[] sourceIdDigest;
    private boolean saml2compliant;
    private final SecureRandom random;

    public SamlCompliantUniqueTicketIdGenerator(String sourceId) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(sourceId.getBytes("8859_1"));
            this.sourceIdDigest = messageDigest.digest();
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception generating digest of source ID.", e);
        }
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot get SHA1PRNG secure random instance.");
        }
    }

    public String getNewTicketId(String prefix) {
        if (this.saml2compliant) {
            return new SAML2ArtifactType0004(ENDPOINT_ID, this.newAssertionHandle(), this.sourceIdDigest).base64Encode();
        }
        return new SAML1ArtifactType0001(this.sourceIdDigest, this.newAssertionHandle()).base64Encode();
    }

    public void setSaml2compliant(boolean saml2compliant) {
        this.saml2compliant = saml2compliant;
    }

    private byte[] newAssertionHandle() {
        byte[] handle = new byte[20];
        this.random.nextBytes(handle);
        return handle;
    }
}

