/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.util;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.support.saml.authentication.principal.SamlService;
import org.jasig.cas.support.saml.util.AbstractSamlObjectBuilder;
import org.jasig.cas.support.saml.util.CasHTTPSOAP11Encoder;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.AttributeValue;
import org.opensaml.saml.saml1.core.Audience;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.ConfirmationMethod;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Status;
import org.opensaml.saml.saml1.core.StatusCode;
import org.opensaml.saml.saml1.core.StatusMessage;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.core.SubjectConfirmation;

public final class Saml10ObjectBuilder
extends AbstractSamlObjectBuilder {
    private static final String CONFIRMATION_METHOD = "urn:oasis:names:tc:SAML:1.0:cm:artifact";

    public Response newResponse(String id, DateTime issueInstant, String recipient, WebApplicationService service) {
        SamlService samlService;
        String requestId;
        Response samlResponse = this.newSamlObject(Response.class);
        samlResponse.setID(id);
        samlResponse.setIssueInstant(issueInstant);
        samlResponse.setVersion(SAMLVersion.VERSION_11);
        samlResponse.setInResponseTo(recipient);
        if (service instanceof SamlService && StringUtils.isNotBlank((CharSequence)(requestId = (samlService = (SamlService)service).getRequestID()))) {
            samlResponse.setInResponseTo(requestId);
        }
        return samlResponse;
    }

    public Assertion newAssertion(AuthenticationStatement authnStatement, String issuer, DateTime issuedAt, String id) {
        Assertion assertion = this.newSamlObject(Assertion.class);
        assertion.setID(id);
        assertion.setIssueInstant(issuedAt);
        assertion.setIssuer(issuer);
        assertion.getAuthenticationStatements().add(authnStatement);
        return assertion;
    }

    public Conditions newConditions(DateTime issuedAt, String audienceUri, long issueLength) {
        Conditions conditions = this.newSamlObject(Conditions.class);
        conditions.setNotBefore(issuedAt);
        conditions.setNotOnOrAfter(issuedAt.plus(issueLength));
        AudienceRestrictionCondition audienceRestriction = this.newSamlObject(AudienceRestrictionCondition.class);
        Audience audience = this.newSamlObject(Audience.class);
        audience.setUri(audienceUri);
        audienceRestriction.getAudiences().add(audience);
        conditions.getAudienceRestrictionConditions().add(audienceRestriction);
        return conditions;
    }

    public Status newStatus(QName codeValue, String statusMessage) {
        Status status = this.newSamlObject(Status.class);
        StatusCode code = this.newSamlObject(StatusCode.class);
        code.setValue(codeValue);
        status.setStatusCode(code);
        if (statusMessage != null) {
            StatusMessage message = this.newSamlObject(StatusMessage.class);
            message.setMessage(statusMessage);
            status.setStatusMessage(message);
        }
        return status;
    }

    public AuthenticationStatement newAuthenticationStatement(Date authenticationDate, String authenticationMethod, String subjectId) {
        AuthenticationStatement authnStatement = this.newSamlObject(AuthenticationStatement.class);
        authnStatement.setAuthenticationInstant(new DateTime((Object)authenticationDate));
        authnStatement.setAuthenticationMethod(authenticationMethod != null ? authenticationMethod : "urn:oasis:names:tc:SAML:1.0:am:unspecified");
        authnStatement.setSubject(this.newSubject(subjectId));
        return authnStatement;
    }

    public Subject newSubject(String identifier) {
        return this.newSubject(identifier, CONFIRMATION_METHOD);
    }

    public Subject newSubject(String identifier, String confirmationMethod) {
        SubjectConfirmation confirmation = this.newSamlObject(SubjectConfirmation.class);
        ConfirmationMethod method = this.newSamlObject(ConfirmationMethod.class);
        method.setConfirmationMethod(confirmationMethod);
        confirmation.getConfirmationMethods().add(method);
        NameIdentifier nameIdentifier = this.newSamlObject(NameIdentifier.class);
        nameIdentifier.setNameIdentifier(identifier);
        Subject subject = this.newSamlObject(Subject.class);
        subject.setNameIdentifier(nameIdentifier);
        subject.setSubjectConfirmation(confirmation);
        return subject;
    }

    public AttributeStatement newAttributeStatement(Subject subject, Map<String, Object> attributes, String attributeNamespace) {
        AttributeStatement attrStatement = this.newSamlObject(AttributeStatement.class);
        attrStatement.setSubject(subject);
        for (Map.Entry<String, Object> e : attributes.entrySet()) {
            if (e.getValue() instanceof Collection && ((Collection)e.getValue()).isEmpty()) {
                this.logger.info("Skipping attribute {} because it does not have any values.", (Object)e.getKey());
                continue;
            }
            Attribute attribute = this.newSamlObject(Attribute.class);
            attribute.setAttributeName(e.getKey());
            attribute.setAttributeNamespace(attributeNamespace);
            if (e.getValue() instanceof Collection) {
                Collection c = (Collection)e.getValue();
                for (Object value : c) {
                    attribute.getAttributeValues().add(this.newAttributeValue(value, AttributeValue.DEFAULT_ELEMENT_NAME));
                }
            } else {
                attribute.getAttributeValues().add(this.newAttributeValue(e.getValue(), AttributeValue.DEFAULT_ELEMENT_NAME));
            }
            attrStatement.getAttributes().add(attribute);
        }
        return attrStatement;
    }

    public void encodeSamlResponse(HttpServletResponse httpResponse, HttpServletRequest httpRequest, Response samlMessage) throws Exception {
        CasHTTPSOAP11Encoder encoder = new CasHTTPSOAP11Encoder();
        MessageContext context = new MessageContext();
        context.setMessage((Object)samlMessage);
        encoder.setHttpServletResponse(httpResponse);
        encoder.setMessageContext(context);
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
    }
}

