/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.authentication.principal;

import java.io.BufferedReader;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.authentication.principal.AbstractWebApplicationService;
import org.jasig.cas.authentication.principal.DefaultResponse;
import org.jasig.cas.authentication.principal.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class SamlService
extends AbstractWebApplicationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlService.class);
    private static final long serialVersionUID = -6867572626767140223L;
    private static final String CONST_START_ARTIFACT_XML_TAG_NO_NAMESPACE = "<AssertionArtifact>";
    private static final String CONST_END_ARTIFACT_XML_TAG_NO_NAMESPACE = "</AssertionArtifact>";
    private static final String CONST_START_ARTIFACT_XML_TAG = "<samlp:AssertionArtifact>";
    private static final String CONST_END_ARTIFACT_XML_TAG = "</samlp:AssertionArtifact>";
    private static final int CONST_REQUEST_ID_LENGTH = 11;
    private String requestId;

    protected SamlService(String id) {
        super(id, id, null);
    }

    protected SamlService(String id, String originalUrl, String artifactId, String requestId) {
        super(id, originalUrl, artifactId);
        this.requestId = requestId;
    }

    public String getRequestID() {
        return this.requestId;
    }

    public static SamlService createServiceFrom(HttpServletRequest request) {
        String requestId;
        String artifactId;
        String service = request.getParameter("TARGET");
        String requestBody = SamlService.getRequestBody(request);
        if (!StringUtils.hasText((String)service) && !StringUtils.hasText((String)requestBody)) {
            LOGGER.debug("Request does not specify a {} or request body is empty", (Object)"TARGET");
            return null;
        }
        String id = SamlService.cleanupUrl((String)service);
        if (StringUtils.hasText((String)requestBody)) {
            String tagEnd;
            String tagStart;
            if (requestBody.contains(CONST_START_ARTIFACT_XML_TAG)) {
                tagStart = CONST_START_ARTIFACT_XML_TAG;
                tagEnd = CONST_END_ARTIFACT_XML_TAG;
            } else {
                tagStart = CONST_START_ARTIFACT_XML_TAG_NO_NAMESPACE;
                tagEnd = CONST_END_ARTIFACT_XML_TAG_NO_NAMESPACE;
            }
            int startTagLocation = requestBody.indexOf(tagStart);
            int artifactStartLocation = startTagLocation + tagStart.length();
            int endTagLocation = requestBody.indexOf(tagEnd);
            artifactId = requestBody.substring(artifactStartLocation, endTagLocation).trim();
            requestId = SamlService.extractRequestId(requestBody);
        } else {
            artifactId = null;
            requestId = null;
        }
        LOGGER.debug("Attempted to extract Request from HttpServletRequest. Results:");
        LOGGER.debug("Request Body: {}", (Object)requestBody);
        LOGGER.debug("Extracted ArtifactId: {}", artifactId);
        LOGGER.debug("Extracted Request Id: {}", requestId);
        return new SamlService(id, service, artifactId, requestId);
    }

    public Response getResponse(String ticketId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("SAMLart", ticketId);
        return DefaultResponse.getRedirectResponse((String)this.getOriginalUrl(), parameters);
    }

    protected static String extractRequestId(String requestBody) {
        if (!requestBody.contains("RequestID")) {
            LOGGER.debug("Request body does not contain a request id");
            return null;
        }
        try {
            int position = requestBody.indexOf("RequestID=\"") + 11;
            int nextPosition = requestBody.indexOf(34, position);
            return requestBody.substring(position, nextPosition);
        }
        catch (Exception e) {
            LOGGER.debug("Exception parsing RequestID from request.", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getRequestBody(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            if (reader == null) {
                LOGGER.debug("Request body could not be read because it's empty.");
                String string2 = null;
                return string2;
            }
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            String string = builder.toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.trace("Could not obtain the saml request body from the http request", (Throwable)e);
            return null;
        }
    }
}

