/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.authentication.principal;

import java.io.StringWriter;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.authentication.principal.AbstractWebApplicationService;
import org.jasig.cas.authentication.principal.DefaultResponse;
import org.jasig.cas.authentication.principal.Response;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.jasig.cas.support.saml.util.GoogleSaml20ObjectBuilder;
import org.jasig.cas.util.ApplicationContextProvider;
import org.jdom.Document;
import org.jdom.Element;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Subject;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class GoogleAccountsService
extends AbstractWebApplicationService {
    private static final long serialVersionUID = 6678711809842282833L;
    private static final GoogleSaml20ObjectBuilder BUILDER = new GoogleSaml20ObjectBuilder();
    private final String relayState;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private final String requestId;
    private int skewAllowance;

    protected GoogleAccountsService(String id, String relayState, String requestId, PrivateKey privateKey, PublicKey publicKey) {
        this(id, id, null, relayState, requestId, privateKey, publicKey);
    }

    protected GoogleAccountsService(String id, String originalUrl, String artifactId, String relayState, String requestId, PrivateKey privateKey, PublicKey publicKey) {
        super(id, originalUrl, artifactId);
        this.relayState = relayState;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.requestId = requestId;
    }

    public static GoogleAccountsService createServiceFrom(HttpServletRequest request, PrivateKey privateKey, PublicKey publicKey) {
        String relayState = request.getParameter("RelayState");
        String xmlRequest = BUILDER.decodeSamlAuthnRequest(request.getParameter("SAMLRequest"));
        if (!StringUtils.hasText((String)xmlRequest)) {
            return null;
        }
        Document document = AbstractSaml20ObjectBuilder.constructDocumentFromXml(xmlRequest);
        if (document == null) {
            return null;
        }
        Element root = document.getRootElement();
        String assertionConsumerServiceUrl = root.getAttributeValue("AssertionConsumerServiceURL");
        String requestId = root.getAttributeValue("ID");
        return new GoogleAccountsService(assertionConsumerServiceUrl, relayState, requestId, privateKey, publicKey);
    }

    public Response getResponse(String ticketId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String samlResponse = this.constructSamlResponse();
        String signedResponse = BUILDER.signSamlResponse(samlResponse, this.privateKey, this.publicKey);
        parameters.put("SAMLResponse", signedResponse);
        parameters.put("RelayState", this.relayState);
        return DefaultResponse.getPostResponse((String)this.getOriginalUrl(), parameters);
    }

    public boolean isLoggedOutAlready() {
        return true;
    }

    private String constructSamlResponse() {
        DateTime currentDateTime = new DateTime();
        DateTime notBeforeIssueInstant = DateTime.parse((String)"2003-04-17T00:46:02Z");
        ApplicationContext context = ApplicationContextProvider.getApplicationContext();
        ServicesManager servicesManager = (ServicesManager)context.getBean("servicesManager", ServicesManager.class);
        RegisteredService svc = servicesManager.findServiceBy((Service)this);
        String userId = svc.getUsernameAttributeProvider().resolveUsername(this.getPrincipal(), (Service)this);
        org.opensaml.saml.saml2.core.Response response = BUILDER.newResponse(BUILDER.generateSecureRandomId(), currentDateTime, this.getId(), (WebApplicationService)this);
        response.setStatus(BUILDER.newStatus("urn:oasis:names:tc:SAML:2.0:status:Success", null));
        AuthnStatement authnStatement = BUILDER.newAuthnStatement("urn:oasis:names:tc:SAML:2.0:ac:classes:Password", currentDateTime);
        Assertion assertion = BUILDER.newAssertion(authnStatement, "https://www.opensaml.org/IDP", notBeforeIssueInstant, BUILDER.generateSecureRandomId());
        Conditions conditions = BUILDER.newConditions(notBeforeIssueInstant, currentDateTime.plusSeconds(this.skewAllowance), this.getId());
        assertion.setConditions(conditions);
        Subject subject = BUILDER.newSubject("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", userId, this.getId(), currentDateTime.plusSeconds(this.skewAllowance), this.requestId);
        assertion.setSubject(subject);
        response.getAssertions().add(assertion);
        StringWriter writer = new StringWriter();
        BUILDER.marshalSamlXmlObject((XMLObject)response, writer);
        String result = writer.toString();
        this.logger.debug("Generated Google SAML response: {}", (Object)result);
        return result;
    }

    public void setSkewAllowance(int skewAllowance) {
        this.skewAllowance = skewAllowance;
    }

    public int getSkewAllowance() {
        return this.skewAllowance;
    }
}

