/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml;

import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public final class OpenSamlConfigBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSamlConfigBean.class);
    @Autowired
    @NotNull
    private ParserPool parserPool;

    public ParserPool getParserPool() {
        return this.parserPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        LOGGER.debug("Initializing OpenSaml configuration...");
        Assert.notNull((Object)this.parserPool, (String)"parserPool cannot be null");
        try {
            InitializationService.initialize();
        }
        catch (InitializationException e) {
            throw new RuntimeException("Exception initializing OpenSAML", e);
        }
        Class<ConfigurationService> clazz = ConfigurationService.class;
        synchronized (ConfigurationService.class) {
            XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            if (registry == null) {
                LOGGER.debug("XMLObjectProviderRegistry did not exist in ConfigurationService, will be created");
                registry = new XMLObjectProviderRegistry();
                ConfigurationService.register(XMLObjectProviderRegistry.class, (Object)registry);
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            registry.setParserPool(this.parserPool);
            return;
        }
    }
}

