/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StringUtils {
    public static String join(Map<?, ?> elements, String keyValueSeparator, String entriesSeparator) {
        if (elements == null) {
            return "";
        }
        Iterator<Map.Entry<?, ?>> it = elements.entrySet().iterator();
        if (it.hasNext()) {
            Map.Entry<?, ?> entry = it.next();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(entry.getKey()).append(keyValueSeparator).append(entry.getValue());
            while (it.hasNext()) {
                entry = it.next();
                stringBuilder.append(entriesSeparator).append(entry.getKey()).append(keyValueSeparator).append(entry.getValue());
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static String join(Object[] elements, String separator) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        return StringUtils.join(Stream.of(elements), separator);
    }

    public static String join(Collection<?> elements, String separator) {
        if (elements == null) {
            return "";
        }
        return StringUtils.join(elements.stream(), separator);
    }

    private static <E> String join(Stream<E> elements, String separator) {
        return elements.map(String::valueOf).collect(Collectors.joining(separator));
    }
}

