/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.resources;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.utils.properties.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class UpdatePropertiesFileMojo
extends AbstractMojo {
    protected boolean append;
    protected File dest;
    protected boolean formatMultiValues;
    protected String key;
    protected boolean prettyPrint;
    protected File src;
    protected boolean substitute;
    protected String value;
    protected String valueSeparator = ",";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.src == null || !this.src.isFile()) {
            throw new MojoFailureException("Unable to find the source file " + this.src);
        }
        if (StringUtils.isEmpty((String)this.key)) {
            throw new MojoFailureException("Key should not be null or empty");
        }
        try {
            Properties p = new Properties(this.substitute);
            p.load(this.src);
            String existingValue = p.getProperty(this.key);
            if (this.value == null) {
                if (existingValue != null) {
                    this.getLog().info((CharSequence)("Removing entry with the key " + this.key));
                    p.remove((Object)this.key);
                } else {
                    this.getLog().info((CharSequence)("No entry with the key " + this.key + " exist. No modification will be done."));
                }
            } else if (existingValue == null) {
                this.getLog().info((CharSequence)("Adding entry with the key " + this.key + " and value " + this.value));
                this.setValue(p, this.value);
            } else if (this.append) {
                this.getLog().info((CharSequence)("Appending value " + this.value + " for entry with the key " + this.key));
                this.setValue(p, existingValue + this.valueSeparator + this.value);
            } else {
                this.getLog().info((CharSequence)("Modifying value for entry with the key " + this.key + ". Setting it to " + this.value));
                this.setValue(p, this.value);
            }
            File target = this.dest != null ? this.dest : this.src;
            this.getLog().info((CharSequence)("Storing updated properties into file: " + target));
            p.save(target);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private List<String> formatValue(String toFormat) {
        LinkedList<String> newValues = new LinkedList<String>();
        newValues.add("");
        String[] values = StringUtils.split((String)toFormat, (String)(this.valueSeparator + ' '));
        for (int i = 0; i < values.length; ++i) {
            StringBuilder line = new StringBuilder(values[i].length() + 6);
            if (this.prettyPrint) {
                line.append("    ");
            }
            line.append(values[i]);
            if (i < values.length - 1) {
                line.append(this.valueSeparator);
                if (this.prettyPrint) {
                    line.append(" ");
                }
            }
            newValues.add(line.toString());
        }
        return newValues;
    }

    private void setValue(Properties p, String targetValue) {
        if (this.formatMultiValues) {
            p.put(this.key, p.getComments(this.key), this.formatValue(targetValue));
        } else {
            p.put(this.key, p.getComments(this.key), targetValue);
        }
    }
}

