/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.osgi.util.ManifestElement;
import org.jahia.utils.maven.plugin.AetherAwareMojo;
import org.jahia.utils.maven.plugin.SLF4JLoggerToMojoLogBridge;
import org.jahia.utils.osgi.ManifestValueClause;
import org.jahia.utils.osgi.ManifestValueParser;
import org.jahia.utils.osgi.PropertyFileUtils;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;

public class BuildFrameworkPackageListMojo
extends AetherAwareMojo {
    public static final String VERSION_NUMBER_PATTERN_STRING = "([\\d\\.]*\\d)(.*)";
    static final Pattern FUZZY_VERSION = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);
    protected File inputManifestFile;
    protected List<String> jarDirectories;
    protected File propertiesInputFile;
    protected File propertiesOutputFile;
    protected List<String> manualPackageList;
    protected boolean scanDependencies = true;
    protected boolean exportEachPackageOnce = false;
    protected List<String> artifactExcludes;
    private static final String ARTIFACT_EXCLUDE_DEFAULT_VALUE = "org.jahia.modules:*,org.jahia.templates:*,org.jahia.test:*,*.jahia.modules";
    protected List<String> packageExcludes;
    private static final String PACKAGE_EXCLUDE_DEFAULT_VALUE = "org.jahia.taglibs*,org.apache.taglibs.standard*,javax.servlet.jsp*,org.codehaus.groovy.ast*,javax.el*,de.odysseus.el*";
    protected boolean outputPackagesWithNoVersions = true;
    protected String propertyFilePropertyName = "org.osgi.framework.system.packages.extra";
    protected String propertyFileSystemPackagesPropertyName = "org.osgi.framework.system.packages";
    protected String propertyFileBootDelegationPropertyName = "org.osgi.framework.bootdelegation";
    private List<Pattern> artifactExclusionPatterns = new ArrayList<Pattern>();
    private List<Pattern> packageExclusionPatterns = new ArrayList<Pattern>();

    public void setPackageExcludes(List<String> packageExcludes) {
        this.packageExcludes = packageExcludes;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.buildExclusionPatterns();
        this.buildPackageExcludes();
        TreeMap<String, Map<String, Map<String, VersionLocation>>> packageVersionCounts = new TreeMap<String, Map<String, Map<String, VersionLocation>>>();
        TreeMap<String, Set<String>> packageVersions = new TreeMap<String, Set<String>>();
        String generatedPackageList = null;
        try {
            this.scanExistingExports(packageVersionCounts);
            if (this.project != null) {
                if (this.scanDependencies) {
                    this.scanDependencies(packageVersionCounts);
                }
                this.scanClassesBuildDirectory(packageVersionCounts);
                this.scanJarDirectories(packageVersionCounts);
            }
            this.scanExistingManifest(packageVersionCounts);
            this.excludeSystemPackages(packageVersionCounts);
            this.resolveSplitPackages(packageVersionCounts, packageVersions);
            if (this.propertiesOutputFile != null && !this.propertiesOutputFile.exists()) {
                this.propertiesOutputFile.getParentFile().mkdirs();
                this.propertiesOutputFile.createNewFile();
            }
            ArrayList<String> packageList = new ArrayList<String>();
            StringBuilder generatedPackageBuffer = new StringBuilder();
            for (Map.Entry packageVersion : packageVersions.entrySet()) {
                if (packageVersion.getValue() == null) continue;
                boolean allVersionsAreNull = true;
                for (String versionString : (Set)packageVersion.getValue()) {
                    if (versionString == null) continue;
                    allVersionsAreNull = false;
                    StringBuilder packageExport = new StringBuilder();
                    packageExport.append((String)packageVersion.getKey());
                    versionString = BuildFrameworkPackageListMojo.cleanupVersion(versionString);
                    packageExport.append(";version=\"");
                    packageExport.append(versionString);
                    packageExport.append("\"");
                    if (!this.isPackageExcluded(packageExport.toString()) && !this.isPackageExcluded((String)packageVersion.getKey())) {
                        packageExport.append(",");
                        if (packageList.contains(packageExport.toString())) {
                            this.getLog().warn((CharSequence)("Package export " + packageExport.toString() + " already present in list, will not add again!"));
                        } else {
                            packageList.add(packageExport.toString());
                        }
                        generatedPackageBuffer.append((CharSequence)packageExport);
                        continue;
                    }
                    this.getLog().info((CharSequence)("Package " + packageExport.toString() + " matched exclusion list, will not be included !"));
                }
                if (!allVersionsAreNull || !this.outputPackagesWithNoVersions) continue;
                StringBuilder packageExport = new StringBuilder();
                packageExport.append((String)packageVersion.getKey());
                if (!this.isPackageExcluded(packageExport.toString())) {
                    packageExport.append(",");
                    if (packageList.contains(packageExport.toString())) {
                        this.getLog().warn((CharSequence)("Package export " + packageExport.toString() + " already present in list, will not add again!"));
                    } else {
                        this.getLog().info((CharSequence)("Adding package " + packageExport.toString() + " with no version"));
                        packageList.add(packageExport.toString());
                    }
                    generatedPackageBuffer.append((CharSequence)packageExport);
                    continue;
                }
                this.getLog().info((CharSequence)("Package " + packageExport.toString() + " matched exclusion list, will not be included !"));
            }
            if (this.manualPackageList != null) {
                for (String manualPackage : this.manualPackageList) {
                    if (!packageList.contains(manualPackage + ",") && !this.isPackageExcluded(manualPackage)) {
                        packageList.add(manualPackage + ",");
                        generatedPackageBuffer.append(manualPackage);
                        generatedPackageBuffer.append(",");
                        continue;
                    }
                    if (!this.isPackageExcluded(manualPackage)) continue;
                    this.getLog().info((CharSequence)("Package " + manualPackage + " matched exclusion list, will not be included !"));
                }
            }
            generatedPackageList = generatedPackageBuffer.toString();
            generatedPackageList = generatedPackageList.substring(0, generatedPackageList.length() - 1);
            String lastPackage = (String)packageList.remove(packageList.size() - 1);
            packageList.add(lastPackage.substring(0, lastPackage.length() - 1));
            this.getLog().info((CharSequence)("Found " + packageVersions.size() + " packages in dependencies."));
            if (generatedPackageList != null && this.project != null) {
                this.project.getProperties().put("jahiaGeneratedFrameworkPackageList", generatedPackageList);
            }
            PropertyFileUtils.updatePropertyFile((File)this.propertiesInputFile, (File)this.propertiesOutputFile, (String)this.propertyFilePropertyName, (String[])packageList.toArray(new String[packageList.size()]), (Logger)new SLF4JLoggerToMojoLogBridge(this.getLog()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildExclusionPatterns() {
        if (this.artifactExcludes == null) {
            String[] artifactExcludesArray = ARTIFACT_EXCLUDE_DEFAULT_VALUE.split(",");
            this.artifactExcludes = new ArrayList<String>(Arrays.asList(artifactExcludesArray));
        }
        for (String artifactExclude : this.artifactExcludes) {
            int colonPos = artifactExclude.indexOf(":");
            String groupPattern = ".*";
            String artifactPattern = null;
            if (colonPos > -1) {
                groupPattern = artifactExclude.substring(0, colonPos);
                artifactPattern = artifactExclude.substring(colonPos + 1);
            } else {
                artifactPattern = artifactExclude;
            }
            groupPattern = groupPattern.replaceAll("\\.", "\\\\.");
            groupPattern = groupPattern.replaceAll("\\*", ".*");
            artifactPattern = artifactPattern.replaceAll("\\.", "\\\\.");
            artifactPattern = artifactPattern.replaceAll("\\*", ".*");
            this.artifactExclusionPatterns.add(Pattern.compile(groupPattern + ":" + artifactPattern));
        }
    }

    private void buildPackageExcludes() {
        if (this.packageExcludes == null) {
            String[] packageExcludesArray = PACKAGE_EXCLUDE_DEFAULT_VALUE.split(",");
            this.packageExcludes = new ArrayList<String>(Arrays.asList(packageExcludesArray));
        }
        Iterator<String> i$ = this.packageExcludes.iterator();
        while (i$.hasNext()) {
            String packageExclude;
            String packageExcludePattern = packageExclude = i$.next();
            packageExcludePattern = packageExcludePattern.replaceAll("\\.", "\\\\.");
            packageExcludePattern = packageExcludePattern.replaceAll("\\*", ".*");
            this.packageExclusionPatterns.add(Pattern.compile(packageExcludePattern));
        }
    }

    private boolean isPackageExcluded(String packageExport) {
        for (Pattern packageExclusionPattern : this.packageExclusionPatterns) {
            Matcher packageExclusionMatcher = packageExclusionPattern.matcher(packageExport);
            if (!packageExclusionMatcher.matches()) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void scanExistingExports(Map<String, Map<String, Map<String, VersionLocation>>> packageVersionCounts) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanExistingManifest(Map<String, Map<String, Map<String, VersionLocation>>> packageVersionCounts) throws IOException, Exception {
        block9: {
            FileInputStream in = null;
            try {
                if (!this.inputManifestFile.exists()) break block9;
                in = new FileInputStream(this.inputManifestFile);
                Manifest mf = new Manifest(in);
                String exportPackageStr = mf.getMainAttributes().getValue("Export-Package");
                String bundleVersion = mf.getMainAttributes().getValue("Bundle-Version");
                ManifestElement[] manifestElements = ManifestElement.parseHeader((String)"Export-Package", (String)exportPackageStr);
                if (manifestElements == null) break block9;
                for (ManifestElement manifestElement : manifestElements) {
                    String[] packageNames = manifestElement.getValueComponents();
                    String version = manifestElement.getAttribute("version");
                    if (version != null) {
                        for (String packageName : packageNames) {
                            if (version.equals(bundleVersion)) {
                                if (packageName.startsWith("org.jahia")) {
                                    this.updateVersionLocationCounts(packageVersionCounts, this.inputManifestFile.toString(), version, bundleVersion, packageName);
                                    continue;
                                }
                                this.updateVersionLocationCounts(packageVersionCounts, this.inputManifestFile.toString(), null, bundleVersion, packageName);
                                continue;
                            }
                            this.updateVersionLocationCounts(packageVersionCounts, this.inputManifestFile.toString(), version, bundleVersion, packageName);
                        }
                        continue;
                    }
                    for (String packageName : packageNames) {
                        this.updateVersionLocationCounts(packageVersionCounts, this.inputManifestFile.toString(), null, bundleVersion, packageName);
                    }
                }
                this.getLog().info((CharSequence)("Found " + manifestElements.length + " package exports."));
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
    }

    private void resolveSplitPackages(Map<String, Map<String, Map<String, VersionLocation>>> packageVersionCounts, Map<String, Set<String>> packageVersions) {
        for (Map.Entry<String, Map<String, Map<String, VersionLocation>>> resolvedPackageVersion : packageVersionCounts.entrySet()) {
            boolean allVersionsEqual = true;
            Set<String> previousVersions = null;
            for (Map.Entry<String, Map<String, VersionLocation>> versionLocationEntry : resolvedPackageVersion.getValue().entrySet()) {
                if (previousVersions != null && !previousVersions.equals(versionLocationEntry.getValue().keySet())) {
                    allVersionsEqual = false;
                    break;
                }
                previousVersions = versionLocationEntry.getValue().keySet();
            }
            if (resolvedPackageVersion.getValue().size() > 1 && !allVersionsEqual) {
                this.getLog().warn((CharSequence)("Split-package with different versions detected for package " + resolvedPackageVersion.getKey() + ":"));
            }
            HashSet<String> versions = new HashSet<String>();
            for (Map.Entry<String, Map<String, VersionLocation>> versionLocationEntry : resolvedPackageVersion.getValue().entrySet()) {
                if (resolvedPackageVersion.getValue().size() > 1 && !allVersionsEqual) {
                    for (Map.Entry entry : versionLocationEntry.getValue().entrySet()) {
                        this.getLog().warn((CharSequence)("  - " + versionLocationEntry.getKey() + " v" + ((VersionLocation)entry.getValue()).getVersion() + " count=" + ((VersionLocation)entry.getValue()).getCounter() + " Specification-Version=" + ((VersionLocation)entry.getValue()).getSpecificationVersion()));
                    }
                }
                if (versionLocationEntry.getValue() == null) continue;
                for (String string : versionLocationEntry.getValue().keySet()) {
                    if (versions.contains(string)) continue;
                    versions.add(string);
                }
            }
            packageVersions.put(resolvedPackageVersion.getKey(), versions);
        }
    }

    private void scanClassesBuildDirectory(Map<String, Map<String, Map<String, VersionLocation>>> packageVersionCounts) throws IOException {
        String[] includedFiles;
        File outputDirectoryFile = new File(this.project.getBuild().getOutputDirectory());
        this.getLog().info((CharSequence)("Scanning project build directory " + outputDirectoryFile.getCanonicalPath()));
        DirectoryScanner ds = new DirectoryScanner();
        String[] excludes = new String[]{"META-INF/**", "OSGI-INF/**", "OSGI-OPT/**", "WEB-INF/**"};
        ds.setExcludes(excludes);
        ds.setBasedir(outputDirectoryFile);
        ds.setCaseSensitive(true);
        ds.scan();
        for (String includedFile : includedFiles = ds.getIncludedFiles()) {
            String entryPackage = "";
            int lastSlash = includedFile.lastIndexOf("/");
            if (lastSlash <= -1) continue;
            entryPackage = includedFile.substring(0, lastSlash);
            if (!StringUtils.isNotEmpty((String)(entryPackage = entryPackage.replaceAll("/", "."))) || entryPackage.startsWith("META-INF") || entryPackage.startsWith("OSGI-INF") || entryPackage.startsWith("OSGI-OPT") || entryPackage.startsWith("WEB-INF") || entryPackage.startsWith("org.osgi")) continue;
            this.updateVersionLocationCounts(packageVersionCounts, this.project.getBuild().getFinalName(), this.project.getVersion(), null, entryPackage);
        }
    }

    private void scanDependencies(Map<String, Map<String, Map<String, VersionLocation>>> packageVersionCounts) throws IOException {
        this.getLog().info((CharSequence)"Scanning project dependencies...");
        for (Artifact artifact : this.project.getArtifacts()) {
            String exclusionMatched = null;
            for (Pattern exclusionPattern : this.artifactExclusionPatterns) {
                Matcher exclusionMatcher = exclusionPattern.matcher(artifact.getGroupId() + ":" + artifact.getArtifactId());
                if (!exclusionMatcher.matches()) continue;
                exclusionMatched = artifact.getGroupId() + ":" + artifact.getArtifactId();
                break;
            }
            if (exclusionMatched != null) {
                this.getLog().info((CharSequence)("Matched exclusion " + exclusionMatched + ", ignoring artifact."));
                continue;
            }
            if (!artifact.getScope().contains("provided") && !artifact.getScope().contains("compile") && !artifact.getScope().contains("runtime")) continue;
            if (!artifact.getType().equals("jar")) {
                this.getLog().warn((CharSequence)("Ignoring artifact " + artifact.getFile() + " since it is of type " + artifact.getType()));
                continue;
            }
            this.getLog().debug((CharSequence)("Scanning dependency " + artifact.getFile()));
            this.scanJar(packageVersionCounts, artifact.getFile(), artifact.getBaseVersion());
        }
    }

    private void scanJar(Map<String, Map<String, Map<String, VersionLocation>>> packageVersionCounts, File jarFile, String defaultVersion) throws IOException {
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFile));
        Manifest jarManifest = jarInputStream.getManifest();
        String specificationVersion = null;
        if (jarManifest == null) {
            this.getLog().warn((CharSequence)("No MANIFEST.MF file found for dependency " + jarFile));
        } else if (jarManifest.getMainAttributes() == null) {
            this.getLog().warn((CharSequence)("No main attributes found in MANIFEST.MF file found for dependency " + jarFile));
        } else {
            String exportPackageHeaderValue;
            specificationVersion = jarManifest.getMainAttributes().getValue("Specification-Version");
            if (defaultVersion == null && jarManifest.getMainAttributes().getValue("Bundle-Version") == null) {
                defaultVersion = specificationVersion != null ? specificationVersion : jarManifest.getMainAttributes().getValue("Implementation-Version");
            }
            if ((exportPackageHeaderValue = jarManifest.getMainAttributes().getValue("Export-Package")) != null) {
                ManifestElement[] manifestElements = new ManifestElement[]{};
                try {
                    manifestElements = ManifestElement.parseHeader((String)"Export-Package", (String)exportPackageHeaderValue);
                }
                catch (BundleException e) {
                    this.getLog().warn((CharSequence)("Error while parsing Export-Package header value for jar " + jarFile), (Throwable)e);
                }
                for (ManifestElement manifestElement : manifestElements) {
                    String[] packageNames = manifestElement.getValueComponents();
                    String version = manifestElement.getAttribute("version");
                    for (String packageName : packageNames) {
                        this.updateVersionLocationCounts(packageVersionCounts, jarFile.getCanonicalPath(), version, version, packageName);
                    }
                }
            }
            for (Map.Entry<String, Attributes> manifestEntries : jarManifest.getEntries().entrySet()) {
                String packageName = manifestEntries.getKey().replaceAll("/", ".");
                if (packageName.endsWith(".class")) continue;
                if (packageName.endsWith(".")) {
                    packageName = packageName.substring(0, packageName.length() - 1);
                }
                if (packageName.endsWith(".*")) {
                    packageName = packageName.substring(0, packageName.length() - 1);
                }
                int lastDotPos = packageName.lastIndexOf(".");
                String lastPackage = packageName;
                if (lastDotPos > -1) {
                    lastPackage = packageName.substring(lastDotPos + 1);
                }
                if (lastPackage.length() > 0 && Character.isUpperCase(lastPackage.charAt(0)) || StringUtils.isEmpty((String)packageName) || packageName.startsWith("META-INF") || packageName.startsWith("OSGI-INF") || packageName.startsWith("OSGI-OPT") || packageName.startsWith("WEB-INF") || packageName.startsWith("org.osgi")) continue;
                String packageVersion = null;
                packageVersion = manifestEntries.getValue().getValue("Specification-Version") != null ? manifestEntries.getValue().getValue("Specification-Version") : manifestEntries.getValue().getValue("Implementation-Version");
                if (packageVersion == null) continue;
                this.getLog().info((CharSequence)("Found package version in " + jarFile.getName() + " MANIFEST : " + packageName + " v" + packageVersion));
                this.updateVersionLocationCounts(packageVersionCounts, jarFile.getCanonicalPath(), packageVersion, specificationVersion, packageName);
            }
        }
        JarEntry jarEntry = null;
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            if (jarEntry.isDirectory()) continue;
            String entryName = jarEntry.getName();
            String entryPackage = "";
            int lastSlash = entryName.lastIndexOf("/");
            if (lastSlash <= -1) continue;
            entryPackage = entryName.substring(0, lastSlash);
            if (!StringUtils.isNotEmpty((String)(entryPackage = entryPackage.replaceAll("/", "."))) || entryPackage.startsWith("META-INF") || entryPackage.startsWith("OSGI-INF") || entryPackage.startsWith("OSGI-OPT") || entryPackage.startsWith("WEB-INF") || entryPackage.startsWith("org.osgi")) continue;
            this.updateVersionLocationCounts(packageVersionCounts, jarFile.getCanonicalPath(), defaultVersion, specificationVersion, entryPackage);
        }
        jarInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excludePackages(Map<String, Map<String, Map<String, VersionLocation>>> packageVersionCounts, String propertyFileExclusionPropertyName) throws IOException, MojoExecutionException {
        String packageExclusionList;
        FileInputStream fileInputStream;
        block9: {
            if (!this.propertiesInputFile.exists()) {
                return;
            }
            fileInputStream = null;
            Properties properties = new Properties();
            fileInputStream = new FileInputStream(this.propertiesInputFile);
            properties.load(fileInputStream);
            packageExclusionList = (String)properties.get(propertyFileExclusionPropertyName);
            if (packageExclusionList != null) break block9;
            IOUtils.closeQuietly((InputStream)fileInputStream);
            return;
        }
        try {
            ManifestValueParser manifestValueParser = new ManifestValueParser(propertyFileExclusionPropertyName, packageExclusionList, true);
            List exclusionValueClauses = manifestValueParser.getManifestValueClauses();
            ArrayList<String> excludedPatterns = new ArrayList<String>();
            ArrayList<String> excludedPackages = new ArrayList<String>();
            for (ManifestValueClause exclusionValueClause : exclusionValueClauses) {
                for (String exclusionPath : exclusionValueClause.getPaths()) {
                    if (exclusionPath.endsWith(".*")) {
                        excludedPatterns.add(exclusionPath.substring(0, exclusionPath.length() - 2));
                        continue;
                    }
                    excludedPackages.add(exclusionPath);
                }
            }
            for (String pack : packageVersionCounts.keySet()) {
                for (String pattern : excludedPatterns) {
                    if (!pack.startsWith(pattern)) continue;
                    excludedPackages.add(pack);
                }
            }
            packageVersionCounts.keySet().removeAll(excludedPackages);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
    }

    private void excludeSystemPackages(Map<String, Map<String, Map<String, VersionLocation>>> packageVersionCounts) throws IOException, MojoExecutionException {
        this.excludePackages(packageVersionCounts, this.propertyFileSystemPackagesPropertyName);
    }

    private void updateVersionLocationCounts(Map<String, Map<String, Map<String, VersionLocation>>> packageVersionCounts, String originLocation, String newVersion, String specificationVersion, String packageName) throws IOException {
        Map<String, VersionLocation> existingVersionLocations;
        Map<String, Map<String, VersionLocation>> versionLocations = packageVersionCounts.get(packageName);
        if (versionLocations == null) {
            versionLocations = new HashMap<String, Map<String, VersionLocation>>();
        }
        if ((existingVersionLocations = versionLocations.get(originLocation)) != null && existingVersionLocations.containsKey(newVersion)) {
            VersionLocation existingVersionLocation = existingVersionLocations.get(newVersion);
            existingVersionLocation.incrementCounter();
            existingVersionLocations.put(newVersion, existingVersionLocation);
        } else {
            if (existingVersionLocations == null) {
                existingVersionLocations = new HashMap<String, VersionLocation>();
            }
            VersionLocation existingVersionLocation = new VersionLocation(originLocation, BuildFrameworkPackageListMojo.cleanupVersion(newVersion), specificationVersion);
            existingVersionLocation.incrementCounter();
            existingVersionLocations.put(newVersion, existingVersionLocation);
        }
        versionLocations.put(originLocation, existingVersionLocations);
        packageVersionCounts.put(packageName, versionLocations);
    }

    private void scanJarDirectories(Map<String, Map<String, Map<String, VersionLocation>>> packageVersionCounts) throws IOException, MojoExecutionException {
        if (this.jarDirectories == null || this.jarDirectories.size() == 0) {
            return;
        }
        for (String jarDirectory : this.jarDirectories) {
            String[] includedFiles;
            File jarDirectoryFile = new File(jarDirectory);
            if (!jarDirectoryFile.exists() || !jarDirectoryFile.isDirectory()) {
                this.getLog().warn((CharSequence)("Ignoring invalid directory " + jarDirectory + "."));
                continue;
            }
            this.getLog().info((CharSequence)("Scanning JARs in directory " + jarDirectory + "..."));
            DirectoryScanner ds = new DirectoryScanner();
            String[] includes = new String[]{"*.jar"};
            ds.setIncludes(includes);
            ds.setBasedir(jarDirectory);
            ds.setCaseSensitive(true);
            ds.scan();
            for (String includeFile : includedFiles = ds.getIncludedFiles()) {
                String version = null;
                File includedFileFile = new File(jarDirectoryFile, includeFile);
                String artifactFileName = includedFileFile.getName();
                List<String> versions = this.getAetherHelper().getDependencyVersion(this.project, artifactFileName);
                if (versions.size() > 1) {
                    this.getLog().warn((CharSequence)("multiple matching dependencies found for artifactId " + artifactFileName));
                } else if (versions.size() == 1) {
                    version = versions.iterator().next();
                } else {
                    this.getLog().warn((CharSequence)("Couldn't find dependency for artifactId " + artifactFileName));
                }
                this.scanJar(packageVersionCounts, includedFileFile, version);
            }
        }
    }

    public static String cleanupVersion(String version) {
        if (version != null) {
            StringBuffer result = new StringBuffer();
            Matcher m = FUZZY_VERSION.matcher(version);
            if (m.matches()) {
                String major = m.group(1);
                String minor = m.group(3);
                String micro = m.group(5);
                String qualifier = m.group(7);
                if (major != null) {
                    result.append(major);
                    if (minor != null) {
                        result.append(".");
                        result.append(minor);
                        if (micro != null) {
                            result.append(".");
                            result.append(micro);
                            if (qualifier != null) {
                                result.append(".");
                                BuildFrameworkPackageListMojo.cleanupModifier(result, qualifier);
                            }
                        } else if (qualifier != null) {
                            result.append(".0.");
                            BuildFrameworkPackageListMojo.cleanupModifier(result, qualifier);
                        } else {
                            result.append(".0");
                        }
                    } else if (qualifier != null) {
                        result.append(".0.0.");
                        BuildFrameworkPackageListMojo.cleanupModifier(result, qualifier);
                    } else {
                        result.append(".0.0");
                    }
                }
            } else {
                result.append("0.0.0.");
                BuildFrameworkPackageListMojo.cleanupModifier(result, version);
            }
            return result.toString();
        }
        return null;
    }

    static void cleanupModifier(StringBuffer result, String modifier) {
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                result.append(c);
                continue;
            }
            result.append('_');
        }
    }

    private class VersionLocation {
        private String location;
        private String version;
        private String specificationVersion;
        private long counter = 0L;

        public VersionLocation(String location, String version, String specificationVersion) {
            this.location = location;
            this.version = version;
            this.specificationVersion = specificationVersion;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSpecificationVersion() {
            return this.specificationVersion;
        }

        public void incrementCounter() {
            ++this.counter;
        }

        public long getCounter() {
            return this.counter;
        }
    }
}

