/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.SelectorUtils;
import org.jahia.configuration.deployers.ServerDeploymentInterface;
import org.jahia.configuration.logging.AbstractLogger;
import org.jahia.configuration.modules.ModuleDeployer;
import org.jahia.utils.maven.plugin.AbstractManagementMojo;
import org.jahia.utils.maven.plugin.MojoLogger;
import org.jahia.utils.maven.plugin.support.AetherHelper;
import org.jahia.utils.maven.plugin.support.AetherHelperFactory;

public class DeployMojo
extends AbstractManagementMojo {
    private static final Set<String> JAHIA_SYSTEM_BUNDLES = new HashSet<String>(Arrays.asList("org.jahia.bundles.url.jahiawar", "org.jahia.bundles.extender.jahiamodules", "org.jahia.bundles.blueprint.extender.config", "org.jahia.bundles.http.bridge", "org.jahia.bundles.webconsole.config", "org.jahia.bundles.jspapiusage.repackaging", "org.jahia.bundles.configadmin.persistence", "org.jahia.bundles.clustering", "org.jahia.bundles.clustering.enabler", "org.jahia.bundles.hazelcast.discovery", "org.jahia.bundles.spring.bridge"));
    private static final Set<String> JAHIA_PACKAGE_PROJECTS = new HashSet<String>(Arrays.asList("jahia-data", "jahia-core-modules", "jahia-additional-modules", "jahia-ee-data", "jahia-ee-core-modules", "jahia-ee-additional-modules"));
    private DependencyTreeBuilder dependencyTreeBuilder;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private String address;
    private boolean deployTests;
    private AetherHelper aetherHelper;
    private PlexusContainer container;
    private MavenSession mavenSession;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.targetServerDirectory != null) {
                this.deployProject();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error when deploying", e);
        }
    }

    @Override
    public void doValidate() throws MojoExecutionException, MojoFailureException {
        ServerDeploymentInterface serverDeployer = null;
        try {
            serverDeployer = this.getDeployer();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while validating deployers", e);
        }
        if (serverDeployer == null) {
            throw new MojoFailureException("Server " + this.targetServerType + " v" + this.targetServerVersion + " not (yet) supported by this plugin.");
        }
        if (!this.getDeployer().validateInstallationDirectory()) {
            throw new MojoFailureException("Directory " + this.targetServerDirectory + " is not a valid installation directory for server " + this.getDeployer().getName());
        }
    }

    private void deployProject() throws Exception {
        if (this.skipDeploy()) {
            this.getLog().info((CharSequence)"jahia.deploy.skip is set to 'true' for the current project. Skip deploying it.");
            return;
        }
        if (this.project.getPackaging().equals("ear")) {
            this.deployEarProject();
        } else if (this.project.getPackaging().equals("war")) {
            if (this.project.getGroupId().equals("org.jahia.server") || this.project.getGroupId().equals("org.jahia.extensions")) {
                this.deployWarProject();
            } else if (this.project.getGroupId().equals("org.jahia.modules") || this.deployTests && this.project.getGroupId().equals("org.jahia.test") || this.project.getGroupId().endsWith(".jahia.modules")) {
                this.deployModuleProject();
            } else if (this.project.getGroupId().equals("org.jahia.test") && !this.deployTests) {
                this.getLog().info((CharSequence)"Deployment of test projects (with groupId 'org.jahia.test') is disabled by default. You can enable it by specifying -Djahia.deploy.deployTests option for the 'mvn jahia:deploy' command");
            } else {
                this.getLog().warn((CharSequence)"Unrecognized type of the WAR project. Skipping deployment");
            }
        } else if (this.project.getPackaging().equals("jar")) {
            if (this.project.getGroupId().equals("org.jahia.test") && !this.deployTests) {
                this.getLog().info((CharSequence)"Deployment of test projects (with groupId 'org.jahia.test') is disabled by default. You can enable it by specifying -Djahia.deploy.deployTests option for the 'mvn jahia:deploy' command");
            } else {
                this.deployJarProject();
            }
        } else if (this.project.getPackaging().equals("pom")) {
            this.deployPomProject();
        } else if (this.project.getPackaging().equals("bundle")) {
            boolean isJahiaTaglib = this.project.getArtifactId().equals("jahia-taglib");
            if (isJahiaTaglib) {
                this.deployJarProject();
            }
            if (this.project.getGroupId().equals("org.jahia.bundles") && JAHIA_SYSTEM_BUNDLES.contains(this.project.getArtifactId()) || isJahiaTaglib) {
                String fileName = this.project.getArtifactId() + "-" + this.project.getVersion() + "." + "jar";
                File srcFile = new File(this.output, fileName);
                File destDir = null;
                File karafDir = new File(this.getWebappDeploymentDir(), "WEB-INF/karaf/system");
                boolean karafDeployment = karafDir.isDirectory();
                destDir = karafDeployment ? new File(new File(karafDir, StringUtils.join((Object[])StringUtils.split((String)this.project.getGroupId(), (char)'.'), (char)File.separatorChar)), this.project.getArtifactId() + File.separatorChar + this.project.getVersion()) : new File(this.getWebappDeploymentDir(), "WEB-INF/bundles");
                FileUtils.copyFileToDirectory((File)srcFile, (File)destDir);
                this.getLog().info((CharSequence)("Copied " + srcFile + " to " + destDir));
                if (karafDeployment) {
                    this.copyToKarafDeploy(srcFile);
                } else {
                    this.removeCachedBundle(fileName, new File(this.getDataDir(), "bundles-deployed"));
                }
            } else {
                boolean isStandardModule;
                boolean bl = isStandardModule = this.project.getGroupId().equals("org.jahia.module") || this.project.getGroupId().endsWith(".jahia.modules");
                if (isStandardModule || this.isJahiaModuleBundle(new File(this.output, this.project.getArtifactId() + "-" + this.project.getVersion() + "." + "jar"))) {
                    this.deployModuleProject();
                } else {
                    File srcFile = new File(this.output, this.project.getArtifactId() + "-" + this.project.getVersion() + "." + "jar");
                    File destDir = null;
                    File karafDir = new File(this.getWebappDeploymentDir(), "WEB-INF/karaf/system");
                    boolean karafDeployment = karafDir.isDirectory();
                    destDir = karafDeployment ? new File(this.getDataDir(), "karaf/deploy") : new File(this.getDataDir(), "bundles");
                    FileUtils.copyFileToDirectory((File)srcFile, (File)destDir);
                    this.getLog().info((CharSequence)("Copied " + srcFile + " to " + destDir));
                }
            }
        }
    }

    private void copyToKarafDeploy(File srcFile) throws IOException {
        File deployDir = new File(this.getDataDir(), "karaf/deploy");
        this.getLog().info((CharSequence)("Copying file " + srcFile.getCanonicalPath() + " into folder " + deployDir.getCanonicalPath()));
        FileUtils.copyFileToDirectory((File)srcFile, (File)deployDir, (boolean)false);
        this.getLog().info((CharSequence)"...done");
    }

    private void removeCachedBundle(String fileName, File deployedBundeDir) {
        if (!deployedBundeDir.isDirectory()) {
            return;
        }
        for (File info : FileUtils.listFiles((File)deployedBundeDir, (IOFileFilter)new NameFileFilter("bundle.info"), (IOFileFilter)TrueFileFilter.INSTANCE)) {
            try {
                if (!FileUtils.readFileToString((File)info).contains(fileName)) continue;
                try {
                    FileUtils.deleteDirectory((File)info.getParentFile());
                    this.getLog().info((CharSequence)("Deleted deployed bundle in folder " + info.getParentFile()));
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Unable to deleted deployed bundle in folder " + info.getParentFile() + ". Cause: " + e.getMessage()));
                }
                break;
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJahiaModuleBundle(File file) {
        if (!file.exists()) {
            return false;
        }
        JarFile jar = null;
        try {
            jar = new JarFile(file, false);
            boolean bl = jar.getManifest().getMainAttributes().containsKey(new Attributes.Name("Jahia-Module-Type"));
            return bl;
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    this.getLog().warn((Throwable)e);
                }
            }
        }
        return false;
    }

    private boolean skipDeploy() {
        return Boolean.valueOf(this.project.getProperties().getProperty("jahia.deploy.skip", "false"));
    }

    private void deployEarProject() throws Exception {
        if (this.getDeployer().isEarDeployment()) {
            this.getLog().info((CharSequence)("Deploying application server specific files for " + this.getDeployer().getName() + " in directory " + this.targetServerDirectory));
            File targetEarFolder = this.getDeployer().getDeploymentFilePath("digitalfactory", "ear");
            this.getLog().info((CharSequence)("Updating EAR resources in " + targetEarFolder));
            int updateFileCount = this.updateFiles(new File(this.baseDir, "src/main/resources"), targetEarFolder);
            this.getLog().info((CharSequence)("Updated " + updateFileCount + " resources"));
            if ("jboss".equals(this.targetServerType)) {
                FileUtils.touch((File)new File(targetEarFolder.getParentFile(), targetEarFolder.getName() + ".dodeploy"));
            }
        }
    }

    private void deployWarProject() throws Exception {
        File dataPackage;
        File webappDir = this.getWebappDeploymentDir();
        this.getLog().info((CharSequence)("Update " + this.project.getPackaging() + " resources for " + this.getDeployer().getName() + " in directory " + webappDir));
        if ("was".equals(this.targetServerType)) {
            File source = new File(this.output, this.project.getBuild().getFinalName() + ".war");
            File target = new File(webappDir + "/" + this.project.getBuild().getFinalName() + ".war");
            try {
                FileUtils.copyFile((File)source, (File)target);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error while deploying WAR project", (Throwable)e);
            }
        } else {
            try {
                String[] excludes;
                ZipUnArchiver unarch = new ZipUnArchiver(new File(this.output, this.project.getBuild().getFinalName() + ".war"));
                unarch.enableLogging((Logger)(this.getLog().isDebugEnabled() ? new ConsoleLogger(0, "console") : new ConsoleLogger()));
                if (!webappDir.exists() && !webappDir.mkdirs()) {
                    throw new IOException("Unable to create target WAR directory " + webappDir);
                }
                unarch.setDestDirectory(webappDir);
                String warExcludes = this.getDeployer().getWarExcludes();
                String[] stringArray = excludes = warExcludes != null ? StringUtils.split((String)warExcludes, (String)" ,") : null;
                if (excludes != null && excludes.length > 0) {
                    IncludeExcludeFileSelector selector = new IncludeExcludeFileSelector();
                    selector.setExcludes(excludes);
                    unarch.setFileSelectors(new FileSelector[]{selector});
                }
                unarch.extract();
                this.getLog().info((CharSequence)"...done.");
            }
            catch (ArchiverException e) {
                this.getLog().error((CharSequence)"Error while deploying WAR project", (Throwable)e);
            }
        }
        if ((this.project.getArtifactId().equals("jahia-war") || this.project.getArtifactId().equals("jahia-ee-war")) && (dataPackage = this.getAetherHelper().resolveArtifactFile(this.project.getGroupId() + ":" + this.project.getArtifactId() + ":zip:data-package:" + this.project.getArtifact().getVersion())) != null) {
            this.deployPackageFile(dataPackage);
        }
    }

    private void deployModuleProject() throws Exception {
        File source = new File(this.output, this.project.getArtifactId() + "-" + this.project.getVersion() + "." + (this.project.getPackaging().equals("bundle") ? "jar" : this.project.getPackaging()));
        File target = new File(this.getDataDir(), "modules");
        this.getLog().info((CharSequence)("Deploying module " + source + " into " + target));
        new ModuleDeployer(target, (AbstractLogger)new MojoLogger(this.getLog())).deployModule(source);
        this.getLog().info((CharSequence)"...done");
    }

    private void deployModuleAsDependency(Artifact module) throws Exception {
        File target = new File(this.getDataDir(), "modules");
        this.getLog().info((CharSequence)("Deploying module " + module.getArtifactId() + " into " + target + "..."));
        try {
            File file = this.resolveArtifactFile(module);
            new ModuleDeployer(target, (AbstractLogger)new MojoLogger(this.getLog())).deployModule(file);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        this.getLog().info((CharSequence)"...done");
    }

    private void deployPrepackagedSiteProject() throws Exception {
        if (this.project.getAttachedArtifacts().size() > 0) {
            Artifact artifact = (Artifact)this.project.getAttachedArtifacts().get(this.project.getAttachedArtifacts().size() - 1);
            try {
                this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                File libDir = new File(this.getDataDir(), "prepackagedSites");
                libDir.mkdirs();
                File file = new File(libDir, artifact.getArtifactId() + ".zip");
                this.getLog().info((CharSequence)("Deploying prepackaged site " + artifact.getFile().getName() + " to " + file));
                FileUtils.copyFile((File)artifact.getFile(), (File)file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void deployPrepackagedSiteAsDependency(Artifact artifact) throws Exception {
        File target = new File(this.getDataDir(), "prepackagedSites");
        this.getLog().info((CharSequence)("Deploying prepackaged site " + artifact.getArtifactId() + " into " + target + "..."));
        try {
            File file = this.resolveArtifactFile(artifact);
            FileUtils.copyFile((File)file, (File)new File(target, artifact.getArtifactId() + ".zip"));
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        this.getLog().info((CharSequence)"...done");
    }

    private void deployJarProject() {
        Artifact artifact = this.project.getArtifact();
        try {
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            File libDir = new File(new File(this.getWebappDeploymentDir(), "WEB-INF"), "lib");
            this.getLog().info((CharSequence)("Deploying jar file " + artifact.getFile().getName() + " to " + libDir));
            File deployedJar = new File(libDir, artifact.getFile().getName());
            boolean needHotSwap = deployedJar.exists();
            FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)libDir);
            if (needHotSwap) {
                this.hotSwap(deployedJar);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while deploying JAR project", (Throwable)e);
        }
    }

    private void deployPomProject() {
        try {
            boolean isJahiaServerGroup = this.project.getGroupId().equals("org.jahia.server");
            if (isJahiaServerGroup && JAHIA_PACKAGE_PROJECTS.contains(this.project.getArtifactId())) {
                this.deployPackage();
            } else if (this.project.getParent() != null && "prepackagedSites".equals(this.project.getParent().getArtifactId()) || this.project.getGroupId().equals("org.jahia.prepackagedsites")) {
                this.deployPrepackagedSiteProject();
            } else {
                boolean jdbcDrivers = isJahiaServerGroup && this.project.getArtifactId().startsWith("jdbc-drivers");
                boolean sharedLibraries = isJahiaServerGroup && this.project.getArtifactId().equals("shared-libraries");
                DependencyNode rootNode = this.getRootDependencyNode();
                List l = rootNode.getChildren();
                for (DependencyNode dependencyNode : l) {
                    Artifact artifact = dependencyNode.getArtifact();
                    if (artifact.getGroupId().equals("org.jahia.server")) {
                        String artifactId = artifact.getArtifactId();
                        if ((artifactId.equals("jahia-war") || artifactId.equals("jahia-ee-war")) && !StringUtils.equals((String)artifact.getClassifier(), (String)"data-package")) {
                            this.deployWarDependency(dependencyNode);
                        } else if (artifactId.equals("shared-libraries") || artifactId.startsWith("jdbc-drivers")) {
                            this.deploySharedLibraries(dependencyNode);
                        } else if (JAHIA_PACKAGE_PROJECTS.contains(artifactId) || (artifactId.equals("jahia-war") || artifactId.equals("jahia-ee-war")) && StringUtils.equals((String)artifact.getClassifier(), (String)"data-package")) {
                            this.deployPackageFromDepenendency(artifact);
                        }
                    } else if (artifact.getGroupId().equals("org.jahia.modules") || this.deployTests && artifact.getGroupId().equals("org.jahia.test") || artifact.getGroupId().endsWith(".jahia.modules")) {
                        this.deployModuleAsDependency(artifact);
                    } else if (artifact.getGroupId().equals("org.jahia.prepackagedsites")) {
                        this.deployPrepackagedSiteAsDependency(artifact);
                    }
                    if (sharedLibraries) {
                        this.deploySharedLibrary(artifact);
                        continue;
                    }
                    if (!jdbcDrivers) continue;
                    this.deployJdbcDriver(artifact);
                }
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while deploying POM project", (Throwable)e);
        }
    }

    private void deployPackage() {
        this.getLog().info((CharSequence)("Deploying Digital Experience Manager data package " + this.project.getArtifactId() + "..."));
        try {
            File file = null;
            this.getLog().info((CharSequence)"Resolving artifact file...");
            if (this.project.getAttachedArtifacts().size() > 0) {
                Artifact artifact = (Artifact)this.project.getAttachedArtifacts().get(this.project.getAttachedArtifacts().size() - 1);
                this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                file = artifact.getFile();
            } else {
                file = this.getAetherHelper().resolveArtifactFile(this.project.getGroupId() + ":" + this.project.getArtifactId() + ":zip:package:" + this.project.getArtifact().getVersion());
            }
            this.getLog().info((CharSequence)("...resolved to: " + file));
            this.deployPackageFile(file);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    private void deployPackageFromDepenendency(Artifact dependency) {
        this.getLog().info((CharSequence)("Deploying Digital Experience Manager data package " + dependency.getArtifactId() + "..."));
        try {
            File file = this.resolveArtifactFile(dependency);
            this.deployPackageFile(file);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    private File resolveArtifactFile(Artifact artifact) throws MojoExecutionException {
        File file = null;
        this.getLog().info((CharSequence)"Resolving artifact file...");
        file = this.getAetherHelper().resolveArtifactFile(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + (StringUtils.isNotEmpty((String)artifact.getClassifier()) ? artifact.getClassifier() + ":" : "") + artifact.getVersion());
        this.getLog().info((CharSequence)("...resolved to: " + file));
        return file;
    }

    private void deployPackageFile(File packageFile) {
        this.getLog().info((CharSequence)("Deploying Digital Experience Manager data package file " + packageFile + "..."));
        try {
            this.getLog().info((CharSequence)("Extracting content to data directory " + this.getDataDir() + "..."));
            ZipUnArchiver unarch = new ZipUnArchiver(packageFile);
            unarch.enableLogging((Logger)(this.getLog().isDebugEnabled() ? new ConsoleLogger(0, "console") : new ConsoleLogger()));
            unarch.setDestDirectory(this.getDataDir());
            unarch.extract();
            this.getLog().info((CharSequence)"...done.");
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    protected DependencyNode getRootDependencyNode() throws DependencyTreeBuilderException {
        return this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, null, this.artifactCollector);
    }

    private void deploySharedLibraries(DependencyNode dependencyNode) throws IOException, ArtifactResolutionException, ArtifactNotFoundException {
        boolean jdbcDrivers = dependencyNode.getArtifact().getArtifactId().startsWith("jdbc-drivers");
        for (DependencyNode node : dependencyNode.getChildren()) {
            Artifact artifact = node.getArtifact();
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            try {
                if (jdbcDrivers) {
                    this.deployJdbcDriver(artifact);
                    continue;
                }
                this.deploySharedLibrary(artifact);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error while deploying EAR dependency", (Throwable)e);
            }
        }
    }

    private void deploySharedLibrary(Artifact artifact) throws IOException {
        this.getLog().info((CharSequence)("Copy shared resource " + artifact.getFile().getName()));
        this.getDeployer().deploySharedLibraries(new File[]{artifact.getFile()});
    }

    private void deployJdbcDriver(Artifact artifact) throws IOException {
        this.getLog().info((CharSequence)("Deploying JDBC driver " + artifact.getFile().getName()));
        this.getDeployer().deployJdbcDriver(artifact.getFile());
    }

    protected void deployWarDependency(DependencyNode dependencyNode) throws Exception {
        Artifact artifact = dependencyNode.getArtifact();
        File webappDir = this.getWebappDeploymentDir();
        this.getLog().info((CharSequence)("Deploying artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()));
        this.getLog().info((CharSequence)("Updating " + artifact.getType() + " resources for " + this.getDeployer().getName() + " in directory " + webappDir));
        String[] excludes = this.getDeployer().getWarExcludes() != null ? StringUtils.split((String)this.getDeployer().getWarExcludes(), (String)",") : null;
        try {
            ZipEntry entry;
            ZipInputStream z = new ZipInputStream(new FileInputStream(artifact.getFile()));
            int cnt = 0;
            while ((entry = z.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    if (excludes != null) {
                        boolean doExclude = false;
                        for (String excludePattern : excludes) {
                            if (!SelectorUtils.matchPath((String)excludePattern, (String)entry.getName())) continue;
                            doExclude = true;
                            break;
                        }
                        if (doExclude) continue;
                    }
                    File target = new File(webappDir, entry.getName());
                    if (entry.getTime() <= target.lastModified()) continue;
                    target.getParentFile().mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(target);
                    IOUtils.copy((InputStream)z, (OutputStream)fileOutputStream);
                    fileOutputStream.close();
                    ++cnt;
                    continue;
                }
                new File(webappDir, entry.getName()).mkdir();
            }
            z.close();
            this.getLog().info((CharSequence)("Copied " + cnt + " files."));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error while deploying dependency", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hotSwap(File deployedJar) {
        int colonIndex = this.address.indexOf(58);
        String connectorName = this.address.substring(0, colonIndex);
        if (connectorName.equals("socket")) {
            connectorName = "com.sun.jdi.SocketAttach";
        } else if (connectorName.equals("shmem")) {
            connectorName = "com.sun.jdi.SharedMemoryAttach";
        }
        String argumentsString = this.address.substring(colonIndex + 1);
        AttachingConnector connector = (AttachingConnector)this.findConnector(connectorName);
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        StringTokenizer st = new StringTokenizer(argumentsString, ",");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int index = pair.indexOf(61);
            String name = pair.substring(0, index);
            String value = pair.substring(index + 1);
            Connector.Argument argument = arguments.get(name);
            if (argument == null) continue;
            argument.setValue(value);
        }
        HashMap<String, Long> dates = new HashMap<String, Long>();
        try {
            ZipEntry entry;
            ZipInputStream z = new ZipInputStream(new FileInputStream(deployedJar));
            while ((entry = z.getNextEntry()) != null) {
                dates.put(entry.getName(), entry.getTime());
            }
            z.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VirtualMachine vm = null;
        try {
            vm = connector.attach(arguments);
            this.getLog().info((CharSequence)("Connected to " + vm.name() + " " + vm.version()));
            HashMap<String, File> files = new HashMap<String, File>();
            this.parse(new File(this.output, "classes"), dates, "", files);
            this.getLog().debug((CharSequence)("Classes : " + files.keySet()));
            if (!files.isEmpty()) {
                this.reload(vm, files);
            }
        }
        catch (ConnectException e) {
            this.getLog().warn((CharSequence)("Cannot hotswap classes : " + e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalConnectorArgumentsException e) {
            e.printStackTrace();
        }
        finally {
            if (vm != null) {
                vm.dispose();
            }
        }
    }

    private Connector findConnector(String name) {
        List<Connector> connectors = Bootstrap.virtualMachineManager().allConnectors();
        for (Connector connector : connectors) {
            if (!connector.name().equals(name)) continue;
            return connector;
        }
        return null;
    }

    private void parse(File folder, Map<String, Long> dates, String base, Map<String, File> result) {
        File[] files;
        for (File file : files = folder.listFiles()) {
            String name;
            String classFileName;
            String filename = file.getName();
            if (file.isDirectory()) {
                this.parse(file, dates, base + filename + ".", result);
                continue;
            }
            if (!filename.endsWith(".class") || !dates.containsKey(classFileName = (name = base + filename.substring(0, filename.lastIndexOf("."))).replace(".", "/") + ".class")) continue;
            long l = dates.get(classFileName);
            if (file.lastModified() <= l) continue;
            result.put(name, file);
            this.getLog().debug((CharSequence)("Updated class : " + file));
        }
    }

    public void reload(VirtualMachine vm, Map<String, File> classFiles) {
        HashMap<ReferenceType, byte[]> map = new HashMap<ReferenceType, byte[]>();
        for (String className : classFiles.keySet()) {
            List<ReferenceType> classes = vm.classesByName(className);
            if (classes.size() != 1) continue;
            ReferenceType refType = classes.get(0);
            File f = classFiles.get(className);
            byte[] bytes = new byte[(int)f.length()];
            try {
                FileInputStream in = new FileInputStream(f);
                ((InputStream)in).read(bytes);
                ((InputStream)in).close();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Error reading file " + f), (Throwable)e);
                continue;
            }
            map.put(refType, bytes);
        }
        try {
            vm.redefineClasses(map);
            this.getLog().info((CharSequence)("Reloaded " + map.size() + " classes."));
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Cannot reload classes : " + e.getMessage()));
        }
    }

    public AetherHelper getAetherHelper() throws MojoExecutionException {
        if (this.aetherHelper == null) {
            this.aetherHelper = AetherHelperFactory.create(this.container, this.project, this.mavenSession, this.getLog());
        }
        return this.aetherHelper;
    }
}

