/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jahia.configuration.configurators.JahiaGlobalConfigurator;
import org.jahia.configuration.deployers.ServerDeploymentFactory;
import org.jahia.configuration.deployers.ServerDeploymentInterface;

public abstract class AbstractManagementMojo
extends AbstractMojo {
    protected String targetServerType = "tomcat";
    protected String targetServerVersion = "";
    protected String targetServerDirectory;
    public String webAppDirName;
    protected File baseDir;
    protected File output;
    private String jahiaVarDiskPath;
    private File dataDir;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    private ServerDeploymentInterface deployer;
    private File webappDeploymentDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.doValidate();
        this.doExecute();
    }

    public void doValidate() throws MojoExecutionException, MojoFailureException {
    }

    public abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected List<File> getDependencies(String[] artifacts) throws ArtifactNotFoundException, ArtifactResolutionException {
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < artifacts.length; ++i) {
            String curFQN = artifacts[i];
            StringTokenizer tokens = new StringTokenizer(curFQN, ":");
            String groupId = tokens.nextToken();
            String artifactId = tokens.nextToken();
            String versionId = tokens.nextToken();
            String typeId = "jar";
            if (tokens.hasMoreTokens()) {
                typeId = tokens.nextToken();
            }
            Artifact artifact = this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, versionId, typeId, null);
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            if (artifact.getFile() == null) {
                this.getLog().warn((CharSequence)("Unable to find file for artifact: " + artifact.getArtifactId()));
            }
            list.add(artifact.getFile());
        }
        return list;
    }

    protected int updateFiles(File sourceFolder, File destFolder) throws IOException {
        return this.updateFiles(sourceFolder, destFolder, null);
    }

    protected int updateFiles(File sourceFolder, File destFolder, String excluded) throws IOException {
        return this.updateFiles(sourceFolder, sourceFolder, destFolder, excluded);
    }

    protected int updateFiles(File sourceFolder, File originalSourceFolder, File destFolder, String excluded) throws IOException {
        long timer = System.currentTimeMillis();
        List filesToUpdate = org.codehaus.plexus.util.FileUtils.getFileNames((File)sourceFolder, (String)"**", (String)excluded, (boolean)false);
        int cnt = 0;
        for (String sourceFile : filesToUpdate) {
            File destFile = new File(destFolder, sourceFile);
            File origFile = new File(sourceFolder, sourceFile);
            File origSourceFile = new File(originalSourceFolder, sourceFile);
            long date = origFile.lastModified();
            if (origSourceFile.exists()) {
                date = origSourceFile.lastModified();
            }
            if (destFile.exists() && destFile.lastModified() >= date) continue;
            this.getLog().debug((CharSequence)("Copy " + origFile + " to " + destFile));
            FileUtils.copyFile((File)origFile, (File)destFile);
            ++cnt;
        }
        this.getLog().debug((CharSequence)("Copy took " + (System.currentTimeMillis() - timer)));
        timer = System.currentTimeMillis();
        org.codehaus.plexus.util.FileUtils.copyDirectoryLayout((File)sourceFolder, (File)destFolder, null, null);
        this.getLog().debug((CharSequence)("Dir layout took " + (System.currentTimeMillis() - timer)));
        return cnt;
    }

    protected String getWebappDeploymentDirName() {
        String dirName = this.getDeployer().getWebappDeploymentDirNameOverride();
        return dirName != null ? dirName : (this.webAppDirName != null ? this.webAppDirName : "jahia");
    }

    protected File getWebappDeploymentDir() {
        if (this.webappDeploymentDir == null) {
            this.webappDeploymentDir = this.getDeployer().getDeploymentDirPath(this.getWebappDeploymentDirName(), "war");
        }
        return this.webappDeploymentDir;
    }

    protected ServerDeploymentInterface getDeployer() {
        if (this.deployer == null) {
            this.deployer = ServerDeploymentFactory.getImplementation((String)this.targetServerType, (String)this.targetServerVersion, (File)new File(this.targetServerDirectory), null, null);
        }
        return this.deployer;
    }

    protected File getDataDir() {
        if (this.dataDir == null) {
            this.dataDir = JahiaGlobalConfigurator.resolveDataDir((String)this.getJahiaVarDiskPath(), (String)this.getWebappDeploymentDir().getAbsolutePath());
            this.getLog().info((CharSequence)("Data directory path resolved to: " + this.dataDir));
        }
        return this.dataDir;
    }

    public String getJahiaVarDiskPath() {
        if (this.jahiaVarDiskPath == null) {
            this.jahiaVarDiskPath = "${jahiaWebAppRoot}/WEB-INF/var/";
            if (this.targetServerType != null) {
                if (this.targetServerType.startsWith("jboss")) {
                    this.jahiaVarDiskPath = "${jahiaWebAppRoot}/../../../data/digital-factory-data/";
                } else if (this.targetServerType.startsWith("tomcat")) {
                    this.jahiaVarDiskPath = "${jahiaWebAppRoot}/../../digital-factory-data/";
                    File dir = JahiaGlobalConfigurator.resolveDataDir((String)this.jahiaVarDiskPath, (String)this.getWebappDeploymentDir().getAbsolutePath(), (boolean)false);
                    if (!dir.isDirectory()) {
                        this.jahiaVarDiskPath = "${jahiaWebAppRoot}/../../../digital-factory-data/";
                        dir = JahiaGlobalConfigurator.resolveDataDir((String)this.jahiaVarDiskPath, (String)this.getWebappDeploymentDir().getAbsolutePath(), (boolean)false);
                        if (!dir.isDirectory()) {
                            this.jahiaVarDiskPath = "${jahiaWebAppRoot}/../../digital-factory-data/";
                        }
                    }
                }
            }
            this.getLog().info((CharSequence)("Data directory path is set to \"" + this.jahiaVarDiskPath + "\"."));
        }
        return this.jahiaVarDiskPath;
    }
}

