/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.i18n;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.utils.i18n.HierarchicalResourceBundle;
import org.jahia.utils.i18n.JahiaResourceBundleControl;
import org.jahia.utils.i18n.JahiaTemplatesRBLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceBundles {
    private static final Logger logger = LoggerFactory.getLogger(ResourceBundles.class);
    public static final String JAHIA_INTERNAL_RESOURCES = "JahiaInternalResources";
    public static final String JAHIA_TYPES_RESOURCES = "JahiaTypesResources";

    public static void flushCache() {
        try {
            Field cacheList = ResourceBundle.class.getDeclaredField("cacheList");
            cacheList.setAccessible(true);
            ((Map)cacheList.get(ResourceBundle.class)).clear();
        }
        catch (NoSuchFieldException e) {
            logger.warn("Field cacheList not found on ResourceBundle object, this only works on Oracle JDK : " + e.getMessage());
        }
        catch (Exception e) {
            logger.warn("Unable to flush resource bundle cache", (Throwable)e);
        }
        JahiaTemplatesRBLoader.clearCache();
    }

    public static ResourceBundle get(JahiaTemplatesPackage pkg, Locale locale) {
        return ResourceBundles.get(pkg.getResourceBundleHierarchy(), locale);
    }

    protected static ResourceBundle get(List<String> bundleLookupChain, Locale locale) {
        if (bundleLookupChain == null || bundleLookupChain.isEmpty()) {
            throw new IllegalArgumentException("ResourceBundle lookup chain is empty");
        }
        return bundleLookupChain.size() > 1 ? new HierarchicalResourceBundle(bundleLookupChain, locale) : ResourceBundles.get(bundleLookupChain.get(0), locale);
    }

    public static ResourceBundle get(String primaryBundleName, JahiaTemplatesPackage pkg, Locale locale) {
        if (pkg == null) {
            return ResourceBundles.get(primaryBundleName, locale);
        }
        if (primaryBundleName == null || !pkg.getResourceBundleHierarchy().isEmpty() && pkg.getResourceBundleHierarchy().get(0).equals(primaryBundleName)) {
            return ResourceBundles.get(pkg, locale);
        }
        LinkedList<String> lookup = new LinkedList<String>();
        lookup.add(primaryBundleName);
        lookup.addAll(pkg.getResourceBundleHierarchy());
        return ResourceBundles.get(lookup, locale);
    }

    public static ResourceBundle get(String bundleName, Locale locale) {
        JahiaTemplatesPackage aPackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry().getPackageForResourceBundle(bundleName);
        if (aPackage != null && aPackage.getClassLoader() != null) {
            return ResourceBundle.getBundle(bundleName, locale, aPackage.getClassLoader(), JahiaResourceBundleControl.getInstance());
        }
        if (bundleName != null) {
            return ResourceBundle.getBundle(bundleName, locale, JahiaResourceBundleControl.getInstance());
        }
        return ResourceBundles.getInternal(locale);
    }

    public static ResourceBundle getInternal(Locale locale) {
        return ResourceBundles.get(JAHIA_INTERNAL_RESOURCES, locale);
    }

    private ResourceBundles() {
    }
}

