/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.i18n;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.utils.i18n.Messages;
import org.jahia.utils.i18n.ResourceBundles;

@Deprecated
public class JahiaResourceBundle
extends ResourceBundle {
    private final Locale locale;
    private final List<String> bundleLookupChain;
    private ResourceBundle bundle;
    public static final String JAHIA_INTERNAL_RESOURCES = "JahiaInternalResources";
    public static final String JAHIA_TYPES_RESOURCES = "JahiaTypesResources";

    public static void flushCache() {
        ResourceBundles.flushCache();
    }

    public JahiaResourceBundle(Locale locale, String templatesPackageName) {
        this(null, locale, templatesPackageName, null, null);
    }

    public JahiaResourceBundle(Locale locale, String templatesPackageName, String siteTemplatesPackageName) {
        this(null, locale, templatesPackageName, null, siteTemplatesPackageName);
    }

    public JahiaResourceBundle(String basename, Locale locale) {
        this(basename, locale, null, null, null);
    }

    public JahiaResourceBundle(Locale locale, String templatesPackageName, ClassLoader classLoader) {
        this(null, locale, templatesPackageName, classLoader, null);
    }

    public JahiaResourceBundle(String basename, Locale locale, String templatesPackageName) {
        this(basename, locale, templatesPackageName, null, null);
    }

    public JahiaResourceBundle(String basename, Locale locale, String templatesPackageName, ClassLoader classLoader) {
        this(basename, locale, templatesPackageName, classLoader, null);
    }

    public JahiaResourceBundle(String basename, Locale locale, String templatesPackageName, ClassLoader classLoader, String siteTemplatesPackageName) {
        JahiaTemplatesPackage tp;
        JahiaTemplatesPackage tp2;
        this.locale = locale;
        JahiaTemplateManagerService jahiaTemplateManagerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        List<String> tplBundles = null;
        if (templatesPackageName != null && (tp2 = jahiaTemplateManagerService.getTemplatePackage(templatesPackageName)) != null) {
            tplBundles = tp2.getResourceBundleHierarchy();
        }
        String primaryBundleName = null;
        if (siteTemplatesPackageName != null && !siteTemplatesPackageName.equals(templatesPackageName) && (tp = jahiaTemplateManagerService.getTemplatePackage(siteTemplatesPackageName)) != null) {
            primaryBundleName = tp.getResourceBundleName();
        }
        this.bundleLookupChain = new LinkedList<String>();
        if (primaryBundleName != null) {
            this.bundleLookupChain.add(primaryBundleName);
        }
        if (basename != null && (tplBundles == null || tplBundles.isEmpty() || tplBundles.get(0).equals(basename))) {
            this.bundleLookupChain.add(basename);
        }
        if (tplBundles != null) {
            for (String name : tplBundles) {
                if (basename != null && basename.equals(name)) continue;
                this.bundleLookupChain.add(name);
            }
        }
        if (this.bundleLookupChain == null || this.bundleLookupChain.isEmpty()) {
            throw new MissingResourceException("Cannot find resource bundle for base name '" + basename + "', module '" + templatesPackageName + "', site template set '" + siteTemplatesPackageName + "' and locale '" + locale + "'", null, null);
        }
    }

    protected ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundles.get(this.bundleLookupChain, this.locale);
        }
        return this.bundle;
    }

    @Override
    public Object handleGetObject(String s) {
        return this.getBundle().getObject(s);
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.getBundle().getKeys();
    }

    public static String getJahiaInternalResource(String key, Locale locale, String defaultValue) {
        return Messages.getInternal(key, locale, defaultValue);
    }

    public static String getJahiaInternalResource(String key, Locale locale) {
        return Messages.getInternal(key, locale);
    }

    public static String getString(String bundle, String key, Locale locale, String templatePackageName) {
        return JahiaResourceBundle.getString(bundle, key, locale, templatePackageName, null);
    }

    public static String getString(String bundle, String key, Locale locale, String templatePackageName, ClassLoader loader) {
        return Messages.get(bundle, templatePackageName != null ? ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackage(templatePackageName) : null, key, locale);
    }

    public static ResourceBundle lookupBundle(String baseName, Locale preferredLocale) {
        return ResourceBundles.get(baseName, preferredLocale);
    }

    public static ResourceBundle lookupBundle(String baseName, Locale preferredLocale, ClassLoader loader, boolean throwExeptionIfNotFound) {
        try {
            return JahiaResourceBundle.lookupBundle(baseName, preferredLocale);
        }
        catch (MissingResourceException e) {
            if (throwExeptionIfNotFound) {
                throw e;
            }
            return null;
        }
    }

    public static String interpolateResourceBunldeMacro(String input, Locale locale, String templatePackageName) {
        return Messages.interpolateResourceBundleMacro(input, locale, ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackage(templatePackageName));
    }

    public String get(String key, String defaultValue) {
        return this.getString(key, defaultValue);
    }

    public String getFormatted(String key, String defaultValue, Object ... arguments) {
        return Messages.format(this.get(key, defaultValue), arguments);
    }

    public String getString(String key, String defaultValue) {
        String message;
        try {
            message = this.getString(key);
        }
        catch (MissingResourceException e) {
            message = defaultValue;
        }
        return message;
    }

    public List<String> getLookupBundles() {
        return this.bundleLookupChain;
    }
}

