/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Url {
    private static final Logger logger = LoggerFactory.getLogger(Url.class);
    public static final Set<String> LOCALHOSTS = Collections.singleton("localhost");

    public static String encodeUrlParam(String inputString) {
        if (StringUtils.isEmpty((String)inputString)) {
            return inputString;
        }
        byte[] output = new byte[2048];
        Deflater compresser = new Deflater();
        try {
            compresser.setInput(inputString.getBytes("UTF-8"));
            compresser.finish();
            int compressedDataLength = compresser.deflate(output);
            byte[] copy = new byte[compressedDataLength];
            System.arraycopy(output, 0, copy, 0, Math.min(output.length, compressedDataLength));
            return Base64.encodeBase64URLSafeString((byte[])copy);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Not able to encode facet URL: " + inputString, (Throwable)e);
            return inputString;
        }
    }

    public static String decodeUrlParam(String inputString) {
        if (StringUtils.isEmpty((String)inputString)) {
            return inputString;
        }
        byte[] input = Base64.decodeBase64((String)inputString);
        Inflater decompresser = new Inflater();
        decompresser.setInput(input, 0, input.length);
        byte[] result = new byte[2048];
        String outputString = "";
        try {
            int resultlength = decompresser.inflate(result);
            decompresser.end();
            outputString = new String(result, 0, resultlength, "UTF-8");
        }
        catch (DataFormatException e) {
            logger.warn("Not able to decode facet URL: " + inputString, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Not able to decode facet URL: " + inputString, (Throwable)e);
        }
        return outputString;
    }

    public static boolean isLocalhost(String host) {
        return host != null && LOCALHOSTS.contains(host);
    }

    public static String appendServerNameIfNeeded(JCRNodeWrapper node, String nodeURL, HttpServletRequest request) throws RepositoryException, MalformedURLException {
        if (!SettingsBean.getInstance().isUrlRewriteUseAbsoluteUrls()) {
            return nodeURL;
        }
        String requestServerName = request.getServerName();
        if (Url.isLocalhost(requestServerName)) {
            return nodeURL;
        }
        String serverName = node.getResolveSite().getServerName();
        if (!(StringUtils.isEmpty((String)serverName) || Url.isLocalhost(serverName) || requestServerName.equals(serverName))) {
            int serverPort = SettingsBean.getInstance().getSiteURLPortOverride();
            if (serverPort == 0) {
                serverPort = request.getServerPort();
            }
            if (serverPort == 80 && "http".equals(request.getScheme()) || serverPort == 443 && "https".equals(request.getScheme())) {
                serverPort = -1;
            }
            nodeURL = new URL(request.getScheme(), serverName, serverPort, nodeURL).toString();
        }
        return nodeURL;
    }

    public static String getServer(HttpServletRequest request) {
        return Url.getServer(request.getScheme(), request.getServerName(), request.getServerPort());
    }

    public static String getServer(HttpServletRequest request, String servername) {
        return Url.getServer(request.getScheme(), servername, request.getServerPort());
    }

    public static String getServer(String scheme, String host, int port) {
        StringBuilder url = new StringBuilder();
        int portOverride = SettingsBean.getInstance().getSiteURLPortOverride();
        if (portOverride != 0) {
            port = portOverride;
        }
        url.append(scheme).append("://").append(host);
        if (!(port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
            url.append(":").append(port);
        }
        return url.toString();
    }
}

