/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class TextUtils {
    public static String getStringBetween(char[] charArray, int start, int end) {
        return new String(charArray, start, end - start);
    }

    public static <T> T visitBoundedString(String initial, String prefix, String suffix, BoundedStringVisitor<T> visitor) {
        return TextUtils.visitBoundedString(initial, prefix, suffix, new Matcher<T>(prefix, suffix, visitor));
    }

    private static <T> T visitBoundedString(String initial, String prefix, String suffix, Matcher<T> matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Must provide a non-null matcher!");
        }
        BoundedStringVisitor<T> visitor = matcher.getVisitor();
        T initialValue = visitor.initialValue(initial);
        if (initial == null || initial.isEmpty()) {
            return initialValue;
        }
        if (StringUtils.isEmpty((String)prefix) || StringUtils.isEmpty((String)suffix)) {
            throw new IllegalArgumentException("Must provide non-null, non-empty prefix and suffix to match!");
        }
        int prefixIndex = initial.indexOf(prefix);
        if (prefixIndex < 0) {
            return initialValue;
        }
        int suffixIndex = initial.lastIndexOf(suffix);
        if (suffixIndex < 0 || suffixIndex < prefixIndex) {
            return initialValue;
        }
        return matcher.needsPreAndPostMatches() ? matcher.match(initial.substring(0, prefixIndex), initial.substring(prefixIndex, suffixIndex), initial.substring(suffixIndex + suffix.length())) : matcher.match(initial.substring(prefixIndex, suffixIndex));
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, String replacement) {
        return TextUtils.replaceBoundedString(initial, prefix, suffix, new ConstantStringReplacementGenerator(replacement));
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, ReplacementGenerator visitor) {
        return TextUtils.visitBoundedString(initial, prefix, suffix, new Replacer(prefix, suffix, visitor));
    }

    private static class Match
    implements Comparable<Match> {
        final int start;
        final int end;

        public Match(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Match match = (Match)o;
            return this.start == match.start;
        }

        public int hashCode() {
            return this.start;
        }

        public String toString() {
            return "[" + this.start + ", " + this.end + "]";
        }

        @Override
        public int compareTo(Match o) {
            return o == null ? -1 : this.start - o.start;
        }
    }

    public static class ConstantStringReplacementGenerator
    implements ReplacementGenerator {
        public static final ConstantStringReplacementGenerator REPLACE_BY_EMPTY = new ConstantStringReplacementGenerator("");
        private final String replacement;

        public ConstantStringReplacementGenerator(String replacement) {
            this.replacement = replacement;
        }

        @Override
        public void appendReplacementForMatch(int matchStart, int matchEnd, char[] initialStringAsCharArray, StringBuilder builder, String prefix, String suffix) {
            builder.append(this.replacement);
        }
    }

    public static interface BoundedStringVisitor<T> {
        public T visit(String var1, String var2, int var3, int var4, char[] var5);

        public T initialValue(String var1);
    }

    public static interface ReplacementGenerator {
        public void appendReplacementForMatch(int var1, int var2, char[] var3, StringBuilder var4, String var5, String var6);
    }

    private static class Replacer
    extends Matcher<String> {
        public Replacer(String prefix, String suffix, ReplacementGenerator visitor) {
            super(prefix, suffix, new ReplacerVisitor(suffix, visitor));
        }

        @Override
        public String match(String beforeFirstPrefix, String initialString, String afterLastSuffix) {
            ReplacerVisitor replacerVisitor = (ReplacerVisitor)this.getVisitor();
            replacerVisitor.initVisitor(beforeFirstPrefix.length() + initialString.length() + afterLastSuffix.length(), initialString.length());
            StringBuilder builder = replacerVisitor.builder;
            builder.append(beforeFirstPrefix);
            super.match(initialString);
            builder.append(afterLastSuffix);
            return builder.toString();
        }

        @Override
        public boolean needsPreAndPostMatches() {
            return true;
        }

        private static class ReplacerVisitor
        implements BoundedStringVisitor<String> {
            private final ReplacementGenerator replacementGenerator;
            private final int suffixLength;
            private int length;
            private StringBuilder builder;
            private int previousSuffix;

            public ReplacerVisitor(String suffix, ReplacementGenerator replacementGenerator) {
                this.replacementGenerator = replacementGenerator;
                this.suffixLength = suffix.length();
                this.previousSuffix = -1;
            }

            void initVisitor(int builderCapacity, int lengthOfBetweenMatchesString) {
                this.builder = new StringBuilder(builderCapacity);
                this.length = lengthOfBetweenMatchesString;
            }

            @Override
            public String visit(String prefix, String suffix, int matchStart, int matchEnd, char[] initialStringAsCharArray) {
                if (this.previousSuffix > 0 && this.previousSuffix < this.length - this.suffixLength) {
                    this.builder.append(initialStringAsCharArray, this.previousSuffix + this.suffixLength, matchStart - prefix.length() - this.previousSuffix - this.suffixLength);
                }
                this.replacementGenerator.appendReplacementForMatch(matchStart, matchEnd, initialStringAsCharArray, this.builder, prefix, suffix);
                this.previousSuffix = matchEnd;
                return null;
            }

            @Override
            public String initialValue(String initial) {
                return initial;
            }
        }
    }

    private static class Matcher<T> {
        protected final String prefix;
        protected final String suffix;
        protected final int prefixLength;
        protected final int suffixLength;
        protected int length;
        protected BoundedStringVisitor<T> visitor;
        private final Matches matches = new ArrayMatches();

        public Matcher(String prefix, String suffix, BoundedStringVisitor<T> visitor) {
            this.prefix = prefix;
            this.prefixLength = prefix.length();
            this.suffix = suffix;
            this.suffixLength = suffix.length();
            this.visitor = visitor;
        }

        public T match(String initialString) {
            int prefixIndex = 0;
            int suffixIndex = initialString.indexOf(this.suffix);
            this.length = initialString.length();
            if (suffixIndex < 0) {
                return this.visitor.visit(this.prefix, this.suffix, this.prefixLength, this.length, initialString.toCharArray());
            }
            while (prefixIndex >= 0) {
                while (!this.match(prefixIndex, suffixIndex, initialString)) {
                    int nextSuffix = initialString.indexOf(this.suffix, suffixIndex + this.suffixLength);
                    suffixIndex = this.ensureSuffixIndex(nextSuffix);
                }
                if (suffixIndex >= this.length) continue;
                int previousSuffix = suffixIndex;
                int nextSuffix = initialString.indexOf(this.suffix, this.matches.get(prefixIndex) + this.suffixLength);
                suffixIndex = this.ensureSuffixIndex(nextSuffix);
                prefixIndex = initialString.indexOf(this.prefix, previousSuffix + this.suffixLength);
            }
            this.matches.matchingComplete();
            return this.visitMatches(this.matches, this.visitor.initialValue(initialString), initialString.toCharArray());
        }

        public T match(String preMatches, String betweenMatches, String postMatches) {
            return this.match(betweenMatches);
        }

        private T visitMatches(Matches matches, T previousResult, char[] stringAsCharArray) {
            if (!matches.isEmpty()) {
                int suffixPosition;
                int prefixPosition;
                Match match = matches.firstMatch();
                int pairPrefix = match.start;
                int pairSuffix = match.end;
                if (pairPrefix >= this.length - 1) {
                    prefixPosition = this.length;
                    suffixPosition = this.length;
                } else {
                    prefixPosition = pairPrefix + this.prefixLength;
                    suffixPosition = pairSuffix;
                }
                T result = this.visitor.visit(this.prefix, this.suffix, prefixPosition, suffixPosition, stringAsCharArray);
                this.matches.remove(pairPrefix);
                return this.visitMatches(matches.after(pairSuffix), result, stringAsCharArray);
            }
            return previousResult;
        }

        private int ensureSuffixIndex(int potentialNextSuffix) {
            return potentialNextSuffix >= 0 ? potentialNextSuffix : this.length - 1;
        }

        private boolean match(int prefixIndex, int suffixIndex, String initialString) {
            if (prefixIndex == suffixIndex) {
                this.matches.add(prefixIndex, suffixIndex);
                return true;
            }
            int inBetweenPrefix = initialString.lastIndexOf(this.prefix, suffixIndex - 1);
            if (inBetweenPrefix == prefixIndex) {
                this.matches.add(prefixIndex, suffixIndex);
                return true;
            }
            if (inBetweenPrefix >= 0) {
                while (this.matches.matchExists(inBetweenPrefix)) {
                    inBetweenPrefix = initialString.lastIndexOf(this.prefix, inBetweenPrefix - 1);
                }
                if (inBetweenPrefix == prefixIndex) {
                    this.matches.add(prefixIndex, suffixIndex);
                    return true;
                }
                while (!this.match(inBetweenPrefix, suffixIndex, initialString)) {
                    inBetweenPrefix = initialString.lastIndexOf(this.prefix, inBetweenPrefix - 1);
                }
            }
            return false;
        }

        public boolean needsPreAndPostMatches() {
            return false;
        }

        public BoundedStringVisitor<T> getVisitor() {
            return this.visitor;
        }
    }

    private static interface Matches {
        public void matchingComplete();

        public void add(int var1, int var2);

        public boolean matchExists(int var1);

        public void remove(int var1);

        public int get(int var1);

        public boolean isEmpty();

        public Match firstMatch();

        public Matches after(int var1);
    }

    private static class ArrayMatches
    implements Matches {
        private Match[] matches = new Match[25];
        private int lastMatchIndex = 0;
        private int nbOfMatches = 0;
        private boolean isMatching = false;
        private static final Match INEXISTING = new Match(Integer.MAX_VALUE, -1);

        public ArrayMatches() {
            Arrays.fill(this.matches, INEXISTING);
        }

        @Override
        public void matchingComplete() {
            this.lastMatchIndex = 0;
            Arrays.sort(this.matches);
            this.isMatching = true;
        }

        @Override
        public void add(int start, int end) {
            int length = this.matches.length;
            if (this.lastMatchIndex == length - 1) {
                int newSize = length * 2;
                Object[] newMatches = new Match[newSize];
                System.arraycopy(this.matches, 0, newMatches, 0, length);
                Arrays.fill(newMatches, length, newSize, INEXISTING);
                this.matches = newMatches;
            }
            this.matches[this.lastMatchIndex++] = new Match(start, end);
            ++this.nbOfMatches;
        }

        public String toString() {
            return Arrays.toString(this.matches);
        }

        @Override
        public boolean matchExists(int start) {
            return this.indexOf(start) >= 0;
        }

        private int indexOf(int start) {
            if (!this.isMatching) {
                Arrays.sort(this.matches);
            }
            return Arrays.binarySearch(this.matches, new Match(start, -1));
        }

        @Override
        public void remove(int start) {
            ++this.lastMatchIndex;
        }

        @Override
        public int get(int start) {
            int i = this.indexOf(start);
            return this.matches[i].end;
        }

        @Override
        public boolean isEmpty() {
            return this.lastMatchIndex == this.nbOfMatches || this.lastMatchIndex == this.matches.length || this.matches.length == 0;
        }

        @Override
        public Match firstMatch() {
            return this.matches[this.lastMatchIndex];
        }

        @Override
        public Matches after(int position) {
            while (this.lastMatchIndex < this.matches.length) {
                Match match = this.matches[this.lastMatchIndex];
                if (match.start >= position) break;
                ++this.lastMatchIndex;
            }
            return this;
        }
    }
}

