/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.tika.io.IOUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class PomUtils {
    private static final Logger logger = LoggerFactory.getLogger(PomUtils.class);

    public static String getGroupId(Model model) {
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        return groupId;
    }

    public static String getVersion(File pomXmlFile) throws IOException, XmlPullParserException {
        return PomUtils.getVersion(PomUtils.read(pomXmlFile));
    }

    public static String getVersion(Model model) {
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model read(File pomXmlFile) throws IOException, XmlPullParserException {
        FileReader reader = new FileReader(pomXmlFile);
        try {
            Model model = new MavenXpp3Reader().read((Reader)reader);
            return model;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static void updateDistributionManagement(File pomXmlFile, String repositoryId, String repositoryUrl) throws IOException, XmlPullParserException {
        DeploymentRepository repo;
        Model model = PomUtils.read(pomXmlFile);
        DistributionManagement dm = model.getDistributionManagement();
        if (dm == null) {
            dm = new DistributionManagement();
            model.setDistributionManagement(dm);
        }
        if ((repo = dm.getRepository()) == null) {
            repo = new DeploymentRepository();
            dm.setRepository(repo);
        }
        repo.setId(repositoryId);
        repo.setUrl(repositoryUrl);
        PomUtils.write(model, pomXmlFile);
    }

    public static void updateForgeUrl(File pomXmlFile, String forgeUrl) throws IOException, XmlPullParserException {
        Model model = PomUtils.read(pomXmlFile);
        model.getProperties().put("jahia-private-app-store", forgeUrl);
        PomUtils.write(model, pomXmlFile);
    }

    public static void updateJahiaDepends(File pomXmlFile, String depends, boolean useProperties) throws IOException, XmlPullParserException {
        Xpp3Dom cfg;
        Map pluginsAsMap;
        Plugin plugin;
        Model model = PomUtils.read(pomXmlFile);
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        if (useProperties) {
            model.getProperties().put("jahia-depends", depends);
        }
        if ((plugin = (Plugin)(pluginsAsMap = build.getPluginsAsMap()).get("org.apache.felix:maven-bundle-plugin")) == null) {
            plugin = new Plugin();
            plugin.setGroupId("org.apache.felix");
            plugin.setArtifactId("maven-bundle-plugin");
            plugin.setExtensions(true);
            build.addPlugin(plugin);
        }
        if ((cfg = (Xpp3Dom)plugin.getConfiguration()) == null && !useProperties) {
            plugin.setConfiguration((Object)Xpp3DomBuilder.build((Reader)new StringReader("<configuration><instructions><Jahia-Depends>" + depends + "</Jahia-Depends></instructions></configuration>")));
        } else if (cfg != null) {
            Xpp3Dom instructions = cfg.getChild("instructions");
            if (instructions == null && !useProperties) {
                cfg.addChild(Xpp3DomBuilder.build((Reader)new StringReader("<instructions><Jahia-Depends>" + depends + "</Jahia-Depends></instructions>")));
            } else if (instructions != null) {
                Xpp3Dom jahiaDepends = instructions.getChild("Jahia-Depends");
                if (jahiaDepends == null && !useProperties) {
                    instructions.addChild(Xpp3DomBuilder.build((Reader)new StringReader("<Jahia-Depends>" + depends + "</Jahia-Depends>")));
                } else if (jahiaDepends != null && !useProperties) {
                    jahiaDepends.setValue(depends);
                } else if (jahiaDepends != null) {
                    instructions.removeChild(Arrays.asList(instructions.getChildren()).indexOf(jahiaDepends));
                }
            }
        }
        PomUtils.write(model, pomXmlFile);
    }

    public static void updateScm(File pomXmlFile, String scmUrl) throws IOException, XmlPullParserException {
        Model model = PomUtils.read(pomXmlFile);
        Scm scm = model.getScm();
        if (scm == null) {
            scm = new Scm();
            model.setScm(scm);
        }
        scm.setConnection(scmUrl);
        scm.setDeveloperConnection(scmUrl);
        PomUtils.write(model, pomXmlFile);
    }

    public static void updateVersion(File pomXmlFile, String version) throws IOException, XmlPullParserException {
        Model model = PomUtils.read(pomXmlFile);
        model.setVersion(version);
        PomUtils.write(model, pomXmlFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Model model, File targetPomXmlFile) throws IOException {
        String pomContent;
        String copyright = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(targetPomXmlFile);
            Node firstChild = doc.getFirstChild();
            if (firstChild.getNodeType() == 8) {
                copyright = firstChild.getTextContent();
            }
        }
        catch (Exception e) {
            logger.warn("Failed to read pom.xml copyright", (Throwable)e);
        }
        MavenXpp3Writer xpp3Writer = new MavenXpp3Writer();
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            xpp3Writer.write((OutputStream)os, model);
            pomContent = ((Object)os).toString();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
        if (copyright != null) {
            int i = pomContent.indexOf("<project");
            pomContent = pomContent.substring(0, i) + "<!--" + copyright + "-->\n" + pomContent.substring(i);
        }
        FileUtils.write((File)targetPomXmlFile, (CharSequence)pomContent);
    }

    public static File extractPomFromJar(JarFile jar, String groupId, String artifactId) throws IOException {
        Enumeration<JarEntry> jarEntries = jar.entries();
        JarEntry jarEntry = null;
        boolean found = false;
        while (jarEntries.hasMoreElements()) {
            jarEntry = jarEntries.nextElement();
            String name = jarEntry.getName();
            if (!StringUtils.startsWith((String)name, (String)(groupId != null ? "META-INF/maven/" + groupId + "/" : "META-INF/maven/")) || !StringUtils.endsWith((String)name, (String)(artifactId + "/pom.xml"))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IOException("unable to find pom.xml file within while looking for " + artifactId);
        }
        InputStream is = jar.getInputStream(jarEntry);
        File pomFile = File.createTempFile("pom", ".xml");
        FileUtils.copyInputStreamToFile((InputStream)is, (File)pomFile);
        return pomFile;
    }

    private PomUtils() {
    }
}

