/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.files;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.PathFileComparator;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jahia.tools.files.FileWatcher;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcherJob
implements StatefulJob {
    private static final Logger logger = LoggerFactory.getLogger(FileWatcherJob.class);

    protected List<File> checkFiles(File folder, boolean fileOnly, boolean recursive, boolean checkDate, long lastCheckTime, IOFileFilter ignoreFilter) {
        if (!folder.isDirectory()) {
            return Collections.emptyList();
        }
        List files = null;
        if (fileOnly || !checkDate) {
            IOFileFilter dirFilter;
            IOFileFilter fileFilter;
            if (ignoreFilter != null) {
                fileFilter = checkDate ? new AndFileFilter((IOFileFilter)new AgeFileFilter(lastCheckTime, false), ignoreFilter) : ignoreFilter;
                dirFilter = recursive ? ignoreFilter : FalseFileFilter.INSTANCE;
            } else {
                fileFilter = checkDate ? new AgeFileFilter(lastCheckTime, false) : TrueFileFilter.INSTANCE;
                dirFilter = recursive ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE;
            }
            Collection foundFiles = fileOnly ? FileUtils.listFiles((File)folder, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter) : FileUtils.listFilesAndDirs((File)folder, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
            files = foundFiles instanceof List ? (List)foundFiles : new LinkedList(foundFiles);
        } else if (recursive) {
            try {
                files = new Walker(lastCheckTime).execute(folder);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            Collection foundFiles = FileUtils.listFilesAndDirs((File)folder, (IOFileFilter)(ignoreFilter != null ? new AndFileFilter((IOFileFilter)new AgeFileFilter(lastCheckTime, false), ignoreFilter) : null), (IOFileFilter)FalseFileFilter.INSTANCE);
            files = foundFiles instanceof List ? (List)foundFiles : new LinkedList(foundFiles);
        }
        return files;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        FileWatcher fileWatcher = (FileWatcher)jobDataMap.get((Object)"fileWatcher");
        if (fileWatcher != null) {
            File folder = fileWatcher.getFolder();
            boolean fileOnly = fileWatcher.getFileOnly();
            boolean recursive = fileWatcher.isRecursive();
            IOFileFilter ignoreFilter = fileWatcher.getIgnoreFilter();
            List<File> changedFiles = this.checkFiles(folder, fileOnly, recursive, fileWatcher.getCheckDate(), fileWatcher.getLastCheckTime(), ignoreFilter);
            fileWatcher.setLastCheckTime(System.currentTimeMillis());
            if (fileWatcher.getRemovedFiles()) {
                IOFileFilter filter;
                IOFileFilter iOFileFilter = filter = ignoreFilter != null ? ignoreFilter : TrueFileFilter.INSTANCE;
                Collection currentFiles = fileOnly ? FileUtils.listFiles((File)folder, (IOFileFilter)filter, (IOFileFilter)(recursive ? filter : FalseFileFilter.INSTANCE)) : FileUtils.listFilesAndDirs((File)folder, (IOFileFilter)filter, (IOFileFilter)(recursive ? filter : FalseFileFilter.INSTANCE));
                TreeSet<File> deletedFiles = new TreeSet<File>((Comparator<File>)new PathFileComparator());
                deletedFiles.addAll(fileWatcher.getPreviousFiles());
                deletedFiles.removeAll(currentFiles);
                changedFiles.addAll(deletedFiles);
                fileWatcher.setPreviousFiles(currentFiles);
            }
            if (changedFiles.size() > 0) {
                fileWatcher.externalSetChanged();
                fileWatcher.notifyObservers(changedFiles);
            }
        }
    }

    private static class Walker
    extends DirectoryWalker<File> {
        private AgeFileFilter ageFileFilter;
        private List<File> results = new LinkedList<File>();

        Walker(long newerThan) {
            this.ageFileFilter = new AgeFileFilter(newerThan, false);
        }

        List<File> execute(File startFolder) throws IOException {
            this.walk(startFolder, this.results);
            return this.results;
        }

        protected boolean handleDirectory(File directory, int depth, Collection<File> results) throws IOException {
            if (this.ageFileFilter.accept(directory)) {
                results.add(directory);
            }
            return true;
        }

        protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
            if (this.ageFileFilter.accept(file)) {
                results.add(file);
            }
        }
    }
}

