/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools;

import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class OutWrapper {
    private Logger log;
    private Writer out;

    public OutWrapper(Logger logger, Writer out) {
        this.log = logger;
        this.out = out;
    }

    public OutWrapper echo(String message) {
        this.log.info(message);
        this.out(message);
        return this;
    }

    public OutWrapper echo(String format, Object arg1) {
        return this.echo(MessageFormatter.format((String)format, (Object)arg1).getMessage());
    }

    public OutWrapper echo(String format, Object arg1, Object arg2) {
        return this.echo(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public OutWrapper echo(String format, Object arg1, Object arg2, Object arg3) {
        return this.echo(MessageFormatter.arrayFormat((String)format, (Object[])new Object[]{arg1, arg2, arg3}).getMessage());
    }

    public OutWrapper echo(String format, Object[] args) {
        return this.echo(MessageFormatter.format((String)format, (Object)args).getMessage());
    }

    private void out(String message) {
        if (this.out != null) {
            try {
                this.out.append(message).append("\n").flush();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

