/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.command;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.jbpm.BaseCommand;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;

public class GetWorkflowsForUserCommand
extends BaseCommand<List<Workflow>> {
    private final JahiaUser user;
    private final Locale uiLocale;

    public GetWorkflowsForUserCommand(JahiaUser user, Locale uiLocale) {
        this.user = user;
        this.uiLocale = uiLocale;
    }

    @Override
    public List<Workflow> execute() {
        LinkedList<Workflow> workflows = new LinkedList<Workflow>();
        Collection processInstances = this.getKieSession().getProcessInstances();
        for (ProcessInstance processInstance : processInstances) {
            if (!(processInstance instanceof WorkflowProcessInstance)) continue;
            WorkflowProcessInstance workflowProcessInstance = (WorkflowProcessInstance)processInstance;
            String userKey = (String)workflowProcessInstance.getVariable("user");
            if (!this.user.getUserKey().equals(userKey)) continue;
            workflows.add(this.convertToWorkflow(processInstance, this.uiLocale, this.getKieSession(), this.getTaskService(), this.getLogService()));
        }
        return workflows;
    }
}

