/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow;

import java.util.ArrayList;
import java.util.List;
import org.jahia.services.workflow.HistoryWorkflow;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.WorkflowListener;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowObservationManager {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowObservationManager.class);
    private WorkflowService service;
    private List<WorkflowListener> listeners = new ArrayList<WorkflowListener>();

    public WorkflowObservationManager(WorkflowService service) {
        this.service = service;
    }

    public void notifyWorkflowStarted(String provider, String workflowId) {
        Workflow wf = this.service.getWorkflow(provider, workflowId, null);
        for (WorkflowListener listener : this.listeners) {
            try {
                listener.workflowStarted(wf);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void notifyWorkflowEnded(String provider, String workflowId) {
        HistoryWorkflow wf = this.service.getHistoryWorkflow(workflowId, provider, null);
        for (WorkflowListener listener : this.listeners) {
            try {
                listener.workflowEnded(wf);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void notifyNewTask(String provider, String taskId) {
        WorkflowTask task = this.service.getWorkflowTask(taskId, provider, null);
        for (WorkflowListener listener : this.listeners) {
            try {
                listener.newTaskCreated(task);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void notifyTaskEnded(String provider, String taskId) {
        WorkflowTask task = this.service.getWorkflowTask(taskId, provider, null);
        for (WorkflowListener listener : this.listeners) {
            try {
                listener.taskEnded(task);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addWorkflowListener(WorkflowListener listener) {
        this.listeners.add(listener);
    }
}

