/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.webdav;

import javax.jcr.Item;
import javax.jcr.Session;
import org.apache.jackrabbit.webdav.simple.DefaultItemFilter;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaItemFilter
extends DefaultItemFilter {
    private static final Logger logger = LoggerFactory.getLogger(JahiaItemFilter.class);
    private Boolean directoryListingDisabled;

    public JahiaItemFilter() {
        this.init();
    }

    private void init() {
        try {
            this.directoryListingDisabled = Boolean.valueOf(SettingsBean.getInstance().getPropertiesFile().getProperty("repositoryDirectoryListingDisabled", "false"));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isFilteredItem(Item item) {
        return this.directoryListingDisabled != false ? true : super.isFilteredItem(item);
    }

    public boolean isFilteredItem(String name, Session session) {
        return this.directoryListingDisabled != false ? true : super.isFilteredItem(name, session);
    }
}

