/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.RowIterator;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCacheHelper {
    private static Logger logger = LoggerFactory.getLogger(GroupCacheHelper.class);
    private EhCacheProvider ehCacheProvider;
    private SelfPopulatingCache groupPathByGroupNameCache;
    private SelfPopulatingCache membershipCache;
    private int timeToLiveForNonExistingGroups = 600;

    public String getGroupPath(String siteKey, String name) {
        String value = (String)this.getGroupPathByGroupNameCache().get((Serializable)new GroupPathByGroupNameCacheKey(siteKey, name)).getObjectValue();
        if (value.equals("")) {
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelfPopulatingCache getGroupPathByGroupNameCache() {
        if (this.groupPathByGroupNameCache == null) {
            GroupCacheHelper groupCacheHelper = this;
            synchronized (groupCacheHelper) {
                if (this.groupPathByGroupNameCache == null) {
                    this.groupPathByGroupNameCache = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.services.usermanager.JahiaGroupManagerService.groupPathByGroupNameCache", new GroupPathByGroupNameCacheEntryFactory());
                }
            }
        }
        return this.groupPathByGroupNameCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelfPopulatingCache getMembershipCache() {
        if (this.membershipCache == null) {
            GroupCacheHelper groupCacheHelper = this;
            synchronized (groupCacheHelper) {
                if (this.membershipCache == null) {
                    this.membershipCache = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.services.usermanager.JahiaGroupManagerService.membershipCache", new MembershipCacheEntryFactory());
                }
            }
        }
        return this.membershipCache;
    }

    private static GroupPathByGroupNameCacheKey getPathCacheKey(String groupPath) {
        return new GroupPathByGroupNameCacheKey(groupPath.startsWith("/sites/") ? StringUtils.substringBetween((String)groupPath, (String)"/sites/", (String)"/") : null, StringUtils.substringAfterLast((String)groupPath, (String)"/"));
    }

    private String internalGetGroupPath(String siteKey, String name) throws RepositoryException {
        StringBuilder buff = new StringBuilder();
        buff.append("SELECT [j:nodename] FROM [jnt:group] as group where localname()='").append(JCRContentUtils.sqlEncode(name)).append("' ");
        if (siteKey != null) {
            buff.append("and isdescendantnode(group,'/sites/").append(JCRContentUtils.sqlEncode(siteKey)).append("/groups')");
        } else {
            buff.append("and isdescendantnode(group,'/groups')");
        }
        QueryWrapper q = JCRSessionFactory.getInstance().getCurrentSystemSession("live", null, null).getWorkspace().getQueryManager().createQuery(buff.toString(), "JCR-SQL2");
        q.setLimit(1L);
        RowIterator it = q.execute().getRows();
        if (!it.hasNext()) {
            return null;
        }
        return it.nextRow().getPath();
    }

    private List<String> internalGetMembershipByPath(String principalPath) {
        try {
            JCRNodeWrapper principalNode = JCRSessionFactory.getInstance().getCurrentSystemSession("live", null, null).getNode(principalPath);
            LinkedHashSet<String> groups = new LinkedHashSet<String>();
            try {
                this.populateGroups(groups, principalNode);
            }
            catch (JahiaException e) {
                logger.warn("Error retrieving membership for user " + principalPath, (Throwable)e);
            }
            if (principalNode instanceof JCRUserNode) {
                JCRUserNode userNode = (JCRUserNode)principalNode;
                if (!JahiaUserManagerService.isGuest(userNode)) {
                    this.populateSpecialGroups(groups, "/groups/users");
                    if (userNode.getRealm() != null) {
                        String siteUsers = "/sites/" + userNode.getRealm() + "/groups/" + "site-users";
                        this.populateSpecialGroups(groups, siteUsers);
                    }
                }
                this.populateSpecialGroups(groups, "/groups/guest");
            }
            return new LinkedList<String>(groups);
        }
        catch (PathNotFoundException e) {
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving membership for user " + principalPath + ", will return empty list", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private void populateSpecialGroups(Set<String> groups, String groupPath) {
        groups.add(groupPath);
        groups.addAll((List)this.getMembershipCache().get((Serializable)((Object)groupPath)).getObjectValue());
    }

    private void populateGroups(Set<String> groups, JCRNodeWrapper principal) throws RepositoryException, JahiaException {
        try {
            PropertyIterator weakReferences = principal.getWeakReferences("j:member");
            while (weakReferences.hasNext()) {
                try {
                    JCRNodeWrapper group;
                    Property property = weakReferences.nextProperty();
                    if (property == null || property.getPath() == null || !property.getPath().contains("/j:members/") || !(group = (JCRNodeWrapper)property.getSession().getNode(StringUtils.substringBefore((String)property.getPath(), (String)"/j:members/"))).isNodeType("jnt:group") || !groups.add(group.getPath())) continue;
                    this.populateGroups(groups, group);
                }
                catch (ItemNotFoundException e) {
                    logger.warn("Cannot find group for " + principal.getPath(), (Throwable)e);
                }
            }
        }
        catch (InvalidItemStateException e) {
            logger.warn("Cannot find membership for " + principal.getPath(), (Throwable)e);
        }
    }

    public void setEhCacheProvider(EhCacheProvider ehCacheProvider) {
        this.ehCacheProvider = ehCacheProvider;
    }

    public void setTimeToLiveForNonExistingGroups(int timeToLiveForNonExistingGroups) {
        this.timeToLiveForNonExistingGroups = timeToLiveForNonExistingGroups;
    }

    public void updatePathCacheAdded(String groupPath) {
        this.getGroupPathByGroupNameCache().put(new Element((Serializable)GroupCacheHelper.getPathCacheKey(groupPath), (Serializable)((Object)groupPath)));
    }

    public void updatePathCacheRemoved(String groupPath) {
        this.getGroupPathByGroupNameCache().remove((Serializable)GroupCacheHelper.getPathCacheKey(groupPath));
    }

    private class MembershipCacheEntryFactory
    implements CacheEntryFactory {
        private MembershipCacheEntryFactory() {
        }

        public Object createEntry(Object key) throws Exception {
            return GroupCacheHelper.this.internalGetMembershipByPath((String)key);
        }
    }

    private static class GroupPathByGroupNameCacheKey
    implements Serializable {
        private static final long serialVersionUID = 6343178106505586294L;
        private String siteKey;
        private String groupName;
        private final int hash;

        private GroupPathByGroupNameCacheKey(String siteKey, String groupName) {
            this.siteKey = siteKey;
            this.groupName = groupName;
            this.hash = this.getHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupPathByGroupNameCacheKey that = (GroupPathByGroupNameCacheKey)o;
            if (!this.groupName.equals(that.groupName)) {
                return false;
            }
            return !(this.siteKey != null ? !this.siteKey.equals(that.siteKey) : that.siteKey != null);
        }

        private int getHashCode() {
            int result = this.siteKey != null ? this.siteKey.hashCode() : 0;
            result = 31 * result + this.groupName.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class GroupPathByGroupNameCacheEntryFactory
    implements CacheEntryFactory {
        private GroupPathByGroupNameCacheEntryFactory() {
        }

        public Object createEntry(Object key) throws Exception {
            GroupPathByGroupNameCacheKey k = (GroupPathByGroupNameCacheKey)key;
            String path = GroupCacheHelper.this.internalGetGroupPath(k.siteKey, k.groupName);
            if (path != null) {
                return new Element(key, (Object)path);
            }
            return new Element(key, (Object)"", 0, GroupCacheHelper.this.timeToLiveForNonExistingGroups);
        }
    }
}

