/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.transform;

import java.io.File;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeConnectionProtocol;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.artofsolving.jodconverter.process.ProcessManager;
import org.artofsolving.jodconverter.process.ProcessQuery;
import org.artofsolving.jodconverter.process.WindowsProcessManager;
import org.artofsolving.jodconverter.util.PlatformUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class LocalOfficeManagerFactory
extends AbstractFactoryBean<OfficeManager> {
    private static final Logger logger = LoggerFactory.getLogger(LocalOfficeManagerFactory.class);
    private DefaultOfficeManagerConfiguration cfg;
    private boolean killExistingOfficeProcessOnWindows = true;
    private OfficeConnectionProtocol connectionProtocol = OfficeConnectionProtocol.SOCKET;
    private int[] portNumbers = new int[]{2002};

    public LocalOfficeManagerFactory() {
        this.cfg = new DefaultOfficeManagerConfiguration();
    }

    protected OfficeManager createInstance() throws Exception {
        if (this.killExistingOfficeProcessOnWindows && PlatformUtils.isWindows() && this.connectionProtocol == OfficeConnectionProtocol.SOCKET && WindowsProcessManager.isSupported()) {
            WindowsProcessManager mgr = new WindowsProcessManager();
            for (int port : this.portNumbers) {
                ProcessQuery q = new ProcessQuery("soffice.bin", "socket,host=127.0.0.1,port=" + port);
                long pid = mgr.findPid(q);
                if (pid <= 0L) continue;
                try {
                    mgr.kill(null, pid);
                }
                catch (Exception e) {
                    logger.error("Error killing existing office process with pid " + pid, (Throwable)e);
                }
            }
        }
        return this.cfg.buildOfficeManager();
    }

    public Class<? extends OfficeManager> getObjectType() {
        return OfficeManager.class;
    }

    public void setConnectionProtocol(OfficeConnectionProtocol connectionProtocol) throws NullPointerException {
        this.connectionProtocol = connectionProtocol;
        this.cfg.setConnectionProtocol(connectionProtocol);
    }

    public void setMaxTasksPerProcess(int maxTasksPerProcess) {
        this.cfg.setMaxTasksPerProcess(maxTasksPerProcess);
    }

    public void setOfficeHome(File officeHome) throws NullPointerException, IllegalArgumentException {
        this.cfg.setOfficeHome(officeHome);
    }

    public void setOfficeHome(String officeHome) throws NullPointerException, IllegalArgumentException {
        this.cfg.setOfficeHome(officeHome);
    }

    public void setPipeName(String pipeName) throws NullPointerException {
        this.cfg.setPipeName(pipeName);
    }

    public void setPipeNames(String ... pipeNames) throws NullPointerException, IllegalArgumentException {
        this.cfg.setPipeNames(pipeNames);
    }

    public void setPortNumber(int portNumber) {
        this.portNumbers = new int[]{portNumber};
        this.cfg.setPortNumber(portNumber);
    }

    public void setPortNumbers(int ... portNumbers) throws NullPointerException, IllegalArgumentException {
        this.portNumbers = portNumbers;
        this.cfg.setPortNumbers(portNumbers);
    }

    public void setProcessManager(ProcessManager processManager) throws NullPointerException {
        this.cfg.setProcessManager(processManager);
    }

    public void setTaskExecutionTimeout(long taskExecutionTimeout) {
        this.cfg.setTaskExecutionTimeout(taskExecutionTimeout);
    }

    public void setTaskQueueTimeout(long taskQueueTimeout) {
        this.cfg.setTaskQueueTimeout(taskQueueTimeout);
    }

    public void setTemplateProfileDir(File templateProfileDir) throws IllegalArgumentException {
        this.cfg.setTemplateProfileDir(templateProfileDir);
    }

    public void setKillExistingOfficeProcessOnWindows(boolean killExistingOfficeProcessOnWindows) {
        this.killExistingOfficeProcessOnWindows = killExistingOfficeProcessOnWindows;
    }
}

