/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.textextraction;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.rules.ExtractionService;
import org.jahia.services.textextraction.ExtractionCheckStatus;
import org.jahia.services.textextraction.RepositoryFileFilter;
import org.jahia.tools.OutWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TextExtractionChecker {
    private static final Logger logger = LoggerFactory.getLogger(TextExtractionChecker.class);
    private final boolean fixExtraction;
    private final boolean searchByFilter;
    private boolean forceStop;
    private List<String> nodesToExtract = new ArrayList<String>();
    private final OutWrapper out;
    private final ExtractionCheckStatus status;
    private final RepositoryFileFilter filter;

    TextExtractionChecker(ExtractionCheckStatus status, boolean fixExtraction, OutWrapper out) {
        this.status = status;
        this.fixExtraction = fixExtraction;
        this.out = out;
        this.searchByFilter = false;
        this.filter = null;
    }

    TextExtractionChecker(ExtractionCheckStatus status, boolean fixExtraction, RepositoryFileFilter filter, OutWrapper out) {
        this.status = status;
        this.fixExtraction = fixExtraction;
        this.out = out;
        this.searchByFilter = true;
        this.filter = filter;
    }

    private void checkTextExtraction(JCRSessionWrapper session) throws RepositoryException {
        String xpath;
        this.nodesToExtract = new ArrayList<String>();
        QueryManagerWrapper q = session.getWorkspace().getQueryManager();
        if (this.searchByFilter) {
            StringBuilder xpathBuilder = new StringBuilder();
            xpathBuilder.append("/jcr:root/");
            if (StringUtils.isNotBlank((String)this.filter.getPath())) {
                xpathBuilder.append(ISO9075.encodePath((String)this.filter.getPath().replaceAll("^/|/$", ""))).append(this.filter.isIncludeDescendants() ? "//" : "/");
            } else {
                xpathBuilder.append("*//");
            }
            xpathBuilder.append("element(*,nt:file)[not(jcr:like(jcr:content/@jcr:mimeType, 'image%')) and not(jcr:like(jcr:content/@jcr:mimeType, '%css')) and not(jcr:like(fn:name(), 'thumbnail%'))");
            if (!this.filter.getMimeTypes().isEmpty()) {
                xpathBuilder.append(" and (");
                String connector = "";
                for (String mimeType : this.filter.getMimeTypes()) {
                    xpathBuilder.append(connector).append("jcr:content/@jcr:mimeType = ").append(JCRContentUtils.stringToQueryLiteral(mimeType));
                    connector = " or ";
                }
                xpathBuilder.append(")");
            }
            if (StringUtils.isNotBlank((String)this.filter.getFileNamePattern())) {
                String pattern = this.filter.getFileNamePattern();
                pattern = pattern.replace("\\", "\\\\");
                pattern = pattern.replace("_", "\\_");
                pattern = pattern.replace("%", "\\%");
                pattern = pattern.replace("?", "_");
                pattern = pattern.replace("*", "%");
                xpathBuilder.append(" and jcr:like(fn:name(), ").append(JCRContentUtils.stringToQueryLiteral(pattern)).append(")");
            }
            xpathBuilder.append("]");
            xpath = xpathBuilder.toString();
        } else {
            xpath = "/jcr:root/*//element(*,nt:file)[not(jcr:content/@j:extractedText) and not(jcr:like(jcr:content/@jcr:mimeType, 'image%')) and not(jcr:like(jcr:content/@jcr:mimeType, '%css')) and not(jcr:like(fn:name(), 'thumbnail%'))]";
        }
        QueryResult qr = q.createQuery(xpath, "xpath").execute();
        NodeIterator ni = qr.getNodes();
        JCRNodeWrapper fileNode = null;
        while (ni.hasNext()) {
            try {
                fileNode = (JCRNodeWrapper)ni.next();
                if (!fileNode.isNodeType("jnt:translation")) {
                    JCRNodeWrapper resource = fileNode.getNode("jcr:content");
                    String savedMimeType = "";
                    try {
                        savedMimeType = resource.getProperty("jcr:mimeType").getString();
                    }
                    catch (PathNotFoundException e) {
                        // empty catch block
                    }
                    String mimeType = JCRContentUtils.getMimeType(fileNode.getName());
                    if (mimeType != null && !savedMimeType.equals(mimeType)) {
                        logger.warn("Saved mimetype for {} is '{}', but the suggested one is '{}'", new Object[]{fileNode.getPath(), savedMimeType, mimeType});
                    }
                    if (ExtractionService.getInstance().canHandle(resource)) {
                        this.out.echo("{} with mimetype '{}'", fileNode.getPath(), savedMimeType);
                        ++this.status.extractable;
                        this.nodesToExtract.add(fileNode.getIdentifier());
                    }
                    ++this.status.checked;
                }
                if (!this.forceStop) continue;
                return;
            }
            catch (Exception e) {
                logger.warn("Error when trying to extract: " + fileNode != null ? fileNode.getPath() : "", (Throwable)e);
            }
        }
    }

    private void fixTextExtractions(JCRSessionWrapper session) {
        JCRNodeWrapper fileNode = null;
        for (String nodeToExtract : this.nodesToExtract) {
            try {
                fileNode = session.getNodeByIdentifier(nodeToExtract);
                if (ExtractionService.getInstance().extractText(fileNode.getProvider(), fileNode.getPath(), null, session.getWorkspace().getName())) {
                    ++this.status.fixed;
                }
            }
            catch (Exception e) {
                this.out.echo("Cannot extract text of {} due to {}", fileNode.getPath(), e.getMessage());
            }
            if (!this.forceStop) continue;
            return;
        }
    }

    void perform(JCRSessionWrapper session) throws RepositoryException {
        this.checkTextExtraction(session);
        if (this.forceStop) {
            this.out.echo("Request received to stop checking nodes.");
        } else if (this.fixExtraction && this.nodesToExtract.size() > 0) {
            this.fixTextExtractions(session);
        }
    }

    void stop() {
        this.forceStop = true;
    }
}

