/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search.jcr;

import java.io.IOException;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.query.lucene.ExcerptProvider;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaExcerptProvider
implements ExcerptProvider {
    private static final Logger log = LoggerFactory.getLogger(ExcerptProvider.class);
    private static final String JAHIA_NS = "http://www.jahia.org/jahia/1.0";
    public static final String CATEGORY_TYPE = "defaultCategory";
    public static final String TAG_TYPE = "tags";
    private ItemStateManager ism;
    private Query query;

    public void init(Query query, SearchIndex index) throws IOException {
        this.ism = index.getContext().getItemStateManager();
        this.query = query;
    }

    public String getExcerpt(NodeId id, int maxFragments, int maxFragmentSize) throws IOException {
        StringBuilder text = new StringBuilder();
        try {
            NodeState nodeState = (NodeState)this.ism.getItemState((ItemId)id);
            String separator = "";
            Iterator it = nodeState.getPropertyNames().iterator();
            while (it.hasNext()) {
                InternalValue[] values;
                PropertyId propId = new PropertyId(id, (Name)it.next());
                PropertyState propState = (PropertyState)this.ism.getItemState((ItemId)propId);
                Name propStateName = propState.getName();
                if ((!propStateName.getNamespaceURI().equals(JAHIA_NS) || !propStateName.getLocalName().equals(TAG_TYPE)) && !propStateName.getLocalName().equals(CATEGORY_TYPE)) continue;
                for (InternalValue value : values = propState.getValues()) {
                    text.append(separator);
                    StringBuilder s = new StringBuilder("###" + (propStateName.getLocalName().equals(TAG_TYPE) ? TAG_TYPE : CATEGORY_TYPE) + "#");
                    if (this.query.toString().contains(value.getString())) {
                        s.append("<span class=\"searchHighlightedText\">");
                    }
                    s.append(value.getString());
                    if (this.query.toString().contains(value.getString())) {
                        s.append("</span>");
                    }
                    s.append("###");
                    separator = ",";
                    text.append((CharSequence)s);
                }
            }
        }
        catch (ItemStateException e) {
        }
        catch (RepositoryException e) {
            log.debug("Error while reading tags or category in search excerpt", (Object)e.getMessage());
        }
        return text.toString();
    }
}

