/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FactoryUtils;
import org.apache.commons.collections.list.LazyList;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SearchCriteria
implements Serializable {
    private static final long serialVersionUID = 4633533116047727827L;
    private static final ToStringStyle TO_STRING_STYLE = ToStringStyle.MULTI_LINE_STYLE;
    private DateValue created = new DateValue();
    private String createdBy;
    private HierarchicalValue filePath = new HierarchicalValue();
    private String fileType;
    private int itemsPerPage;
    private CommaSeparatedMultipleValue languages = new CommaSeparatedMultipleValue();
    private DateValue lastModified = new DateValue();
    private String lastModifiedBy;
    private long limit;
    private String nodeType;
    private long offset;
    private String originSiteKey;
    private HierarchicalValue pagePath = new HierarchicalValue();
    private Map<String, Map<String, NodeProperty>> properties = LazyMap.decorate(new HashMap(), (Factory)new NodePropertyMapFactory());
    private String rawQuery;
    private CommaSeparatedMultipleValue sites = new CommaSeparatedMultipleValue();
    private CommaSeparatedMultipleValue sitesForReferences = new CommaSeparatedMultipleValue();
    private List<Term> terms = LazyList.decorate(new LinkedList(), (Factory)FactoryUtils.instantiateFactory(Term.class));

    private static boolean isValueEmpty(String value) {
        return StringUtils.isBlank((String)value);
    }

    private static List<String> listToString(List<?> items) {
        LinkedList<String> toStringItems = new LinkedList<String>();
        for (Object obj : items) {
            if (obj instanceof Term) {
                Term term = (Term)obj;
                toStringItems.add(new ToStringBuilder(obj, TO_STRING_STYLE).append("term", (Object)term.getTerm()).append("match", (Object)term.getMatch()).append("fields", (Object)ReflectionToStringBuilder.reflectionToString((Object)term.getFields(), (ToStringStyle)TO_STRING_STYLE)).toString());
                continue;
            }
            toStringItems.add(ReflectionToStringBuilder.reflectionToString(obj, (ToStringStyle)TO_STRING_STYLE));
        }
        return toStringItems;
    }

    public DateValue getCreated() {
        return this.created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public HierarchicalValue getFilePath() {
        return this.filePath;
    }

    public String getFileType() {
        return this.fileType;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public CommaSeparatedMultipleValue getLanguages() {
        return this.languages;
    }

    public DateValue getLastModified() {
        return this.lastModified;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public long getLimit() {
        return this.limit;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getOriginSiteKey() {
        return this.originSiteKey;
    }

    public HierarchicalValue getPagePath() {
        return this.pagePath;
    }

    public Map<String, Map<String, NodeProperty>> getProperties() {
        return this.properties;
    }

    public List<NodeProperty> getPropertiesAll() {
        LinkedList<NodeProperty> props = new LinkedList<NodeProperty>();
        for (Map<String, NodeProperty> docTypeEntry : this.getProperties().values()) {
            for (NodeProperty prop : docTypeEntry.values()) {
                props.add(prop);
            }
        }
        return props;
    }

    public String getRawQuery() {
        return this.rawQuery;
    }

    public CommaSeparatedMultipleValue getSites() {
        return this.sites;
    }

    public CommaSeparatedMultipleValue getSitesForReferences() {
        return this.sitesForReferences;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public boolean isEmpty() {
        boolean empty;
        boolean bl = empty = SearchCriteria.isValueEmpty(this.getRawQuery()) && SearchCriteria.isValueEmpty(this.getNodeType()) && SearchCriteria.isValueEmpty(this.getFileType()) && SearchCriteria.isValueEmpty(this.getCreatedBy()) && this.getCreated().isEmpty() && SearchCriteria.isValueEmpty(this.getLastModifiedBy()) && this.getLastModified().isEmpty() && this.getPagePath().isEmpty() && this.getFilePath().isEmpty();
        if (empty) {
            for (Term term : this.getTerms()) {
                if (term.isEmpty()) continue;
                empty = false;
                break;
            }
        }
        if (empty) {
            block1: for (Map map : this.getProperties().values()) {
                for (NodeProperty prop : map.values()) {
                    if (!prop.isEmpty()) {
                        empty = false;
                        continue block1;
                    }
                    if (empty) continue;
                    continue block1;
                }
            }
        }
        return empty;
    }

    public void setCreated(DateValue creationDate) {
        this.created = creationDate;
    }

    public void setCreatedBy(String author) {
        this.createdBy = author;
    }

    public void setFilePath(HierarchicalValue fileLocation) {
        this.filePath = fileLocation;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public void setLanguages(CommaSeparatedMultipleValue languages) {
        this.languages = languages;
    }

    public void setLastModified(DateValue lastModificationDate) {
        this.lastModified = lastModificationDate;
    }

    public void setLastModifiedBy(String lastEditor) {
        this.lastModifiedBy = lastEditor;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setOriginSiteKey(String originSiteKey) {
        this.originSiteKey = originSiteKey;
    }

    public void setPagePath(HierarchicalValue pagePath) {
        this.pagePath = pagePath;
    }

    public void setProperties(Map<String, Map<String, NodeProperty>> properties) {
        this.properties = properties;
    }

    public void setRawQuery(String rawQuery) {
        this.rawQuery = rawQuery;
    }

    public void setSites(CommaSeparatedMultipleValue sites) {
        this.sites = sites;
    }

    public void setSitesForReferences(CommaSeparatedMultipleValue sitesForReferences) {
        this.sitesForReferences = sitesForReferences;
    }

    public void setTerm(String term) {
        this.getTerms().clear();
        Term search = this.getTerms().get(0);
        search.setTerm(term);
        search.getFields().setFileContent(true);
    }

    public void setTerms(List<Term> textSearches) {
        this.terms = textSearches;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, TO_STRING_STYLE).append("rawQuery", (Object)this.getRawQuery()).append("createdBy", (Object)this.getCreatedBy()).append("created", (Object)this.getCreated()).append("lastModifiedBy", (Object)this.getLastModifiedBy()).append("lastModified", (Object)this.getLastModified()).append("pagePath", (Object)this.getPagePath()).append("fileType", (Object)this.getFileType()).append("nodeType", (Object)this.getNodeType()).append("filePath", (Object)this.getFilePath()).append("properties", SearchCriteria.listToString(this.getPropertiesAll())).append("terms", SearchCriteria.listToString(this.getTerms())).append("itemsPerPage", this.getItemsPerPage()).append("sites", (Object)this.getSites()).append("sitesForReferences", (Object)this.getSitesForReferences()).append("languages", (Object)this.getLanguages()).append("limit", this.getLimit()).append("offset", this.getOffset()).append("originSiteKey", (Object)this.getOriginSiteKey()).toString();
    }

    public static class Term
    implements Serializable {
        private static final long serialVersionUID = -3881090179063748926L;
        private SearchFields fields = new SearchFields();
        private MatchType match = MatchType.AS_IS;
        private String term;
        private boolean applyFilter;

        public SearchFields getFields() {
            return this.fields;
        }

        public MatchType getMatch() {
            return this.match;
        }

        public String getTerm() {
            return this.term;
        }

        public boolean isEmpty() {
            return SearchCriteria.isValueEmpty(this.term);
        }

        public void setFields(SearchFields searchFields) {
            this.fields = searchFields;
        }

        public void setMatch(MatchType matchType) {
            this.match = matchType;
        }

        public void setTerm(String term) {
            this.term = term;
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }

        public boolean isApplyFilter() {
            return this.applyFilter;
        }

        public void setApplyFilter(boolean applyFilter) {
            this.applyFilter = applyFilter;
        }

        public static class SearchFields
        implements Serializable {
            private static final long serialVersionUID = 6583369520862461173L;
            private boolean description;
            private boolean fileContent;
            private boolean filename;
            private boolean keywords;
            private boolean siteContent;
            private boolean tags;
            private boolean title;

            public boolean isDescription() {
                return this.description;
            }

            public boolean isFileContent() {
                return this.fileContent;
            }

            public boolean isFilename() {
                return this.filename;
            }

            public boolean isKeywords() {
                return this.keywords;
            }

            public boolean isSiteContent() {
                return this.siteContent;
            }

            public boolean isTags() {
                return this.tags;
            }

            public boolean isTitle() {
                return this.title;
            }

            public void setCustom(String[] customFields) {
                for (String custom : customFields) {
                    if (custom == null) continue;
                    if (custom.contains("siteContent")) {
                        this.setSiteContent(true);
                    }
                    if (custom.contains("fileContent")) {
                        this.setFileContent(true);
                    }
                    if (custom.contains("description")) {
                        this.setDescription(true);
                    }
                    if (custom.contains("title")) {
                        this.setTitle(true);
                    }
                    if (custom.contains("filename")) {
                        this.setFilename(true);
                    }
                    if (custom.contains("keywords")) {
                        this.setKeywords(true);
                    }
                    if (custom.contains("tags")) {
                        this.setTags(true);
                    }
                    if (!custom.contains("files")) continue;
                    this.setDescription(true);
                    this.setFileContent(true);
                    this.setFilename(true);
                    this.setKeywords(true);
                    this.setTitle(true);
                }
            }

            public void setDescription(boolean description) {
                this.description = description;
            }

            public void setFileContent(boolean everywhere) {
                this.fileContent = everywhere;
            }

            public void setFilename(boolean filename) {
                this.filename = filename;
            }

            public void setKeywords(boolean keywords) {
                this.keywords = keywords;
            }

            public void setSiteContent(boolean content) {
                this.siteContent = content;
                this.tags = content;
            }

            public void setFiles(boolean files) {
                this.setDescription(files);
                this.setFileContent(files);
                this.setFilename(files);
                this.setKeywords(files);
                this.setTitle(files);
            }

            public void setTags(boolean tags) {
                this.tags = tags;
            }

            public void setTitle(boolean title) {
                this.title = title;
            }

            public String toString() {
                return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
            }
        }

        public static enum MatchType {
            ALL_WORDS,
            ANY_WORD,
            AS_IS,
            EXACT_PHRASE,
            WITHOUT_WORDS;

        }
    }

    protected static class NodePropertyMapFactory
    implements Factory,
    Serializable {
        private static final long serialVersionUID = 5271166314214230283L;

        protected NodePropertyMapFactory() {
        }

        public Object create() {
            return LazyMap.decorate(new HashMap(), (Factory)FactoryUtils.instantiateFactory(NodeProperty.class));
        }
    }

    public static class NodePropertyDescriptor
    implements Serializable {
        private static final long serialVersionUID = 857471721394958140L;
        private String[] allowedValues;
        private boolean constrained;
        private String defaultValue;
        private String label;
        private boolean multiple;
        private String name;
        private Map<String, String> selectorOptions;
        private NodeProperty.Type type = NodeProperty.Type.TEXT;

        public NodePropertyDescriptor(String name, String label, NodeProperty.Type type) {
            this.name = name;
            this.label = label;
            this.type = type;
        }

        public String[] getAllowedValues() {
            return this.allowedValues;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getLabel() {
            return this.label;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getSelectorOptions() {
            return this.selectorOptions;
        }

        public NodeProperty.Type getType() {
            return this.type;
        }

        public boolean isConstrained() {
            return this.constrained;
        }

        public boolean isMultiple() {
            return this.multiple;
        }

        public void setAllowedValues(String[] allowedValues) {
            this.allowedValues = allowedValues;
        }

        public void setConstrained(boolean constrained) {
            this.constrained = constrained;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setMultiple(boolean multiple) {
            this.multiple = multiple;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSelectorOptions(Map<String, String> selectorOptions) {
            this.selectorOptions = new HashMap<String, String>(selectorOptions);
        }

        public void setType(NodeProperty.Type type) {
            this.type = type;
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this);
        }
    }

    public static class NodeProperty
    extends MultipleValue {
        private static final long serialVersionUID = 1356495981201889467L;
        private HierarchicalValue categoryValue = new HierarchicalValue();
        private boolean constrained;
        private DateValue dateValue = new DateValue();
        private Term.MatchType match = Term.MatchType.AS_IS;
        private boolean multiple;
        private String name;
        private String nodeType;
        private Type type = Type.TEXT;

        public HierarchicalValue getCategoryValue() {
            return this.categoryValue;
        }

        public DateValue getDateValue() {
            return this.dateValue;
        }

        public Term.MatchType getMatch() {
            return this.match;
        }

        public String getName() {
            return this.name;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isAllEmpty() {
            return super.isEmpty() && this.categoryValue.isEmpty() && this.dateValue.isEmpty();
        }

        public boolean isConstrained() {
            return this.constrained;
        }

        @Override
        public boolean isEmpty() {
            boolean empty = false;
            if (Type.CATEGORY == this.type) {
                empty = this.categoryValue.isEmpty();
            } else if (Type.DATE == this.type) {
                empty = this.dateValue.isEmpty();
            } else if (Type.TEXT == this.type || Type.BOOLEAN == this.type) {
                empty = super.isEmpty();
            } else {
                throw new IllegalArgumentException("Unknown node property value type '" + (Object)((Object)this.type) + "'");
            }
            return empty;
        }

        public boolean isMultiple() {
            return this.multiple;
        }

        public void setCategoryValue(HierarchicalValue categoryValue) {
            this.categoryValue = categoryValue;
        }

        public void setConstrained(boolean constrained) {
            this.constrained = constrained;
        }

        public void setDateValue(DateValue dateValue) {
            this.dateValue = dateValue;
        }

        public void setMatch(Term.MatchType matchType) {
            this.match = matchType;
        }

        public void setMultiple(boolean multiple) {
            this.multiple = multiple;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }

        public static enum Type {
            BOOLEAN,
            CATEGORY,
            DATE,
            TEXT;

        }
    }

    public static abstract class MultipleValue
    implements Serializable {
        private static final long serialVersionUID = 1797359207235144293L;
        private String[] values;

        public String getValue() {
            return this.values != null && this.values.length > 0 ? this.values[0] : null;
        }

        public String[] getValues() {
            return this.values;
        }

        public boolean isEmpty() {
            boolean empty = true;
            if (this.values != null && this.values.length > 0) {
                for (String val : this.values) {
                    boolean bl = empty = empty && SearchCriteria.isValueEmpty(val);
                    if (!empty) break;
                }
            }
            return empty;
        }

        public void setValue(String value) {
            this.values = new String[]{value};
        }

        public void setValues(String[] values) {
            this.values = values;
        }
    }

    public static class HierarchicalValue
    extends CommaSeparatedMultipleValue {
        private static final long serialVersionUID = -2708875840446947769L;
        private boolean includeChildren;

        public boolean isIncludeChildren() {
            return this.includeChildren;
        }

        public void setIncludeChildren(boolean includeChildren) {
            this.includeChildren = includeChildren;
        }
    }

    public static class DateValue
    implements Serializable {
        public static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"dd.MM.yyyy");
        private static final long serialVersionUID = -1637520083714465344L;
        private String from;
        private Date fromAsDate;
        private String to;
        private Date toAsDate;
        private Type type = Type.ANYTIME;

        public String getFrom() {
            return this.from;
        }

        public Date getFromAsDate() {
            return this.fromAsDate;
        }

        public String getTo() {
            return this.to;
        }

        public Date getToAsDate() {
            return this.toAsDate;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isEmpty() {
            return Type.ANYTIME.equals((Object)this.type) || Type.RANGE.equals((Object)this.type) && null == this.fromAsDate && null == this.toAsDate;
        }

        public void setFrom(String dateFromAsString) {
            if (dateFromAsString != null && dateFromAsString.length() > 0) {
                this.from = dateFromAsString;
                this.fromAsDate = DATE_FORMAT.parseDateTime(dateFromAsString).toDate();
            } else {
                this.from = null;
                this.fromAsDate = null;
            }
        }

        public void setFromAsDate(Date dateFrom) {
            this.fromAsDate = dateFrom;
            this.from = dateFrom != null ? DATE_FORMAT.print(dateFrom.getTime()) : null;
        }

        public void setTo(String dateToAsString) {
            if (dateToAsString != null && dateToAsString.length() > 0) {
                this.to = dateToAsString;
                this.toAsDate = DATE_FORMAT.parseDateTime(dateToAsString).toDate();
            } else {
                this.to = null;
                this.toAsDate = null;
            }
        }

        public void setToAsDate(Date dateTo) {
            this.toAsDate = dateTo;
            this.to = dateTo != null ? DATE_FORMAT.print(dateTo.getTime()) : null;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }

        public static enum Type {
            ANYTIME,
            LAST_MONTH,
            LAST_SIX_MONTHS,
            LAST_THREE_MONTHS,
            LAST_WEEK,
            RANGE,
            TODAY;

        }
    }

    public static class CommaSeparatedMultipleValue
    extends MultipleValue {
        private static final char MULTIPLE_VALUE_SEPARATOR = ',';
        private static final long serialVersionUID = 2324041504396269857L;

        @Override
        public void setValue(String value) {
            if (StringUtils.isNotEmpty((String)value) && value.indexOf(44) != -1) {
                super.setValues(StringUtils.split((String)value, (char)','));
            } else {
                super.setValue(value);
            }
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }
    }
}

