/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.JCRNodeHit;

public class FileHit
extends JCRNodeHit {
    public FileHit(JCRNodeWrapper node, RenderContext context) {
        super(node, context);
    }

    public String getFolderPath() {
        return this.isFolder() ? this.getPath() : FilenameUtils.getFullPathNoEndSeparator((String)this.getPath());
    }

    @Override
    public String getIconType() {
        Map<String, String> types = this.getIconTypes();
        String extension = this.isFolder() ? "dir" : FilenameUtils.getExtension((String)this.getName());
        String icon = StringUtils.isNotEmpty((String)extension) ? types.get(extension.toLowerCase()) : null;
        return icon != null ? icon : types.get("unknown");
    }

    private Map<String, String> getIconTypes() {
        return JCRContentUtils.getInstance().getFileExtensionIcons();
    }

    @Override
    public String getLink() {
        return ((JCRNodeWrapper)this.resource).getUrl();
    }

    public long getContentLength() {
        return ((JCRNodeWrapper)this.resource).getFileContent().getContentLength();
    }

    public long getContentLengthKb() {
        long length = this.getContentLength();
        return (long)(length > 0L ? (float)length / 1000.0f : 0.0f);
    }

    @Override
    public String getContentType() {
        return ((JCRNodeWrapper)this.resource).getFileContent().getContentType();
    }

    public boolean isFolder() {
        try {
            return ((JCRNodeWrapper)this.resource).isNodeType("nt:folder");
        }
        catch (RepositoryException e) {
            return false;
        }
    }
}

