/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.webflow;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.Resource;
import org.jahia.services.render.View;
import org.jahia.services.render.scripting.RequestDispatcherScript;
import org.jahia.utils.StringResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;

public class WebflowDispatcherScript
extends RequestDispatcherScript {
    private static final Pattern MODULE_PREFIX_PATTERN = Pattern.compile("/modules/[^/]*/");
    private static final Logger logger = LoggerFactory.getLogger(WebflowDispatcherScript.class);
    private String flowPath;

    public WebflowDispatcherScript(View view) {
        super(view);
    }

    @Override
    public String execute(Resource resource, RenderContext context) throws RenderException {
        StringResponseWrapper responseWrapper;
        block19: {
            String s;
            String identifier;
            final View view = this.getView();
            if (view == null) {
                throw new RenderException("View not found for : " + resource);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("View '" + view + "' resolved for resource: " + resource);
            }
            HttpServletRequest request = context.getRequest();
            HttpServletResponse response = context.getResponse();
            try {
                identifier = resource.getNode().getIdentifier();
            }
            catch (RepositoryException e) {
                throw new RenderException(e);
            }
            String identifierNoDashes = StringUtils.replace((String)identifier, (String)"-", (String)"_");
            if (resource.getTemplate() != null && !resource.getTemplate().equals("default")) {
                identifierNoDashes = identifierNoDashes + "." + resource.getTemplate();
            }
            if ((s = (String)request.getSession().getAttribute("webflowResponse" + identifierNoDashes)) != null) {
                request.getSession().removeAttribute("webflowResponse" + identifierNoDashes);
                return s;
            }
            this.flowPath = MODULE_PREFIX_PATTERN.matcher(view.getPath()).replaceFirst("");
            RequestDispatcher rd = request.getRequestDispatcher("/flow/" + this.flowPath);
            Object oldModule = request.getAttribute("currentModule");
            request.setAttribute("currentModule", (Object)view.getModule());
            if (logger.isDebugEnabled()) {
                WebflowDispatcherScript.dumpRequestAttributes(request);
            }
            responseWrapper = new StringResponseWrapper(response);
            try {
                FlowDefinitionRegistry reg = (FlowDefinitionRegistry)view.getModule().getContext().getBean("jahiaFlowRegistry");
                final GenericApplicationContext applicationContext = (GenericApplicationContext)reg.getFlowDefinition(this.flowPath).getApplicationContext();
                applicationContext.setClassLoader(view.getModule().getClassLoader());
                applicationContext.setResourceLoader(new ResourceLoader(){

                    public org.springframework.core.io.Resource getResource(String location) {
                        return applicationContext.getParent().getResource("/" + WebflowDispatcherScript.this.flowPath + "/" + location);
                    }

                    public ClassLoader getClassLoader() {
                        return view.getModule().getClassLoader();
                    }
                });
                rd.include((ServletRequest)request, (ServletResponse)responseWrapper);
                String redirect = responseWrapper.getRedirect();
                if (redirect == null) break block19;
                if (redirect.startsWith("http:/") || redirect.startsWith("https://")) {
                    context.setRedirect(responseWrapper.getRedirect());
                    break block19;
                }
                while (redirect != null) {
                    final String qs = StringUtils.substringAfter((String)responseWrapper.getRedirect(), (String)"?");
                    final HashMap<String, String[]> params = new HashMap<String, String[]>();
                    if (!StringUtils.isEmpty((String)qs)) {
                        params.put("webflowexecution" + identifierNoDashes, new String[]{StringUtils.substringAfterLast((String)qs, (String)("webflowexecution" + identifierNoDashes + "="))});
                    }
                    HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(request){

                        public String getMethod() {
                            return "GET";
                        }

                        public Map getParameterMap() {
                            return params;
                        }

                        public String getParameter(String name) {
                            return params.containsKey(name) ? ((String[])params.get(name))[0] : null;
                        }

                        public Enumeration getParameterNames() {
                            return new Vector(params.keySet()).elements();
                        }

                        public String[] getParameterValues(String name) {
                            return (String[])params.get(name);
                        }

                        public Object getAttribute(String name) {
                            if ("javax.servlet.forward.query_string".equals(name)) {
                                return qs;
                            }
                            return super.getAttribute(name);
                        }

                        public String getQueryString() {
                            return qs;
                        }
                    };
                    rd = requestWrapper.getRequestDispatcher("/flow/" + this.flowPath + "?" + qs);
                    responseWrapper = new StringResponseWrapper(response);
                    rd.include((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
                    String oldRedirect = redirect;
                    redirect = responseWrapper.getRedirect();
                    if (redirect != null) {
                        if (!redirect.startsWith("http://") && !redirect.startsWith("https://")) continue;
                        context.setRedirect(redirect);
                        break;
                    }
                    if (!request.getMethod().equals("POST")) continue;
                    request.getSession().setAttribute("webflowResponse" + identifierNoDashes, (Object)responseWrapper.getString());
                    context.setRedirect(oldRedirect);
                }
            }
            catch (ServletException e) {
                throw new RenderException(e.getRootCause() != null ? e.getRootCause() : e);
            }
            catch (IOException e) {
                throw new RenderException(e);
            }
            finally {
                request.setAttribute("currentModule", oldModule);
            }
        }
        try {
            return responseWrapper.getString();
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }

    public String getFlowPath() {
        return "/flow/" + this.flowPath;
    }

    public boolean isMultipartRequest(HttpServletRequest req) {
        String contentType = req.getHeader("Content-Type");
        return contentType != null && contentType.indexOf("multipart/form-data") >= 0;
    }
}

