/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.webflow;

import java.util.HashMap;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.Resource;
import org.jahia.services.render.webflow.WebflowDispatcherScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.core.collection.AttributeMap;

public class JahiaFlowUrlHandler
extends DefaultFlowUrlHandler {
    private static final Logger logger = LoggerFactory.getLogger(JahiaFlowUrlHandler.class);

    public String getFlowExecutionKey(HttpServletRequest request) {
        JCRNodeWrapper n = (JCRNodeWrapper)request.getAttribute("currentNode");
        if (n != null) {
            try {
                String name = this.getExecutionName(request, n);
                return request.getParameter(name);
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return super.getFlowExecutionKey(request);
            }
        }
        return super.getFlowExecutionKey(request);
    }

    public String getFlowId(HttpServletRequest request) {
        WebflowDispatcherScript script = (WebflowDispatcherScript)request.getAttribute("script");
        if (script != null) {
            String path = script.getFlowPath();
            return StringUtils.substringAfter((String)path, (String)"/flow/");
        }
        return super.getFlowId(request);
    }

    public String createFlowExecutionUrl(String flowId, String flowExecutionKey, HttpServletRequest request) {
        WebflowDispatcherScript script = (WebflowDispatcherScript)request.getAttribute("script");
        JCRNodeWrapper n = (JCRNodeWrapper)request.getAttribute("currentNode");
        if (script != null && n != null) {
            StringBuilder path = new StringBuilder(request.getRequestURI());
            path.append('?');
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                String name = this.getExecutionName(request, n);
                params.put(name, flowExecutionKey);
                this.appendQueryParameters(path, params, this.getEncodingScheme(request));
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return super.createFlowExecutionUrl(flowId, flowExecutionKey, request);
            }
            return path.toString();
        }
        return super.createFlowExecutionUrl(flowId, flowExecutionKey, request);
    }

    private String getExecutionName(HttpServletRequest request, JCRNodeWrapper n) throws RepositoryException {
        String name = "webflowexecution" + StringUtils.replace((String)n.getIdentifier(), (String)"-", (String)"_");
        Resource r = (Resource)request.getAttribute("currentResource");
        if (r != null && r.getTemplate() != null && !r.getTemplate().equals("default")) {
            name = name + "." + r.getTemplate();
        }
        return name;
    }

    public String createFlowDefinitionUrl(String flowId, AttributeMap input, HttpServletRequest request) {
        return super.createFlowDefinitionUrl(flowId, input, request);
    }
}

