/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.scripting.bundle;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.render.BundleView;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.Template;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.View;
import org.jahia.services.render.scripting.Script;
import org.jahia.services.render.scripting.ScriptFactory;
import org.jahia.services.render.scripting.ScriptResolver;
import org.jahia.services.render.scripting.bundle.ViewResourceInfo;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class BundleScriptResolver
implements ScriptResolver,
ApplicationListener<ApplicationEvent> {
    private static Logger logger = LoggerFactory.getLogger(BundleScriptResolver.class);
    private static Map<String, SortedSet<View>> viewSetCache = new ConcurrentHashMap<String, SortedSet<View>>(512);
    private Map<String, SortedMap<String, ViewResourceInfo>> availableScripts = new HashMap<String, SortedMap<String, ViewResourceInfo>>(64);
    private Map<String, ScriptFactory> scriptFactoryMap;
    private JahiaTemplateManagerService templateManagerService;
    private Comparator<ViewResourceInfo> scriptExtensionComparator;
    private List<String> scriptExtensionsOrdering;

    public void setScriptFactoryMap(Map<String, ScriptFactory> scriptFactoryMap) {
        this.scriptFactoryMap = scriptFactoryMap;
    }

    public List<String> getScriptExtensionsOrdering() {
        return this.scriptExtensionsOrdering;
    }

    public void setScriptExtensionsOrdering(List<String> extensionsOrdering) {
        this.scriptExtensionsOrdering = extensionsOrdering;
        this.scriptExtensionComparator = new Comparator<ViewResourceInfo>(){

            @Override
            public int compare(ViewResourceInfo o1, ViewResourceInfo o2) {
                int i = BundleScriptResolver.this.scriptExtensionsOrdering.indexOf(o1.extension) - BundleScriptResolver.this.scriptExtensionsOrdering.indexOf(o2.extension);
                return i != 0 ? i : 1;
            }
        };
    }

    public void addBundleScripts(Bundle bundle, List<URL> scripts) {
        for (URL script : scripts) {
            this.addBundleScript(bundle, script.getPath());
        }
    }

    public void addBundleScript(Bundle bundle, String path) {
        if (path.split("/").length != 4) {
            return;
        }
        ViewResourceInfo scriptResource = new ViewResourceInfo(path);
        SortedMap<String, ViewResourceInfo> existingBundleScripts = this.availableScripts.get(bundle.getSymbolicName());
        if (existingBundleScripts == null) {
            existingBundleScripts = new TreeMap<String, ViewResourceInfo>();
            this.availableScripts.put(bundle.getSymbolicName(), existingBundleScripts);
            existingBundleScripts.put(scriptResource.path, scriptResource);
        } else if (!existingBundleScripts.containsKey(scriptResource.path)) {
            existingBundleScripts.put(scriptResource.path, scriptResource);
        } else {
            scriptResource = (ViewResourceInfo)existingBundleScripts.get(scriptResource.path);
        }
        String properties = StringUtils.substringBeforeLast((String)path, (String)".") + ".properties";
        URL propertiesResource = bundle.getResource(properties);
        if (propertiesResource != null) {
            Properties p = new Properties();
            try {
                p.load(propertiesResource.openStream());
            }
            catch (IOException e) {
                logger.error("Cannot read properties", (Throwable)e);
            }
            scriptResource.setProperties(p);
        } else {
            scriptResource.setProperties(new Properties());
        }
        BundleScriptResolver.clearCaches();
    }

    public void removeBundleScripts(Bundle bundle, List<URL> scripts) {
        SortedMap<String, ViewResourceInfo> existingBundleScripts = this.availableScripts.get(bundle.getSymbolicName());
        if (existingBundleScripts == null) {
            return;
        }
        for (URL script : scripts) {
            existingBundleScripts.remove(script.getPath());
        }
        BundleScriptResolver.clearCaches();
    }

    public void removeBundleScript(Bundle bundle, String path) {
        SortedMap<String, ViewResourceInfo> existingBundleScripts = this.availableScripts.get(bundle.getSymbolicName());
        if (existingBundleScripts == null) {
            return;
        }
        existingBundleScripts.remove(path);
        BundleScriptResolver.clearCaches();
    }

    @Override
    public Script resolveScript(Resource resource, RenderContext renderContext) throws TemplateNotFoundException {
        try {
            View resolvedView = this.resolveView(resource, renderContext);
            if (resolvedView == null) {
                throw new TemplateNotFoundException("Unable to find the view for resource " + resource);
            }
            if (this.scriptFactoryMap.containsKey(resolvedView.getFileExtension())) {
                return this.scriptFactoryMap.get(resolvedView.getFileExtension()).createScript(resolvedView);
            }
            throw new TemplateNotFoundException("Unable to script factory map extension handler for the resolved view " + resolvedView.getInfo());
        }
        catch (RepositoryException e) {
            throw new TemplateNotFoundException(e);
        }
    }

    private View resolveView(Resource resource, RenderContext renderContext) throws RepositoryException {
        ExtendedNodeType nt = resource.getNode().getPrimaryNodeType();
        List<ExtendedNodeType> nodeTypeList = this.getNodeTypeList(nt);
        for (ExtendedNodeType type : resource.getNode().getMixinNodeTypes()) {
            nodeTypeList.addAll(0, type.getSupertypeSet());
            nodeTypeList.add(0, type);
        }
        if (resource.getResourceNodeType() != null) {
            nodeTypeList.addAll(0, this.getNodeTypeList(resource.getResourceNodeType()));
        }
        return this.resolveView(resource, nodeTypeList, renderContext);
    }

    private View resolveView(Resource resource, List<ExtendedNodeType> nodeTypeList, RenderContext renderContext) {
        String template = resource.getResolvedTemplate();
        try {
            SortedSet<View> s;
            View selected;
            JCRSiteNode site = renderContext.getSite();
            Template t = (Template)renderContext.getRequest().getAttribute("previousTemplate");
            if (t != null && t.getNode() != null) {
                site = site.getSession().getNodeByIdentifier(t.getNode()).getResolveSite();
            }
            LinkedList<String> templateTypeMappings = null;
            Channel channel = renderContext.getChannel();
            if (channel != null && !channel.getFallBack().equals("root")) {
                templateTypeMappings = new LinkedList<String>();
                while (!channel.getFallBack().equals("root")) {
                    if (channel.getCapability("template-type-mapping") != null) {
                        templateTypeMappings.add(resource.getTemplateType() + "-" + channel.getCapability("template-type-mapping"));
                    }
                    channel = ChannelService.getInstance().getChannel(channel.getFallBack());
                }
                templateTypeMappings.add(resource.getTemplateType());
            }
            if ((selected = this.getView(template, s = this.getViewsSet(nodeTypeList, site, templateTypeMappings != null ? templateTypeMappings : Arrays.asList(resource.getTemplateType())))) == null && !"default".equals(template)) {
                selected = this.getView("default", s);
            }
            return selected;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private View getView(String template, Set<View> s) {
        for (View view : s) {
            if (!view.getKey().equals(template)) continue;
            return view;
        }
        return null;
    }

    @Override
    public boolean hasView(ExtendedNodeType nt, String key, JCRSiteNode site, String templateType) {
        for (View view : this.getViewsSet(nt, site, templateType)) {
            if (!view.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SortedSet<View> getViewsSet(ExtendedNodeType nt, JCRSiteNode site, String templateType) {
        try {
            return this.getViewsSet(this.getNodeTypeList(nt), site, Arrays.asList(templateType));
        }
        catch (NoSuchNodeTypeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private List<ExtendedNodeType> getNodeTypeList(ExtendedNodeType nt) throws NoSuchNodeTypeException {
        LinkedList<ExtendedNodeType> nodeTypeList = new LinkedList<ExtendedNodeType>();
        nodeTypeList.add(nt);
        nodeTypeList.addAll(nt.getSupertypeSet());
        ExtendedNodeType base = NodeTypeRegistry.getInstance().getNodeType("nt:base");
        if (nodeTypeList.remove(base)) {
            nodeTypeList.add(base);
        }
        return nodeTypeList;
    }

    private SortedSet<View> getViewsSet(List<ExtendedNodeType> nodeTypeList, JCRSiteNode site, List<String> templateTypes) {
        StringBuilder cacheKey = new StringBuilder();
        for (ExtendedNodeType extendedNodeType : nodeTypeList) {
            cacheKey.append(extendedNodeType.getName()).append("_");
        }
        cacheKey.append("_").append(site != null ? site.getPath() : "").append("__");
        for (String string : templateTypes) {
            cacheKey.append(string).append("_");
        }
        String s = cacheKey.toString();
        if (viewSetCache.containsKey(s)) {
            return viewSetCache.get(s);
        }
        HashMap<String, View> hashMap = new HashMap<String, View>();
        Set<String> installedModules = this.getInstalledModules(site);
        for (ExtendedNodeType type : nodeTypeList) {
            JahiaTemplatesPackage defaultModule;
            boolean defaultModuleProcessed = false;
            Set<JahiaTemplatesPackage> packages = this.templateManagerService.getModulesWithViewsForComponent(JCRContentUtils.replaceColon(type.getName()));
            for (JahiaTemplatesPackage aPackage : packages) {
                String packageName = aPackage.getId();
                if (installedModules != null && !installedModules.contains(packageName)) continue;
                if (aPackage.isDefault()) {
                    defaultModuleProcessed = true;
                }
                for (String templateType : templateTypes) {
                    this.getViewsSet(type, hashMap, templateType, aPackage);
                }
            }
            if (type.getTemplatePackage() != null && installedModules != null && !installedModules.contains(type.getSystemId())) {
                for (String templateType : templateTypes) {
                    this.getViewsSet(type, hashMap, templateType, type.getTemplatePackage());
                }
            }
            if (defaultModuleProcessed || (defaultModule = this.templateManagerService.getTemplatePackageById("default")) == null) continue;
            for (String templateType : templateTypes) {
                this.getViewsSet(type, hashMap, templateType, defaultModule);
            }
        }
        TreeSet<View> t = new TreeSet<View>(hashMap.values());
        viewSetCache.put(s, t);
        return t;
    }

    private Set<String> getInstalledModules(JCRSiteNode site) {
        if (site == null) {
            return null;
        }
        Set<String> installedModules = null;
        String sitePath = site.getPath();
        if (sitePath.startsWith("/sites/")) {
            installedModules = site.getInstalledModulesWithAllDependencies();
        } else if (sitePath.startsWith("/modules/")) {
            JahiaTemplatesPackage aPackage = this.templateManagerService.getTemplatePackageById(site.getName());
            if (aPackage != null) {
                installedModules = new LinkedHashSet<String>();
                installedModules.add(aPackage.getId());
                for (JahiaTemplatesPackage depend : aPackage.getDependencies()) {
                    if (installedModules.contains(depend.getId())) continue;
                    installedModules.add(depend.getId());
                }
            }
            if (installedModules != null) {
                installedModules.add("templates-system");
                for (JahiaTemplatesPackage depend : this.templateManagerService.getTemplatePackageById("templates-system").getDependencies()) {
                    if (installedModules.contains(depend.getId())) continue;
                    installedModules.add(depend.getId());
                }
            }
        }
        return installedModules;
    }

    private void getViewsSet(ExtendedNodeType nt, Map<String, View> views, String templateType, JahiaTemplatesPackage tplPackage) {
        StringBuilder pathBuilder = new StringBuilder(64);
        pathBuilder.append("/").append(JCRContentUtils.replaceColon(nt.getAlias())).append("/").append(templateType).append("/");
        pathBuilder.append(nt.getName().contains(":") ? StringUtils.substringAfter((String)nt.getName(), (String)":") : nt.getName()).append(".");
        Set<ViewResourceInfo> sortedScripts = this.findBundleScripts(tplPackage.getId(), pathBuilder.toString());
        Properties defaultProperties = null;
        if (!sortedScripts.isEmpty()) {
            defaultProperties = new Properties();
            JahiaTemplatesPackage aPackage = nt.getTemplatePackage();
            if (aPackage == null) {
                aPackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById("default");
            }
            if (!aPackage.getId().equals(tplPackage.getId())) {
                Set<ViewResourceInfo> defaultScripts = this.findBundleScripts(aPackage.getId(), pathBuilder.toString());
                for (ViewResourceInfo defaultScript : defaultScripts) {
                    if (!defaultScript.viewKey.equals("default")) continue;
                    defaultProperties.putAll((Map<?, ?>)defaultScript.getProperties());
                    break;
                }
            }
            for (ViewResourceInfo defaultScript : sortedScripts) {
                if (!defaultScript.viewKey.equals("default")) continue;
                defaultProperties.putAll((Map<?, ?>)defaultScript.getProperties());
                break;
            }
        }
        for (ViewResourceInfo res : sortedScripts) {
            if (views.containsKey(res.viewKey)) continue;
            if (!this.scriptFactoryMap.containsKey(res.extension)) {
                logger.error("Script extension " + res.extension + " can not be handle by this system.");
                break;
            }
            BundleView view = new BundleView(res.path, res.viewKey, tplPackage, res.filename);
            view.setProperties(res.getProperties());
            view.setDefaultProperties(defaultProperties);
            views.put(res.viewKey, view);
            this.scriptFactoryMap.get(res.extension).initView(view);
        }
    }

    private Set<ViewResourceInfo> findBundleScripts(String module, String pathPrefix) {
        SortedMap<String, ViewResourceInfo> allBundleScripts = this.availableScripts.get(module);
        if (allBundleScripts == null || allBundleScripts.isEmpty()) {
            return new TreeSet<ViewResourceInfo>();
        }
        SortedMap<String, ViewResourceInfo> viewInfosWithPathGTEThanPrefix = allBundleScripts.tailMap(pathPrefix);
        if (viewInfosWithPathGTEThanPrefix.isEmpty()) {
            return new TreeSet<ViewResourceInfo>();
        }
        if (!viewInfosWithPathGTEThanPrefix.firstKey().startsWith(pathPrefix)) {
            return new TreeSet<ViewResourceInfo>();
        }
        TreeSet<ViewResourceInfo> sortedScripts = new TreeSet<ViewResourceInfo>(this.scriptExtensionComparator);
        for (String path : viewInfosWithPathGTEThanPrefix.keySet()) {
            if (path.startsWith(pathPrefix)) {
                sortedScripts.add((ViewResourceInfo)viewInfosWithPathGTEThanPrefix.get(path));
                continue;
            }
            return sortedScripts;
        }
        return sortedScripts;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof JahiaTemplateManagerService.TemplatePackageRedeployedEvent || event instanceof JahiaTemplateManagerService.ModuleDeployedOnSiteEvent || event instanceof JahiaTemplateManagerService.ModuleDependenciesEvent) {
            BundleScriptResolver.clearCaches();
        }
    }

    public static void clearCaches() {
        viewSetCache.clear();
    }
}

