/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class AclCacheKeyPartGenerator
implements CacheKeyPartGenerator,
InitializingBean {
    public static final String PER_USER = "_perUser_";
    public static final String MR_ACL = "_mraclmr_";
    public static final String PER_USER_MR_ACL = "_perUser_,_mraclmr_";
    public static final String LOGGED_USER = "_logged_";
    public static final Pattern P_PATTERN = Pattern.compile("_p_");
    public static final Pattern DEP_ACLS_PATTERN = Pattern.compile("_depacl_");
    public static final Pattern ACLS_PATH_PATTERN = Pattern.compile("_p_");
    private static final String[] SUBSTITUTION_STR = new String[]{"%0", "%1", "%2"};
    private static final String[] SPECIFIC_STR = new String[]{"@@", ",", "%"};
    private static final Logger logger = LoggerFactory.getLogger(AclCacheKeyPartGenerator.class);
    private static final String CACHE_NAME = "HTMLNodeUsersACLs";
    private static final String PROPERTY_CACHE_NAME = "HTMLRequiredPermissionsCache";
    private final Object objForSync = new Object();
    private EhCacheProvider cacheProvider;
    private Cache cache;
    private JahiaGroupManagerService groupManagerService;
    private Cache permissionCache;
    private JCRTemplate template;
    private final ConcurrentMap<String, Semaphore> processings = new ConcurrentHashMap<String, Semaphore>();

    public void setGroupManagerService(JahiaGroupManagerService groupManagerService) {
        this.groupManagerService = groupManagerService;
    }

    public void setCacheProvider(EhCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setTemplate(JCRTemplate template) {
        this.template = template;
    }

    public void afterPropertiesSet() throws Exception {
        CacheManager cacheManager = this.cacheProvider.getCacheManager();
        this.cache = cacheManager.getCache(CACHE_NAME);
        if (this.cache == null) {
            cacheManager.addCache(CACHE_NAME);
            this.cache = cacheManager.getCache(CACHE_NAME);
        }
        this.permissionCache = cacheManager.getCache(PROPERTY_CACHE_NAME);
        if (this.permissionCache == null) {
            cacheManager.addCache(PROPERTY_CACHE_NAME);
            this.permissionCache = cacheManager.getCache(PROPERTY_CACHE_NAME);
        }
    }

    @Override
    public String getKey() {
        return "acls";
    }

    @Override
    public String getValue(Resource resource, RenderContext renderContext, Properties properties) {
        try {
            Boolean[] values;
            Element element;
            String ref;
            TreeSet<String> aclsKeys = new TreeSet<String>();
            if ("true".equals(properties.get("cache.perUser"))) {
                aclsKeys.add(PER_USER);
            }
            JCRNodeWrapper node = resource.getNode();
            String nodePath = node.getPath();
            aclsKeys.add(this.encodeSpecificChars(nodePath));
            String s = (String)properties.get("cache.dependsOnVisibilityOf");
            if (s != null) {
                String[] dependencies = s.split(",");
                for (int i = 0; i < dependencies.length; ++i) {
                    String dep = dependencies[i];
                    dep = dep.replace("$currentNode", nodePath);
                    dep = dep.replace("$currentSite", renderContext.getSite().getPath());
                    dep = dep.replace("$mainResource", renderContext.getMainResource().getNode().getPath());
                    aclsKeys.add("*" + this.encodeSpecificChars(dep));
                }
            }
            if ((ref = (String)properties.get("cache.dependsOnReference")) != null && ref.length() > 0) {
                String[] refProperties = ref.split(",");
                for (int i = 0; i < refProperties.length; ++i) {
                    String refPropertyName = refProperties[i];
                    if (node.hasProperty(refPropertyName)) {
                        int propertyRequiredType;
                        JCRPropertyWrapper refProperty = node.getProperty(refPropertyName);
                        JCRSessionWrapper systemSession = JCRSessionFactory.getInstance().getCurrentSystemSession(node.getSession().getWorkspace().getName(), node.getSession().getLocale(), null);
                        if (refProperty == null || (propertyRequiredType = refProperty.getDefinition().getRequiredType()) != 9 && propertyRequiredType != 10) continue;
                        if (refProperty.isMultiple() && refProperty.getValues().length > 0) {
                            for (JCRValueWrapper value : refProperty.getValues()) {
                                try {
                                    JCRNodeWrapper refNode = systemSession.getNodeByIdentifier(value.getString());
                                    aclsKeys.add(this.encodeSpecificChars(refNode.getPath()));
                                }
                                catch (ItemNotFoundException e) {
                                    logger.debug("Trying to add cache dependency for reference but reference node '{}' not found", (Object)refProperty.getString());
                                }
                            }
                            continue;
                        }
                        try {
                            JCRNodeWrapper refNode = systemSession.getNodeByIdentifier(refProperty.getString());
                            aclsKeys.add(this.encodeSpecificChars(refNode.getPath()));
                        }
                        catch (ItemNotFoundException e) {
                            logger.debug("Trying to add cache dependency for reference but reference node '{}' not found", (Object)refProperty.getString());
                        }
                        continue;
                    }
                    logger.debug("Trying to add cache dependency for reference but property '{}' not found on node '{}'", (Object)refPropertyName, (Object)nodePath);
                }
            }
            if ((element = this.permissionCache.get((Serializable)((Object)node.getPath()))) != null && element.getObjectValue() != null) {
                values = (Boolean[])element.getObjectValue();
            } else {
                values = new Boolean[]{node.hasProperty("j:requiredPermissionNames") || node.hasProperty("j:requiredPermissions"), node.hasProperty("j:requirePrivilegedUser") && node.getProperty("j:requirePrivilegedUser").getBoolean(), node.hasProperty("j:requireLoggedUser") && node.getProperty("j:requireLoggedUser").getBoolean()};
                this.permissionCache.put(new Element((Serializable)((Object)node.getPath()), (Serializable)values));
            }
            if ("true".equals(properties.get("cache.mainResource"))) {
                aclsKeys.add(MR_ACL);
            } else if (values[0].booleanValue()) {
                aclsKeys.add(MR_ACL);
            }
            if (values[1].booleanValue()) {
                aclsKeys.add(renderContext.getSite().getPath());
            }
            if (values[2].booleanValue() || "true".equals(properties.get("cache.useLoggedInState"))) {
                aclsKeys.add(LOGGED_USER);
            }
            return StringUtils.join(aclsKeys, (String)",");
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public String replacePlaceholders(RenderContext renderContext, String keyPart) {
        String[] paths = keyPart.split(",");
        TreeMap<String, Set<String>> rolesForKey = new TreeMap<String, Set<String>>();
        StringBuilder r = new StringBuilder();
        try {
            List<Map<String, Set<String>>> principalAcl = null;
            for (String s : paths) {
                if (s.equals(PER_USER)) {
                    if (r.length() > 0) {
                        r.append("|");
                    }
                    r.append(renderContext.getUser().getUserKey());
                    continue;
                }
                if (s.equals(LOGGED_USER)) {
                    if (r.length() > 0) {
                        r.append("|");
                    }
                    r.append(Boolean.toString(renderContext.getUser().getName().equals("guest")));
                    continue;
                }
                if (principalAcl == null) {
                    principalAcl = this.getUserAcl(renderContext.getUser());
                }
                if (s.equals(MR_ACL)) {
                    this.populateRolesForKey(renderContext.getMainResource().getNode().getPath(), principalAcl, rolesForKey, null);
                    continue;
                }
                if (s.startsWith("*")) {
                    String decodedNodePath = this.decodeSpecificChars(s.substring(1));
                    this.populateRolesForKey(decodedNodePath, principalAcl, rolesForKey, Pattern.compile(decodedNodePath));
                    continue;
                }
                this.populateRolesForKey(this.decodeSpecificChars(s), principalAcl, rolesForKey, null);
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        for (Map.Entry entry : rolesForKey.entrySet()) {
            if (r.length() > 0) {
                r.append("|");
            }
            r.append(StringUtils.join((Collection)((Collection)entry.getValue()), (String)",")).append(":").append((String)entry.getKey());
        }
        keyPart = StringUtils.replace((String)r.toString(), (String)"@@", (String)"%0");
        return keyPart;
    }

    private void populateRolesForKey(String nodePath, List<Map<String, Set<String>>> principalAcl, Map<String, Set<String>> rolesForKey, Pattern pattern) {
        if (pattern == null) {
            nodePath = nodePath + "/";
            for (Map<String, Set<String>> map : principalAcl) {
                for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                    String grantPath = entry.getKey() + "/";
                    if (!nodePath.startsWith(grantPath) && !grantPath.startsWith(nodePath)) continue;
                    Set<String> roles = entry.getValue();
                    if (!rolesForKey.containsKey(entry.getKey())) {
                        rolesForKey.put(entry.getKey(), new TreeSet<String>(roles));
                        continue;
                    }
                    rolesForKey.get(entry.getKey()).addAll(roles);
                }
            }
        } else {
            for (Map<String, Set<String>> map : principalAcl) {
                for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                    if (!pattern.matcher(entry.getKey()).matches()) continue;
                    Set<String> roles = entry.getValue();
                    if (!rolesForKey.containsKey(entry.getKey())) {
                        rolesForKey.put(entry.getKey(), new TreeSet<String>(roles));
                        continue;
                    }
                    rolesForKey.get(entry.getKey()).addAll(roles);
                }
            }
        }
    }

    private List<Map<String, Set<String>>> getUserAcl(JahiaUser principal) throws RepositoryException {
        ArrayList<Map<String, Set<String>>> principalAcl = new ArrayList<Map<String, Set<String>>>();
        principalAcl.add(this.getPrincipalAcl("u:" + principal.getName(), principal.getRealm()));
        List<String> groups = this.groupManagerService.getMembershipByPath(principal.getLocalPath());
        for (String group : groups) {
            principalAcl.add(this.getPrincipalAcl("g:" + StringUtils.substringAfterLast((String)group, (String)"/"), JCRContentUtils.getSiteKey(group)));
        }
        return principalAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> getPrincipalAcl(final String aclKey, final String siteKey) throws RepositoryException {
        String cacheKey = siteKey != null ? aclKey + ":" + siteKey : aclKey;
        Element element = this.cache.get((Serializable)((Object)cacheKey));
        if (element == null) {
            Semaphore semaphore = (Semaphore)this.processings.get(cacheKey);
            if (semaphore == null) {
                semaphore = new Semaphore(1);
                this.processings.putIfAbsent(cacheKey, semaphore);
            }
            try {
                semaphore.tryAcquire(500L, TimeUnit.MILLISECONDS);
                element = this.cache.get((Serializable)((Object)cacheKey));
                if (element != null) {
                    Map map = (Map)element.getObjectValue();
                    return map;
                }
                logger.debug("Getting ACL for {}", (Object)cacheKey);
                long l = System.currentTimeMillis();
                Map<String, Set<String>> map = this.template.doExecuteWithSystemSessionAsUser(null, "live", null, new JCRCallback<Map<String, Set<String>>>(){

                    @Override
                    public Map<String, Set<String>> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        QueryWrapper query = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:ace] as ace where ace.[j:principal] = '" + JCRContentUtils.sqlEncode(aclKey) + "'", "JCR-SQL2");
                        QueryResult queryResult = query.execute();
                        NodeIterator rowIterator = queryResult.getNodes();
                        ConcurrentHashMap<String, Set<String>> mapGranted = new ConcurrentHashMap<String, Set<String>>();
                        LinkedHashMap mapDenied = new LinkedHashMap();
                        while (rowIterator.hasNext()) {
                            JCRValueWrapper[] roles;
                            JCRNodeWrapper node = (JCRNodeWrapper)rowIterator.next();
                            if (siteKey != null && !node.getResolveSite().getName().equals(siteKey)) continue;
                            String path = node.getParent().getParent().getPath();
                            HashSet<String> foundRoles = new HashSet<String>();
                            boolean granted = node.getProperty("j:aceType").getString().equals("GRANT");
                            for (JCRValueWrapper r : roles = node.getProperty("j:roles").getValues()) {
                                String role = r.getString();
                                if (foundRoles.contains(role)) continue;
                                foundRoles.add(role);
                            }
                            if (path.equals("/")) {
                                path = "";
                            }
                            if (granted) {
                                mapGranted.put(path, foundRoles);
                                continue;
                            }
                            mapDenied.put(path, foundRoles);
                        }
                        Iterator i$ = mapDenied.keySet().iterator();
                        while (i$.hasNext()) {
                            String deniedPath;
                            String grantedPath = deniedPath = (String)i$.next();
                            while (grantedPath.length() > 0) {
                                if (!mapGranted.containsKey(grantedPath = StringUtils.substringBeforeLast((String)grantedPath, (String)"/"))) continue;
                                Collection intersection = CollectionUtils.intersection((Collection)((Collection)mapGranted.get(grantedPath)), (Collection)((Collection)mapDenied.get(deniedPath)));
                                for (String s : intersection) {
                                    ((Set)mapGranted.get(grantedPath)).add(s + " -> " + deniedPath);
                                }
                            }
                        }
                        return mapGranted;
                    }
                });
                element = new Element((Object)cacheKey, map);
                element.setEternal(true);
                this.cache.put(element);
                logger.debug("Getting ACL for {} took {} ms", (Object)cacheKey, (Object)(System.currentTimeMillis() - l));
            }
            catch (InterruptedException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            finally {
                semaphore.release();
            }
        }
        return (Map)element.getObjectValue();
    }

    public void flushUsersGroupsKey() {
        this.flushUsersGroupsKey(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushUsersGroupsKey(boolean propageToOtherClusterNodes) {
        Object object = this.objForSync;
        synchronized (object) {
            this.cache.removeAll(!propageToOtherClusterNodes);
            this.cache.flush();
            logger.debug("Flushed HTMLNodeUsersACLs cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushUsersGroupsKey(String key, boolean propageToOtherClusterNodes) {
        Object object = this.objForSync;
        synchronized (object) {
            this.cache.remove((Serializable)((Object)key), !propageToOtherClusterNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushPermissionCacheEntry(String path, boolean propageToOtherClusterNodes) {
        Object object = this.objForSync;
        synchronized (object) {
            this.permissionCache.remove((Serializable)((Object)path));
        }
    }

    private String encodeSpecificChars(String toEncode) {
        return StringUtils.replaceEach((String)toEncode, (String[])SPECIFIC_STR, (String[])SUBSTITUTION_STR);
    }

    private String decodeSpecificChars(String toDecode) {
        return StringUtils.replaceEach((String)toDecode, (String[])SUBSTITUTION_STR, (String[])SPECIFIC_STR);
    }
}

