/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.Tag;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;

public class RegexpFilter
extends AbstractFilter {
    private Map<Pattern, String> regexp;
    private boolean contentOnly;

    public void setRegexp(Map<String, String> regexp) {
        if (!regexp.isEmpty()) {
            this.regexp = new LinkedHashMap<Pattern, String>();
            for (Map.Entry<String, String> replacement : regexp.entrySet()) {
                this.regexp.put(Pattern.compile(replacement.getKey()), replacement.getValue());
            }
        }
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        if (this.regexp == null) {
            return previousOut;
        }
        if (!this.contentOnly) {
            for (Map.Entry<Pattern, String> replacement : this.regexp.entrySet()) {
                previousOut = replacement.getKey().matcher(previousOut).replaceAll(replacement.getValue());
            }
            return previousOut;
        }
        StringBuilder buffer = new StringBuilder(previousOut);
        Source source = new Source((CharSequence)previousOut);
        source.setLogger(null);
        List tags = source.getAllTags();
        int offset = 0;
        for (Tag tag : tags) {
            int begin = tag.getEnd() + offset;
            int end = tag.getNextTag() != null ? tag.getNextTag().getBegin() + offset : previousOut.length() + offset - 1;
            String repl = buffer.substring(begin, end);
            for (Map.Entry<Pattern, String> replacement : this.regexp.entrySet()) {
                repl = replacement.getKey().matcher(repl).replaceAll(replacement.getValue());
            }
            buffer.replace(begin, end, repl);
            offset += repl.length() - (end - begin);
        }
        return buffer.toString();
    }
}

