/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.utils.ScriptEngineUtils;
import org.jahia.utils.WebUtils;
import org.jahia.utils.i18n.ResourceBundles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class MarkedForDeletionFilter
extends AbstractFilter
implements ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(MarkedForDeletionFilter.class);
    private String resolvedTemplate;
    private String template;
    private String templateExtension;

    protected String getTemplateContent() throws IOException {
        if (this.resolvedTemplate == null) {
            this.resolvedTemplate = WebUtils.getResourceAsString(this.template);
            if (this.resolvedTemplate == null) {
                logger.warn("Unable to lookup template at {}", (Object)this.template);
                this.resolvedTemplate = "";
            }
        }
        return this.resolvedTemplate;
    }

    protected String getTemplateOutput(RenderContext renderContext, Resource resource) {
        String out = "";
        try {
            String template = this.getTemplateContent();
            this.resolvedTemplate = null;
            if (StringUtils.isEmpty((String)template)) {
                return "";
            }
            ScriptEngine engine = ScriptEngineUtils.getInstance().scriptEngine(this.templateExtension);
            SimpleScriptContext ctx = new SimpleScriptContext();
            ctx.setWriter(new StringWriter());
            Bindings bindings = engine.createBindings();
            bindings.put("renderContext", (Object)renderContext);
            bindings.put("resource", (Object)resource);
            final ResourceBundle bundle = ResourceBundles.getInternal(renderContext.getUILocale());
            bindings.put("bundle", (Object)bundle);
            bindings.put("i18n", (Object)LazyMap.decorate(new HashMap(2), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    String value = null;
                    String key = String.valueOf(input);
                    try {
                        value = bundle.getString(key);
                    }
                    catch (MissingResourceException e) {
                        value = key;
                    }
                    return value;
                }
            }));
            ctx.setBindings(bindings, 100);
            engine.eval(template, (ScriptContext)ctx);
            out = ((StringWriter)ctx.getWriter()).getBuffer().toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return out;
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent event) {
        this.resolvedTemplate = null;
    }

    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        if (resource.getNode().isNodeType("jmix:markedForDeletion")) {
            if ("page".equals(resource.getContextConfiguration())) {
                return this.getTemplateOutput(renderContext, resource);
            }
            return "";
        }
        return null;
    }

    public void setTemplate(String template) {
        this.template = template;
        if (template != null) {
            this.templateExtension = StringUtils.substringAfterLast((String)template, (String)".");
        }
    }
}

