/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;

public class HtmlTagAttributeTraverser {
    private Map<String, Set<String>> attributesToVisit;

    public HtmlTagAttributeTraverser(Map<String, Set<String>> attributesToVisit) {
        this.attributesToVisit = attributesToVisit;
    }

    public String traverse(String htmlContent, HtmlTagAttributeVisitor ... visitors) {
        return this.traverse(htmlContent, (RenderContext)null, (Resource)null, visitors);
    }

    public String traverse(String htmlContent, RenderContext context, Resource resource, HtmlTagAttributeVisitor ... visitors) {
        if (this.attributesToVisit == null || this.attributesToVisit.isEmpty() || visitors == null || visitors.length == 0) {
            return htmlContent;
        }
        Source source = new Source((CharSequence)htmlContent);
        source.setLogger(null);
        OutputDocument document = null;
        for (Map.Entry<String, Set<String>> tag : this.attributesToVisit.entrySet()) {
            List tags = source.getAllStartTags(tag.getKey());
            for (StartTag startTag : tags) {
                Attributes attributes = startTag.getAttributes();
                for (String attrName : tag.getValue()) {
                    String originalValue;
                    Attribute attribute = attributes.get(attrName);
                    if (attribute == null) continue;
                    String value = originalValue = attribute.getValue();
                    for (HtmlTagAttributeVisitor visitor : visitors) {
                        value = visitor.visit(value, context, startTag.getName(), attrName, resource);
                    }
                    if (originalValue == value || originalValue == null || originalValue.equals(value)) continue;
                    if (document == null) {
                        document = new OutputDocument(source);
                    }
                    document.replace(attribute.getValueSegment(), (CharSequence)value);
                }
            }
        }
        return document != null ? document.toString() : htmlContent;
    }

    public static interface HtmlTagAttributeVisitor {
        public String visit(String var1, RenderContext var2, String var3, String var4, Resource var5);
    }
}

