/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.apache.noggit.ObjectBuilder;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;

public class FormTokenFilter
extends AbstractFilter {
    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        Source source = new Source((CharSequence)previousOut);
        source.setLogger(null);
        List jahiaFormTags = source.getAllStartTags("jahia:token-form");
        if (!jahiaFormTags.isEmpty()) {
            HashMap<StartTag, String> m = new HashMap<StartTag, String>();
            for (StartTag formTag : jahiaFormTags) {
                String formid = formTag.getAttributeValue("id");
                Map hiddenInputs = (Map)ObjectBuilder.fromJSON((String)formTag.getAttributeValue("forms-data"));
                if (hiddenInputs == null) continue;
                String id = UUID.randomUUID().toString();
                HashMap<String, Map> toks = (HashMap<String, Map>)renderContext.getRequest().getSession().getAttribute("form-tokens");
                if (toks == null) {
                    toks = new HashMap<String, Map>();
                    renderContext.getRequest().getSession().setAttribute("form-tokens", toks);
                }
                toks.put(id, hiddenInputs);
                m.put(formTag, id);
                renderContext.getRequest().setAttribute("form-" + formid, (Object)id);
            }
            OutputDocument outputDocument = new OutputDocument(source);
            Collections.reverse(jahiaFormTags);
            for (StartTag jahiaFormTag : jahiaFormTags) {
                outputDocument.replace((Segment)jahiaFormTag, (CharSequence)("<input type=\"hidden\" name=\"form-token\" value=\"" + (String)m.get(jahiaFormTag) + "\"/>"));
            }
            return outputDocument.toString().trim();
        }
        return previousOut;
    }
}

