/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;

public class EmailObfuscatorFilter
extends AbstractFilter {
    private static final String WSP = "[\\x20\\x09]";
    private static final String CRLF = "(\\x0D\\x0A)";
    private static final String FWS = "(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)";
    private static final String NOWSCTL = "\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F";
    private static final String sp = "\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E";
    private static final String atext = "[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]";
    private static final String atom = "(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?";
    private static final String dotAtom = "\\.(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?";
    private static final String dotAtomText = "(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(\\.(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?)*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?";
    private static final String qtext = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\x21\\x23-\\x5B\\x5D-\\x7E]";
    private static final String text = "[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]";
    private static final String quotedPair = "\\x5C[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]";
    private static final String qcontent = "([\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\x21\\x23-\\x5B\\x5D-\\x7E]|\\x5C[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])";
    private static final String quotedString = "(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x22((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?([\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\x21\\x23-\\x5B\\x5D-\\x7E]|\\x5C[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x22(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?";
    private static final String localpart = "((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(\\.(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?)*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?|(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x22((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?([\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\x21\\x23-\\x5B\\x5D-\\x7E]|\\x5C[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x22(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?)";
    private static final String dtext = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\x21-\\x5A\\x5E-\\x7E]";
    private static final String dcontent = "([\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\x21-\\x5A\\x5E-\\x7E]|\\x5C[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])";
    private static final String domainLiteral = "(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x5B((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?([\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\x21-\\x5A\\x5E-\\x7E]|\\x5C[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x5D(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?";
    private static final String domain = "((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(\\.(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?)*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?|(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x5B((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?([\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\x21-\\x5A\\x5E-\\x7E]|\\x5C[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x5D(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?)";
    private static final String addrSpec = "(((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(\\.(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?)*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?|(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x22((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?([\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\x21\\x23-\\x5B\\x5D-\\x7E]|\\x5C[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x22(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?)@((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(\\.(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?)*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?|(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x5B((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?([\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\x21-\\x5A\\x5E-\\x7E]|\\x5C[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x5D(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?))";
    public static final Pattern VALID_EMAIL_IN_STRING_SIMPLE = Pattern.compile(".*(((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(\\.(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?)*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?|(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x22((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?([\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\x21\\x23-\\x5B\\x5D-\\x7E]|\\x5C[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x22(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?)@((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?(\\.(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?[a-zA-Z0-9\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F\\x3D\\x3F\\x5E-\\x60\\x7B-\\x7E]+(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?)*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?|(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x5B((([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?([\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\x21-\\x5A\\x5E-\\x7E]|\\x5C[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?\\x5D(([\\x20\\x09]*(\\x0D\\x0A))?[\\x20\\x09]+)?)).*", 32);

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        StringBuilder wholeHtml = new StringBuilder(previousOut);
        StringTokenizer st = new StringTokenizer(previousOut);
        while (st.hasMoreTokens()) {
            int index;
            String current = st.nextToken();
            if (!EmailObfuscatorFilter.containsAddress(current)) continue;
            String[] split = current.split(addrSpec, 2);
            String email = current.substring(split[0].length(), current.length() - split[1].length());
            int lastIndex = index = wholeHtml.indexOf(email);
            while (index != -1) {
                String entityVersion;
                lastIndex = index + 1;
                if (index > 7 && wholeHtml.substring(index - 7, index).equals("mailto:")) {
                    entityVersion = EmailObfuscatorFilter.convertToHtmlEntity("mailto:" + email);
                    wholeHtml.replace(index - 7, index + email.length(), entityVersion);
                } else {
                    entityVersion = EmailObfuscatorFilter.convertToHtmlEntity(email);
                    wholeHtml.replace(index, index + email.length(), entityVersion);
                }
                index = wholeHtml.indexOf(email, lastIndex);
            }
        }
        return wholeHtml.toString();
    }

    public static boolean containsAddress(String string) {
        if (!string.contains("@")) {
            return false;
        }
        return string != null && VALID_EMAIL_IN_STRING_SIMPLE.matcher(string).matches();
    }

    static String convertToHtmlEntity(String email) {
        StringBuilder toReturn = new StringBuilder();
        for (int i = 0; i < email.length(); ++i) {
            toReturn.append("&#").append((int)email.charAt(i)).append(";");
        }
        return toReturn.toString();
    }
}

