/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.render.View;
import org.jahia.services.templates.ModuleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FileSystemView
implements Comparable<View>,
View {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static Logger logger = LoggerFactory.getLogger(FileSystemView.class);
    private String path;
    private String fileExtension;
    private String key;
    private JahiaTemplatesPackage ownerPackage;
    private String moduleVersion;
    private String displayName;
    private Properties properties;
    private Properties defaultProperties;
    public static final String THUMBNAIL = "image";
    private static Map<String, Properties> propCache = new ConcurrentHashMap<String, Properties>();

    public static void clearPropertiesCache() {
        propCache.clear();
    }

    public FileSystemView(String path, String key, JahiaTemplatesPackage ownerPackage, ModuleVersion version, String displayName) {
        this.path = path;
        this.key = key;
        this.ownerPackage = ownerPackage;
        this.moduleVersion = StringUtils.defaultIfEmpty((String)version.toString(), null);
        this.displayName = displayName;
        int lastDotPos = path.lastIndexOf(".");
        if (lastDotPos > 0) {
            this.fileExtension = path.substring(lastDotPos + 1);
        }
        String pathWithoutExtension = path.substring(0, lastDotPos);
        String propName = pathWithoutExtension + ".properties";
        String absolutePath = StringUtils.substringBeforeLast((String)path, (String)File.separator);
        String fileName = StringUtils.substringAfterLast((String)path, (String)File.separator);
        String pathBeforeDot = StringUtils.substringBefore((String)fileName, (String)".");
        String defaultPropName = pathBeforeDot + ".properties";
        String thumbnail = pathWithoutExtension + ".png";
        String defaultThumbnail = pathBeforeDot + ".png";
        this.getProperties(propName, thumbnail, false);
        this.getProperties(absolutePath + File.separator + defaultPropName, defaultThumbnail, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getProperties(String propName, String thumbnail, boolean defaultProps) {
        Properties properties = propCache.get(propName);
        if (properties == null) {
            properties = EMPTY_PROPERTIES;
            InputStream is = JahiaContextLoaderListener.getServletContext().getResourceAsStream(propName);
            if (is != null) {
                properties = new Properties();
                try {
                    properties.load(is);
                }
                catch (IOException e) {
                    logger.warn("Unable to read associated properties file under " + propName, (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            propCache.put(propName, properties);
        }
        if (defaultProps) {
            this.defaultProperties = properties;
        } else {
            this.properties = properties;
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public JahiaTemplatesPackage getModule() {
        return this.ownerPackage;
    }

    @Override
    public String getModuleVersion() {
        return this.moduleVersion;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getInfo() {
        return "Path dispatch: " + this.path;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemView template = (FileSystemView)o;
        if (this.displayName != null ? !this.displayName.equals(template.displayName) : template.displayName != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(template.key) : template.key != null) {
            return false;
        }
        if (this.ownerPackage != null ? !this.ownerPackage.equals(template.ownerPackage) : template.ownerPackage != null) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(template.path) : template.path != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.ownerPackage != null ? this.ownerPackage.hashCode() : 0);
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(View template) {
        if (this.ownerPackage == null) {
            if (template.getModule() != null) {
                return 1;
            }
            return this.key.compareTo(template.getKey());
        }
        if (template.getModule() == null) {
            return -1;
        }
        if (!this.ownerPackage.equals(template.getModule())) {
            return this.ownerPackage.getName().compareTo(template.getModule().getName());
        }
        return this.key.compareTo(template.getKey());
    }
}

