/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.preferences;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.JahiaService;
import org.jahia.services.cache.CacheService;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.preferences.JahiaPreferencesProvider;
import org.jahia.services.preferences.exception.JahiaPreferenceProviderException;
import org.jahia.services.preferences.generic.GenericJahiaPreference;
import org.jahia.services.preferences.impl.JahiaPreferencesJCRProviders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaPreferencesService
extends JahiaService {
    private static final Logger logger = LoggerFactory.getLogger(JahiaPreferencesService.class);
    private CacheService cacheService;
    private JCRStoreService jcrStoreService;
    private Map<String, String> providerTypes;
    private Map<String, JahiaPreferencesProvider> providers;
    private Map<Class, JahiaPreferencesProvider> providersByClass;

    private JahiaPreferencesService() {
    }

    @Override
    public synchronized void start() throws JahiaInitializationException {
        logger.debug("** Initializing the Preferences Service ...");
        this.providers = new HashMap<String, JahiaPreferencesProvider>();
        this.providersByClass = new HashMap<Class, JahiaPreferencesProvider>();
        for (String providerType : this.providerTypes.keySet()) {
            String nodeType = this.providerTypes.get(providerType);
            Class<? extends JCRNodeDecorator> clazz = this.jcrStoreService.getDecorators().get(nodeType);
            Class<JCRNodeWrapper> aClass = clazz.asSubclass(JCRNodeWrapper.class);
            JahiaPreferencesJCRProviders<JCRNodeWrapper> provider = this.createProvider(aClass);
            this.providersByClass.put(aClass, provider);
            provider.setType(providerType);
            provider.setNodeType(nodeType);
            provider.setJCRSessionFactory(this.jcrStoreService.getSessionFactory());
            this.providers.put(providerType, provider);
        }
    }

    public <T extends JCRNodeWrapper> JahiaPreferencesJCRProviders<T> createProvider(Class<T> c) {
        return new JahiaPreferencesJCRProviders();
    }

    @Override
    public synchronized void stop() {
        logger.debug("** Stop the Preferences Service ...");
    }

    public static JahiaPreferencesService getInstance() {
        return Holder.INSTANCE;
    }

    public CacheService getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public JCRStoreService getJcrStoreService() {
        return this.jcrStoreService;
    }

    public void setJcrStoreService(JCRStoreService jcrStoreService) {
        this.jcrStoreService = jcrStoreService;
    }

    public synchronized Map<String, String> getProviderTypes() {
        return Collections.unmodifiableMap(this.providerTypes);
    }

    public synchronized void setProviderTypes(Map<String, String> providerTypes) {
        this.providerTypes = providerTypes;
    }

    public Map getProviders() {
        return this.providers;
    }

    public void setProviders(Map providers) {
        this.providers = providers;
    }

    public void deleteAllPreferencesByPrincipal(Principal principal) {
        Map<String, JahiaPreferencesProvider> allProviders = this.getProvidersMap();
        for (JahiaPreferencesProvider jahiaPreferencesProvider : allProviders.values()) {
            jahiaPreferencesProvider.deleteAllPreferencesByPrincipal(principal);
        }
    }

    public JahiaPreferencesProvider getPreferencesProviderByType(String providerType) throws JahiaPreferenceProviderException {
        return this.providers.get(providerType);
    }

    public <T extends JCRNodeWrapper> JahiaPreferencesProvider<T> getPreferencesProviderByClass(Class<T> c) throws JahiaPreferenceProviderException {
        return this.providersByClass.get(c);
    }

    public JahiaPreferencesProvider<GenericJahiaPreference> getGenericPreferencesProvider() throws JahiaPreferenceProviderException {
        return this.getPreferencesProviderByType("simple");
    }

    private Map<String, JahiaPreferencesProvider> getProvidersMap() {
        return this.providers;
    }

    private static class Holder {
        static final JahiaPreferencesService INSTANCE = new JahiaPreferencesService();

        private Holder() {
        }
    }
}

