/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.notification;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.jahia.utils.i18n.Messages;

public class ToolbarWarningsService {
    List<String> messages;

    public static ToolbarWarningsService getInstance() {
        return Holder.INSTANCE;
    }

    public void addMessage(String message) {
        if (this.messages == null) {
            this.messages = new ArrayList<String>();
        }
        this.messages.add(message);
    }

    public String getMessagesAsString() {
        return this.messages != null ? StringUtils.join(this.messages, (String)"||") : "";
    }

    public String getMessagesValueAsString(Locale locale) {
        if (this.messages == null) {
            return "";
        }
        ArrayList<String> translatedMessages = new ArrayList<String>();
        for (String m : this.messages) {
            translatedMessages.add(Messages.getInternal(m, locale, m));
        }
        return StringUtils.join(translatedMessages, (String)"||");
    }

    private static class Holder {
        static final ToolbarWarningsService INSTANCE = new ToolbarWarningsService();

        private Holder() {
        }
    }
}

