/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.notification;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.taglibs.standard.tag.common.core.ImportSupport;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.StringResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public class HttpClientService
implements ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientService.class);
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTPS_PROXY_USER = "https.proxyUser";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    private HttpClient httpClient;
    private ServletContext servletContext;

    public static boolean isAbsoluteUrl(String url) {
        return ImportSupport.isAbsoluteUrl((String)url);
    }

    public String executeGet(String url) throws IllegalArgumentException {
        return this.executeGet(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeGet(String url, Map<String, String> headers) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Provided URL is null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Asked to get content from the URL {} using GET method", (Object)url);
        }
        String content = null;
        GetMethod httpMethod = new GetMethod(url);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                httpMethod.addRequestHeader(header.getKey(), header.getValue());
            }
        }
        try {
            this.httpClient.executeMethod((HttpMethod)httpMethod);
            StatusLine statusLine = httpMethod.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() == 200) {
                content = httpMethod.getResponseBodyAsString();
            } else {
                logger.warn("Connection to URL: " + url + " failed with status " + statusLine);
            }
        }
        catch (HttpException e) {
            logger.error("Unable to get the content of the URL: " + url + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to get the content of the URL: " + url + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        finally {
            httpMethod.releaseConnection();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved " + (content != null ? content.length() : 0) + " characters as a response");
            if (logger.isTraceEnabled()) {
                logger.trace("Content:\n" + content);
            }
        }
        return content;
    }

    public String executePost(String url, Map<String, String> parameters, Map<String, String> headers) throws IllegalArgumentException {
        return this.executePost(url, parameters, headers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executePost(String url, Map<String, String> parameters, Map<String, String> headers, HttpState state) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Provided URL is null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Asked to get content from the URL {} using POST method with parameters {}", (Object)url, parameters);
        }
        String content = null;
        PostMethod httpMethod = new PostMethod(url);
        if (parameters != null && !parameters.isEmpty()) {
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                httpMethod.addParameter(param.getKey(), param.getValue());
            }
        }
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                httpMethod.addRequestHeader(header.getKey(), header.getValue());
            }
        }
        try {
            this.httpClient.executeMethod(null, (HttpMethod)httpMethod, state);
            StatusLine statusLine = httpMethod.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() == 200) {
                content = httpMethod.getResponseBodyAsString();
            } else {
                logger.warn("Connection to URL: " + url + " failed with status " + statusLine);
            }
        }
        catch (HttpException e) {
            logger.error("Unable to get the content of the URL: " + url + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to get the content of the URL: " + url + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        finally {
            httpMethod.releaseConnection();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved " + (content != null ? content.length() : 0) + " characters as a response");
            if (logger.isTraceEnabled()) {
                logger.trace("Content:\n" + content);
            }
        }
        return content;
    }

    public String getAbsoluteResourceAsString(String url) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Provided URL is null");
        }
        if (!HttpClientService.isAbsoluteUrl(url)) {
            throw new IllegalArgumentException("Cannot handle non-absolute URL: " + url);
        }
        return this.executeGet(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContextResourceAsString(String url) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Provided URL is null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Asked to get content from the context resource: " + url);
        }
        String content = null;
        InputStream is = this.servletContext.getResourceAsStream(url);
        if (is != null) {
            StringWriter writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)is, (Writer)writer, (String)SettingsBean.getInstance().getCharacterEncoding());
                content = writer.toString();
            }
            catch (IOException e) {
                logger.warn("Error reading content of the resource " + url + ". Cause: " + e.getMessage(), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        } else {
            logger.warn("Unable to find context resource at path " + url);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved " + (content != null ? content.length() : 0) + " characters as a response");
            if (logger.isTraceEnabled()) {
                logger.trace("Content:\n" + content);
            }
        }
        return content;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getResourceAsString(String url) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Provided URL is null");
        }
        return HttpClientService.isAbsoluteUrl(url) ? this.getAbsoluteResourceAsString(url) : this.getContextResourceAsString(url);
    }

    public String getResourceAsString(String url, HttpServletRequest request, HttpServletResponse response) throws IllegalArgumentException {
        String content;
        block11: {
            if (StringUtils.isEmpty((String)url)) {
                throw new IllegalArgumentException("Provided URL is null");
            }
            if (HttpClientService.isAbsoluteUrl(url)) {
                return this.getAbsoluteResourceAsString(url);
            }
            if (!url.startsWith("/")) {
                throw new IllegalArgumentException("Provided relative URL does not start with a '/'");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Asked to get content from the URL: " + url);
            }
            content = null;
            RequestDispatcher rd = request.getRequestDispatcher(url);
            if (rd != null) {
                StringResponseWrapper wrapper = new StringResponseWrapper(response);
                try {
                    rd.include((ServletRequest)request, (ServletResponse)wrapper);
                    if (wrapper.getStatus() < 200 || wrapper.getStatus() > 299) {
                        logger.warn("Unable to get the content of the resource " + url + ". Got response status code: " + wrapper.getStatus());
                        break block11;
                    }
                    content = wrapper.getString();
                }
                catch (Exception e) {
                    logger.warn("Unable to get the content of the resource " + url + ". Cause: " + e.getMessage(), (Throwable)e);
                }
            } else {
                logger.warn("Unable to get a RequestDispatcher for the path " + url);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved " + (content != null ? content.length() : 0) + " characters as a response");
            if (logger.isTraceEnabled()) {
                logger.trace("Content:\n" + content);
            }
        }
        return content;
    }

    public void setHttpClient(HttpClient httpClient) {
        String proxyHost;
        this.httpClient = httpClient;
        String httpsProxyHost = System.getProperty(HTTPS_PROXY_HOST);
        boolean isHttps = false;
        if (StringUtils.isNotBlank((String)httpsProxyHost)) {
            proxyHost = httpsProxyHost;
            isHttps = true;
        } else {
            proxyHost = System.getProperty(HTTP_PROXY_HOST);
        }
        if (StringUtils.isNotBlank((String)proxyHost)) {
            String proxyUser;
            String proxyPort;
            String string = proxyPort = isHttps ? System.getProperty(HTTPS_PROXY_PORT) : System.getProperty(HTTP_PROXY_PORT);
            int port = StringUtils.isEmpty((String)proxyPort) ? (isHttps ? 443 : 80) : Integer.parseInt(proxyPort);
            String string2 = proxyUser = isHttps ? System.getProperty(HTTPS_PROXY_USER) : System.getProperty(HTTP_PROXY_USER);
            if (StringUtils.isNotBlank((String)proxyUser)) {
                final String proxyPassword = isHttps ? System.getProperty(HTTPS_PROXY_PASSWORD) : System.getProperty(HTTP_PROXY_PASSWORD);
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                });
            }
            HostConfiguration currentConfiguration = httpClient.getHostConfiguration();
            currentConfiguration.setProxy(proxyHost, port);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void shutdown() {
        logger.info("Shutting down HttpClient...");
        try {
            if (this.httpClient.getHttpConnectionManager() instanceof MultiThreadedHttpConnectionManager) {
                ((MultiThreadedHttpConnectionManager)this.httpClient.getHttpConnectionManager()).shutdown();
            } else if (this.httpClient.getHttpConnectionManager() instanceof SimpleHttpConnectionManager) {
                ((SimpleHttpConnectionManager)this.httpClient.getHttpConnectionManager()).shutdown();
            }
            MultiThreadedHttpConnectionManager.shutdownAll();
        }
        catch (Exception e) {
            logger.warn("Error shutting down HttpClient. Cause: " + e.getMessage(), (Throwable)e);
        }
        logger.info("...done");
    }
}

