/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.mail;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MailSettings
implements Serializable {
    private static final long serialVersionUID = -3891985143146442266L;
    private static final FastHashMap MAIL_NOTIFICATION_LEVELS = new FastHashMap(4);
    private boolean configurationValid;
    private String from;
    private String uri;
    private String notificationLevel;
    private int notificationSeverity;
    private boolean serviceActivated;
    private String to;

    public MailSettings() {
        this.setNotificationLevel("Disabled");
    }

    public MailSettings(boolean serviceEnabled, String uri, String from, String to, String notificationLevel) {
        this.serviceActivated = serviceEnabled;
        this.uri = uri;
        this.from = from;
        this.to = to;
        this.setNotificationLevel(notificationLevel);
    }

    public String getFrom() {
        return this.from;
    }

    public String getNotificationLevel() {
        return this.notificationLevel;
    }

    public int getNotificationSeverity() {
        return this.notificationSeverity;
    }

    public String getTo() {
        return this.to;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isConfigurationValid() {
        return this.configurationValid;
    }

    public boolean isServiceActivated() {
        return this.serviceActivated;
    }

    public void setConfigurationValid(boolean configugationValid) {
        this.configurationValid = configugationValid;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setNotificationLevel(String notificationLevel) {
        this.notificationLevel = notificationLevel;
        this.notificationSeverity = (Integer)MAIL_NOTIFICATION_LEVELS.get((Object)notificationLevel);
    }

    public void setServiceActivated(boolean serviceActivated) {
        this.serviceActivated = serviceActivated;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getUser() {
        String uri = this.getUri();
        String user = null;
        if (uri.contains("@")) {
            String authPart = StringUtils.substringBeforeLast((String)uri, (String)"@");
            user = authPart.contains(":") ? StringUtils.substringBefore((String)authPart, (String)":") : authPart;
        }
        return user;
    }

    public String getPassword() {
        String authPart;
        String uri = this.getUri();
        String pwd = null;
        if (uri.contains("@") && (authPart = StringUtils.substringBeforeLast((String)uri, (String)"@")).contains(":")) {
            pwd = StringUtils.substringAfter((String)authPart, (String)":");
        }
        return pwd;
    }

    public int getPort() {
        String uri = this.getUri();
        int port = 0;
        if (uri.contains("@")) {
            uri = StringUtils.substringAfterLast((String)uri, (String)"@");
        }
        if (uri.contains(":")) {
            String portPart = StringUtils.substringAfterLast((String)uri, (String)":");
            port = Integer.parseInt(StringUtils.substringBefore((String)portPart, (String)"["));
        }
        return port;
    }

    public String getSmtpHost() {
        String uri = this.getUri();
        if (uri.contains("@")) {
            uri = StringUtils.substringAfterLast((String)uri, (String)"@");
        }
        if (uri.contains(":")) {
            uri = StringUtils.substringBeforeLast((String)uri, (String)":");
        }
        if (uri.contains("?")) {
            uri = StringUtils.substringBefore((String)uri, (String)"?");
        }
        if (uri.contains("&")) {
            uri = StringUtils.substringBefore((String)uri, (String)"&");
        }
        return uri;
    }

    public Map<String, String> getOptions() {
        String portPart;
        String optionsPart;
        String uri = this.getUri();
        HashMap<String, String> options = new HashMap<String, String>();
        if (uri.contains("@")) {
            uri = StringUtils.substringAfterLast((String)uri, (String)"@");
        }
        if (uri.contains(":") && (optionsPart = StringUtils.substringBetween((String)(portPart = StringUtils.substringAfterLast((String)uri, (String)":")), (String)"[", (String)"]")) != null && optionsPart.length() > 0) {
            String[] props;
            for (String theProperty : props = StringUtils.split((String)optionsPart, (String)",")) {
                String[] keyValue = StringUtils.split((String)theProperty, (String)"=");
                options.put(keyValue[0].trim(), keyValue[1].trim());
            }
        }
        if (this.getUser() != null) {
            options.put("mail.smtp.auth", "true");
        }
        return options;
    }

    static {
        MAIL_NOTIFICATION_LEVELS.put((Object)"Disabled", (Object)new Integer(0));
        MAIL_NOTIFICATION_LEVELS.put((Object)"Standard", (Object)new Integer(3));
        MAIL_NOTIFICATION_LEVELS.put((Object)"Wary", (Object)new Integer(2));
        MAIL_NOTIFICATION_LEVELS.put((Object)"Paranoid", (Object)new Integer(1));
        MAIL_NOTIFICATION_LEVELS.setFast(true);
    }
}

