/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.mail;

import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.script.ScriptException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.JahiaService;
import org.jahia.services.mail.MailSettings;
import org.springframework.mail.javamail.MimeMessagePreparator;

public abstract class MailService
extends JahiaService {
    public static MailService getInstance() {
        return ServicesRegistry.getInstance().getMailService();
    }

    public abstract boolean sendMessage(String var1);

    public abstract boolean sendMessage(String var1, String var2);

    public abstract boolean sendMessage(String var1, String var2, String var3);

    public abstract boolean sendMessage(String var1, String var2, String var3, String var4, String var5, String var6);

    public abstract void sendMessage(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public abstract boolean sendHtmlMessage(String var1, String var2, String var3, String var4, String var5, String var6);

    public abstract String defaultRecipient();

    public abstract String defaultSender();

    public boolean isEnabled() {
        return this.getSettings() != null && this.getSettings().isServiceActivated() && this.getSettings().isConfigurationValid();
    }

    public abstract MailSettings getSettings();

    public static boolean isValidEmailAddress(String address, boolean allowMultiple) {
        InternetAddress[] addr = null;
        try {
            if (allowMultiple) {
                for (InternetAddress internetAddress : addr = InternetAddress.parse((String)address, (boolean)true)) {
                    internetAddress.validate();
                }
            } else {
                addr = new InternetAddress[]{new InternetAddress(address, true)};
            }
        }
        catch (AddressException e) {
            addr = null;
        }
        return addr != null;
    }

    public void sendMessage(MimeMessagePreparator mimeMessagePreparator) {
        throw new UnsupportedOperationException("Method not implemented");
    }

    public abstract void sendMessageWithTemplate(String var1, Map<String, Object> var2, String var3, String var4, String var5, String var6, Locale var7, String var8) throws RepositoryException, ScriptException;

    public abstract void store(MailSettings var1);
}

