/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.importexport.validation.ConstraintsValidatorResult;
import org.jahia.services.importexport.validation.ImportValidator;
import org.jahia.services.importexport.validation.ValidationResult;
import org.xml.sax.Attributes;

public class ConstraintsValidator
implements ImportValidator {
    private Map<String, Set<String>> missingMandatoryProperties = new TreeMap<String, Set<String>>();
    private Map<String, Set<String>> missingMandatoryI18NProperties = new TreeMap<String, Set<String>>();

    @Override
    public ValidationResult getResult() {
        return new ConstraintsValidatorResult(this.missingMandatoryProperties, this.missingMandatoryI18NProperties);
    }

    @Override
    public void validate(String decodedLocalName, String decodedQName, String currentPath, Attributes atts) {
        String m;
        String pt = atts.getValue("jcr:primaryType");
        if (pt != null) {
            this.checkTypeConstraints(pt, currentPath, false, atts);
        }
        if ((m = atts.getValue("jcr:mixinTypes")) != null) {
            StringTokenizer st = new StringTokenizer(m, " ,");
            while (st.hasMoreTokens()) {
                String mixin = st.nextToken();
                this.checkTypeConstraints(mixin, currentPath, true, atts);
            }
        }
    }

    private boolean checkTypeConstraints(String type, String currentPath, boolean mixin, Attributes atts) {
        try {
            String parentPath;
            Set<String> parentMissingMandatoryI18NProperties;
            ExtendedNodeType extendedNodeType = NodeTypeRegistry.getInstance().getNodeType(type);
            ExtendedPropertyDefinition[] extendedPropertyDefinitions = extendedNodeType.getPropertyDefinitions();
            if ("jnt:translation".equals(extendedNodeType.getName()) && (parentMissingMandatoryI18NProperties = this.missingMandatoryI18NProperties.get(parentPath = StringUtils.substringBeforeLast((String)currentPath, (String)"/"))) != null && parentMissingMandatoryI18NProperties.size() > 0) {
                boolean valuesFound = false;
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    String attName = atts.getQName(i);
                    if (attValue == null || !parentMissingMandatoryI18NProperties.contains(attName)) continue;
                    parentMissingMandatoryI18NProperties.remove(attName);
                    valuesFound = true;
                }
                if (valuesFound) {
                    if (parentMissingMandatoryI18NProperties.size() == 0) {
                        this.missingMandatoryI18NProperties.remove(parentPath);
                    } else {
                        this.missingMandatoryI18NProperties.put(parentPath, parentMissingMandatoryI18NProperties);
                    }
                }
            }
            for (ExtendedPropertyDefinition extendedPropertyDefinition : extendedPropertyDefinitions) {
                if (!extendedPropertyDefinition.isMandatory() || extendedPropertyDefinition.isAutoCreated() || extendedPropertyDefinition.isProtected() || extendedPropertyDefinition.hasDynamicDefaultValues()) continue;
                if (extendedPropertyDefinition.isInternationalized()) {
                    Set<String> missingProperties = this.missingMandatoryI18NProperties.get(currentPath);
                    if (missingProperties == null) {
                        missingProperties = new TreeSet<String>();
                    }
                    missingProperties.add(extendedPropertyDefinition.getName());
                    this.missingMandatoryI18NProperties.put(currentPath, missingProperties);
                    continue;
                }
                if (atts.getValue(extendedPropertyDefinition.getName()) != null || "jcr:data".equals(extendedPropertyDefinition.getName())) continue;
                Set<String> constraintsViolatedOnPath = this.missingMandatoryProperties.get(currentPath);
                if (constraintsViolatedOnPath == null) {
                    constraintsViolatedOnPath = new TreeSet<String>();
                }
                constraintsViolatedOnPath.add("Property [" + extendedPropertyDefinition.getName() + "] is mandatory but has no value");
                this.missingMandatoryProperties.put(currentPath, constraintsViolatedOnPath);
            }
            return this.missingMandatoryProperties.size() <= 0;
        }
        catch (NoSuchNodeTypeException e) {
            Set<String> constraintsViolatedOnPath = this.missingMandatoryProperties.get(currentPath);
            if (constraintsViolatedOnPath == null) {
                constraintsViolatedOnPath = new TreeSet<String>();
            }
            if (!mixin) {
                constraintsViolatedOnPath.add("Couldn't find node type definition " + type);
            } else {
                constraintsViolatedOnPath.add("Couldn't find mixin type definition " + type);
            }
            this.missingMandatoryProperties.put(type, constraintsViolatedOnPath);
            return false;
        }
    }
}

