/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.jcr.RepositoryException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.commons.Version;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.importexport.ImportFileUpdater;
import org.jahia.services.importexport.NoCloseZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExternalUsersImportUpdater
extends ImportFileUpdater {
    private static Logger logger = LoggerFactory.getLogger(ExternalUsersImportUpdater.class);
    private static final String LIVE_REPOSITORY_XML = "live-repository.xml";
    private static final String REPOSITORY_XML = "repository.xml";
    private static final String LIVE_CONTENT = "live-content";
    private static final String CONTENT = "content";

    @Override
    public boolean mustUpdate(Version version, int buildNumber) {
        Version sevenOne = new Version("7.1");
        return version.compareTo(sevenOne) < 0 || version.compareTo(sevenOne) == 0 && buildNumber < 50366;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File updateImport(File importFile, String fileName, String fileType) {
        HashMap<String, String> pathMapping = new HashMap<String, String>();
        File newImportFile = null;
        FileInputStream in = null;
        ZipInputStream zin = null;
        OutputStream out = null;
        ZipOutputStream zout = null;
        boolean updated = false;
        try {
            String name;
            Object zipentry;
            newImportFile = File.createTempFile("import", ".zip");
            in = new FileInputStream(importFile);
            zin = new NoCloseZipInputStream(new BufferedInputStream(in));
            out = new FileOutputStream(newImportFile);
            zout = new ZipOutputStream(out);
            while ((zipentry = zin.getNextEntry()) != null) {
                name = ((ZipEntry)zipentry).getName();
                if (!LIVE_REPOSITORY_XML.equals(name) && !REPOSITORY_XML.equals(name)) continue;
                zout.putNextEntry(new ZipEntry(name));
                if ("users.zip".equalsIgnoreCase(fileName)) {
                    updated |= this.transform(zin, zout, pathMapping);
                    continue;
                }
                updated |= this.clean(zin, zout, pathMapping);
            }
            if (!updated) {
                FileUtils.deleteQuietly((File)newImportFile);
                zipentry = importFile;
                return zipentry;
            }
            zin.closeEntry();
            ((NoCloseZipInputStream)zin).reallyClose();
            in.close();
            in = new FileInputStream(importFile);
            zin = new NoCloseZipInputStream(new BufferedInputStream(in));
            while ((zipentry = zin.getNextEntry()) != null) {
                name = ((ZipEntry)zipentry).getName();
                if (LIVE_REPOSITORY_XML.equals(name) || REPOSITORY_XML.equals(name)) continue;
                if (name.startsWith("live-content/")) {
                    for (String key : pathMapping.keySet()) {
                        if (!StringUtils.startsWith((String)name, (String)(LIVE_CONTENT + key))) continue;
                        name = StringUtils.replace((String)name, (String)(LIVE_CONTENT + key), (String)(LIVE_CONTENT + (String)pathMapping.get(key)));
                        break;
                    }
                } else if (name.startsWith("content/")) {
                    for (String key : pathMapping.keySet()) {
                        if (!StringUtils.startsWith((String)name, (String)(CONTENT + key))) continue;
                        name = StringUtils.replace((String)name, (String)(CONTENT + key), (String)(CONTENT + (String)pathMapping.get(key)));
                        break;
                    }
                }
                File content = File.createTempFile(CONTENT, null);
                IOUtils.copy((InputStream)zin, (OutputStream)new FileOutputStream(content));
                zout.putNextEntry(new ZipEntry(name));
                IOUtils.copy((InputStream)new FileInputStream(content), (OutputStream)zout);
            }
            JCRSessionFactory.getInstance().getCurrentUserSession().getPathMapping().putAll(pathMapping);
            zipentry = newImportFile;
            return zipentry;
        }
        catch (IOException | RepositoryException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
            logger.error("An error occurred while updating import file", e);
        }
        finally {
            try {
                if (zout != null) {
                    zout.closeEntry();
                    zout.finish();
                }
                if (out != null) {
                    out.close();
                }
                if (zin != null) {
                    zin.closeEntry();
                    ((NoCloseZipInputStream)zin).reallyClose();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.debug("Stream already closed", (Throwable)e);
            }
        }
        FileUtils.deleteQuietly((File)newImportFile);
        return importFile;
    }

    private boolean clean(InputStream inputStream, OutputStream outputStream, Map<String, String> pathMapping) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException, TransformerException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(inputStream));
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate("//*[@*[name()='jcr:primaryType'] = 'jnt:usersFolder']", doc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node legacyExtUser = nodes.item(i);
            Node parent = legacyExtUser.getParentNode();
            if (this.getNodePath(parent).startsWith("/sites/")) continue;
            parent.removeChild(legacyExtUser);
        }
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(new DOMSource(doc), new StreamResult(outputStream));
        return nodes.getLength() > 0;
    }

    private boolean transform(InputStream inputStream, OutputStream outputStream, Map<String, String> pathMapping) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException, TransformerException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(inputStream));
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate("//*[@*[name()='jcr:primaryType'] = 'jnt:user' and @*[name()='j:external'] = 'true']", doc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e;
            boolean removeParent;
            Node legacyExtUser = nodes.item(i);
            ArrayList<Node> tree = new ArrayList<Node>();
            Element extUser = (Element)legacyExtUser.cloneNode(true);
            extUser.setAttribute("jcr:primaryType", "jnt:externalUser");
            String externalSource = extUser.getAttribute("j:externalSource");
            extUser.setAttribute("j:externalSource", externalSource + ".users");
            tree.add(extUser);
            Node parent = legacyExtUser.getParentNode();
            parent.removeChild(legacyExtUser);
            boolean bl = removeParent = !this.hasChildElement(parent);
            while (parent != null && !"users".equals(parent.getNodeName())) {
                tree.add(0, parent.cloneNode(false));
                Node n = parent.getParentNode();
                if (removeParent) {
                    n.removeChild(parent);
                    removeParent = !this.hasChildElement(n);
                }
                parent = n;
            }
            if (parent == null) continue;
            StringBuilder mappingSrc = new StringBuilder(this.getNodePath(parent));
            StringBuilder mappingDst = new StringBuilder(this.getNodePath(parent));
            NodeList nodeList = ((Element)parent).getElementsByTagName("providers");
            if (nodeList.getLength() == 0) {
                e = doc.createElement("providers");
                e.setAttribute("jcr:primaryType", "jnt:usersFolder");
                e.setAttribute("jcr:mixinTypes", "jmix:hasExternalProviderExtension");
                e.setAttribute("j:published", "true");
                e.setAttribute("j:publicationStatus", "1");
                parent.appendChild(e);
                parent = e;
            } else {
                parent = nodeList.item(0);
            }
            mappingDst.append("/").append(parent.getNodeName());
            nodeList = ((Element)parent).getElementsByTagName(externalSource);
            if (nodeList.getLength() == 0) {
                e = doc.createElement(externalSource);
                e.setAttribute("jcr:primaryType", "jnt:usersFolder");
                e.setAttribute("provider", externalSource + ".users");
                e.setAttribute("j:publicationStatus", "4");
                parent.appendChild(e);
                parent = e;
            } else {
                parent = nodeList.item(0);
            }
            mappingDst.append("/").append(parent.getNodeName());
            for (Node n : tree) {
                String nodeName = n.getNodeName();
                mappingSrc.append("/").append(nodeName);
                mappingDst.append("/").append(nodeName);
                nodeList = ((Element)parent).getElementsByTagName(nodeName);
                if (nodeList.getLength() == 0) {
                    Node node;
                    parent = node = parent.appendChild(n);
                    continue;
                }
                parent = nodeList.item(0);
            }
            pathMapping.put(mappingSrc.toString(), mappingDst.toString());
        }
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(new DOMSource(doc), new StreamResult(outputStream));
        return nodes.getLength() > 0;
    }

    private boolean hasChildElement(Node node) {
        Node n = node.getFirstChild();
        while (n.getNextSibling() != null) {
            if (n instanceof Element) {
                return true;
            }
            n = n.getNextSibling();
        }
        return false;
    }

    private String getNodePath(Node node) {
        if (node.getParentNode() == null || node.getParentNode() instanceof Document) {
            return "";
        }
        return this.getNodePath(node.getParentNode()) + "/" + node.getNodeName();
    }
}

