/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FilenameUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.image.AbstractImageService;
import org.jahia.services.image.BufferImage;
import org.jahia.services.image.Image;
import org.jahia.services.image.JahiaImageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJava2DImageService
extends AbstractImageService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJava2DImageService.class);

    @Override
    public Image getImage(JCRNodeWrapper node) throws IOException, RepositoryException {
        try {
            String fileExtension = FilenameUtils.getExtension((String)node.getName());
            fileExtension = fileExtension != null && !"".equals(fileExtension) ? fileExtension + "." + fileExtension : null;
            JCRNodeWrapper contentNode = node.getNode("jcr:content");
            InputStream is = contentNode.getProperty("jcr:data").getBinary().getStream();
            String mimeType = contentNode.getProperty("jcr:mimeType").getString();
            BufferedImage originalImage = ImageIO.read(is);
            if (originalImage == null) {
                logger.warn("Unable to load image for node {}", (Object)node.getPath());
                return null;
            }
            return new BufferImage(node.getPath(), originalImage, mimeType);
        }
        catch (Exception e) {
            logger.error("Error opening image for node {}. Cause: {}", (Object)node.getPath(), (Object)e.getLocalizedMessage());
            if (logger.isDebugEnabled()) {
                logger.debug("Error opening image for node " + node.getPath(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public int getHeight(Image i) {
        BufferImage bufferImage = (BufferImage)i;
        return bufferImage.getOriginalImage().getHeight();
    }

    @Override
    public int getWidth(Image i) {
        BufferImage bufferImage = (BufferImage)i;
        return bufferImage.getOriginalImage().getWidth();
    }

    @Override
    public boolean cropImage(Image image, File outputFile, int top, int left, int width, int height) throws IOException {
        int clippingHeight;
        int clippingWidth = width;
        BufferedImage originalImage = ((BufferImage)image).getOriginalImage();
        if (left + clippingWidth > originalImage.getWidth()) {
            clippingWidth = originalImage.getWidth() - left;
        }
        if (top + (clippingHeight = height) > originalImage.getHeight()) {
            clippingHeight = originalImage.getHeight() - top;
        }
        BufferedImage clipping = this.getDestImage(clippingWidth, clippingHeight, originalImage);
        Graphics2D area = this.getGraphics2D(clipping, OperationType.CROP);
        area.drawImage(originalImage, 0, 0, clippingWidth, clippingHeight, left, top, left + clippingWidth, top + clippingHeight, null);
        area.dispose();
        this.saveImageToFile(clipping, ((BufferImage)image).getMimeType(), outputFile);
        return true;
    }

    @Override
    public boolean rotateImage(Image image, File outputFile, boolean clockwise) throws IOException {
        BufferedImage originalImage = ((BufferImage)image).getOriginalImage();
        BufferedImage dest = this.getDestImage(originalImage.getHeight(), originalImage.getWidth(), originalImage);
        Graphics2D graphics2D = this.getGraphics2D(dest, OperationType.ROTATE);
        double angle = Math.toRadians(clockwise ? 90.0 : -90.0);
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int w = originalImage.getWidth();
        int h = originalImage.getHeight();
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        graphics2D.translate((neww - w) / 2, (newh - h) / 2);
        graphics2D.rotate(angle, (double)w / 2.0, (double)h / 2.0);
        graphics2D.setComposite(AlphaComposite.getInstance(2));
        if (originalImage.getColorModel() instanceof IndexColorModel) {
            graphics2D.drawImage(originalImage, 0, 0, graphics2D.getBackground(), null);
        } else {
            graphics2D.drawImage((java.awt.Image)originalImage, 0, 0, null);
        }
        this.saveImageToFile(dest, ((BufferImage)image).getMimeType(), outputFile);
        return true;
    }

    @Override
    public boolean resizeImage(Image image, File outputFile, int newWidth, int newHeight, JahiaImageService.ResizeType resizeType) throws IOException {
        BufferedImage originalImage = ((BufferImage)image).getOriginalImage();
        BufferedImage dest = this.resizeImage(originalImage, newWidth, newHeight, resizeType);
        this.saveImageToFile(dest, ((BufferImage)image).getMimeType(), outputFile);
        return true;
    }

    @Override
    public BufferedImage resizeImage(BufferedImage image, int width, int newHeight, JahiaImageService.ResizeType resizeType) {
        AbstractImageService.ResizeCoords resizeCoords = this.getResizeCoords(resizeType, image.getWidth(), image.getHeight(), width, newHeight);
        if (JahiaImageService.ResizeType.ADJUST_SIZE.equals((Object)resizeType)) {
            width = resizeCoords.getTargetWidth();
            newHeight = resizeCoords.getTargetHeight();
        }
        BufferedImage dest = this.getDestImage(width, newHeight, image);
        Graphics2D graphics2D = this.getGraphics2D(dest, OperationType.RESIZE);
        graphics2D.drawImage(image, resizeCoords.getTargetStartPosX(), resizeCoords.getTargetStartPosY(), resizeCoords.getTargetStartPosX() + resizeCoords.getTargetWidth(), resizeCoords.getTargetStartPosY() + resizeCoords.getTargetHeight(), resizeCoords.getSourceStartPosX(), resizeCoords.getSourceStartPosY(), resizeCoords.getSourceStartPosX() + resizeCoords.getSourceWidth(), resizeCoords.getSourceStartPosY() + resizeCoords.getSourceHeight(), null);
        graphics2D.dispose();
        return dest;
    }

    protected abstract Graphics2D getGraphics2D(BufferedImage var1, OperationType var2);

    protected boolean canRead(JCRNodeWrapper node) throws RepositoryException {
        JCRNodeWrapper contentNode = node.getNode("jcr:content");
        String mimeType = contentNode.getProperty("jcr:mimeType").getString();
        Iterator<ImageReader> imageReaderIterator = ImageIO.getImageReadersByMIMEType(mimeType);
        if (imageReaderIterator.hasNext()) {
            Iterator<ImageWriter> imageWriterIterator = ImageIO.getImageWritersByMIMEType(mimeType);
            return imageWriterIterator.hasNext();
        }
        return false;
    }

    protected BufferedImage getDestImage(int newWidth, int newHeight, BufferedImage originalImage) {
        BufferedImage dest = originalImage.getColorModel() instanceof IndexColorModel ? new BufferedImage(originalImage.getColorModel(), originalImage.getColorModel().createCompatibleWritableRaster(newWidth, newHeight), false, new Hashtable()) : new BufferedImage(newWidth, newHeight, originalImage.getType());
        return dest;
    }

    protected void saveImageToFile(BufferedImage dest, String mimeType, File destFile) throws IOException {
        Iterator<ImageWriter> suffixWriters = ImageIO.getImageWritersByMIMEType(mimeType);
        if (suffixWriters.hasNext()) {
            ImageWriter imageWriter = suffixWriters.next();
            FileImageOutputStream imageOutputStream = new FileImageOutputStream(destFile);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(dest);
            imageOutputStream.close();
        } else {
            logger.warn("Couldn't find a writer for mime type : " + mimeType + "(" + this.getClass().getName() + ")");
        }
    }

    public static enum OperationType {
        RESIZE,
        CROP,
        ROTATE;

    }
}

