/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.htmlvalidator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.htmlvalidator.Result;
import org.jahia.services.htmlvalidator.ValidatorResults;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.i18n.Messages;
import org.jahia.utils.i18n.ResourceBundles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;

public class WAIValidator {
    private static final Logger logger = LoggerFactory.getLogger(WAIValidator.class);
    private static final Pattern PATTERN = Pattern.compile("\\s+");
    private boolean isDataTable = true;
    private int formLevel;
    private Locale uiLocale = SettingsBean.getInstance().getDefaultLocale();
    private ResourceBundle bundle = null;
    protected final Map<String, String> linkToDest = new HashMap<String, String>();

    public WAIValidator(Locale uiLocale) {
        this.uiLocale = uiLocale;
    }

    public ValidatorResults validate(String inputHTML) {
        if (logger.isDebugEnabled()) {
            logger.debug("Validate: " + inputHTML);
        }
        ValidatorResults evh = new ValidatorResults();
        this.bundle = ResourceBundles.getInternal(this.uiLocale);
        if (inputHTML == null || inputHTML.length() == 0) {
            return evh;
        }
        String tmp = !inputHTML.startsWith("<body>") ? "<body>" + inputHTML + "</body>" : inputHTML;
        Source source = new Source((CharSequence)tmp);
        source.setLogger(null);
        this.linkToDest.clear();
        List<Result> results = this.validateHtml((Element)source.getChildElements().get(0), source);
        for (Result result : results) {
            if (Result.Type.ERROR.equals((Object)result.getType())) {
                evh.addError(result);
                continue;
            }
            if (Result.Type.WARNING.equals((Object)result.getType())) {
                evh.addWarning(result);
                continue;
            }
            if (!Result.Type.INFORMATION.equals((Object)result.getType())) continue;
            evh.addInfo(result);
        }
        return evh;
    }

    protected List<Result> validateHtml(Element node, Source source) {
        ArrayList<Result> errors = new ArrayList<Result>();
        try {
            this.validateHtml(node, errors, 0, source);
        }
        catch (DOMException de) {
            logger.error("Cannot validate html: " + de.getMessage(), (Throwable)de);
            Result ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.cannotValidate", "Cannot validate html: " + de.getMessage(), new Object[]{de.getMessage()}));
            this.setPosition(node, source, ve);
            errors.add(ve);
        }
        return errors;
    }

    private void validateHtml(Element node, List<Result> errors, int level, Source source) throws DOMException {
        if (this.processNode(node, errors, level, source)) {
            ++level;
            for (Element child : node.getChildElements()) {
                this.validateHtml(child, errors, level, source);
            }
        }
    }

    private boolean processNode(Element element, List<Result> errors, int level, Source source) throws DOMException {
        if (element == null) {
            return false;
        }
        this.resetIsDataTable(level);
        Result err = null;
        if ("a".equals(element.getName())) {
            err = this.validateLink(element, source);
        } else if ("img".equals(element.getName())) {
            err = this.validateImage(element, source);
        } else if ("area".equals(element.getName())) {
            err = this.validateAreaShape(element, source);
        } else if ("form".equals(element.getName())) {
            errors.addAll(this.validateForm(element, level, source));
        } else if ("table".equals(element.getName())) {
            errors.addAll(this.validateTable(element, level, source));
        } else if ("frameset".equals(element.getName())) {
            errors.addAll(this.validateFrameset(element, level, source));
        } else if (logger.isDebugEnabled()) {
            logger.debug("Ignoring node of type: " + element.getName());
        }
        if (err != null) {
            errors.add(err);
        }
        return true;
    }

    protected void setIsDataTable(int level) {
        if (!this.isDataTable) {
            throw new IllegalStateException("isDataTable allready set");
        }
        this.formLevel = level;
        this.isDataTable = false;
    }

    protected void resetIsDataTable(int level) {
        if (level == this.formLevel) {
            this.isDataTable = true;
        }
    }

    protected Result validateLink(Element node, Source source) throws DOMException {
        String titleValue;
        int length2;
        int length;
        Attribute href = node.getAttributes().get("href");
        if (href == null) {
            return null;
        }
        String linkValue = node.getTextExtractor().toString();
        if (StringUtils.isBlank((String)linkValue) && !node.getChildElements().isEmpty()) {
            linkValue = ((Element)node.getChildElements().get(0)).toString();
        }
        if ((length = (linkValue = linkValue != null ? WAIValidator.text2XMLEntityRef(StringUtils.stripToEmpty((String)linkValue)) : "").length()) > 80) {
            Result ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.6.1", "Link value should not be longer than 80 characters. Length = " + length, new Object[]{linkValue, Integer.toString(length)}), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.6.1.example", ""));
            this.setPosition(node, source, ve);
            return ve;
        }
        Attribute title = node.getAttributes().get("title");
        if (title == null) {
            Result ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.6.3", "Missing 'title' attribute for 'hyperlink' element", new Object[]{linkValue}), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.6.3.example", ""));
            this.setPosition(node, source, ve);
            return ve;
        }
        if (title != null && (length2 = (titleValue = WAIValidator.text2XMLEntityRef(title.getValue())).length()) > 80) {
            Result ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.6.3.2", "Attribute 'title' should not be longer than 80 characters. Length = " + length2, new Object[]{linkValue, titleValue, Integer.toString(length2)}), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.6.3.2.example", ""));
            this.setPosition(node, source, ve);
            return ve;
        }
        if (StringUtils.isNotEmpty((String)linkValue)) {
            String hrefValue = href.getValue();
            if (this.linkToDest.containsKey(linkValue)) {
                String dest = this.linkToDest.get(linkValue);
                if (!hrefValue.equals(dest)) {
                    Result ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.6.5", "All same link values(" + hrefValue + ") should point to the same destination", new Object[]{hrefValue}), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.6.5.example", ""));
                    this.setPosition(node, source, ve);
                    return ve;
                }
            } else {
                this.linkToDest.put(linkValue, hrefValue);
            }
        }
        return null;
    }

    protected Result validateImage(Element node, Source source) {
        Attribute src = node.getAttributes().get("src");
        String srcText = src == null ? "n/a" : src.getValue();
        Attribute alt = node.getAttributes().get("alt");
        if (alt == null) {
            Result ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.1.1", "Missing 'alt' attribute for image " + srcText, new Object[]{srcText}), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.1.1.example", ""));
            this.setPosition(node, source, ve);
            return ve;
        }
        String altValue = WAIValidator.text2XMLEntityRef(alt.getValue());
        int length = altValue.length();
        if (length == 0) {
            Result ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.1.1.1", "'alt' attribute for image " + srcText + " is empty", new Object[]{srcText}), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.1.1.1.example", ""), Result.Type.WARNING);
            this.setPosition(node, source, ve);
            return ve;
        }
        if (length > 60) {
            Result ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.1.4", "Attribute 'alt' should not be longer than 60 characters. Length = " + length + ". Use attribute 'longdesc' if you want a longer description", new Object[]{altValue, srcText, Integer.toString(length)}), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.1.4.example", ""));
            this.setPosition(node, source, ve);
            return ve;
        }
        return null;
    }

    protected Result validateAreaShape(Element node, Source source) {
        logger.debug("validateAreaShape");
        Attribute shape = node.getAttributes().get("shape");
        if (shape != null) {
            String shapeValue = shape.getValue();
            Attribute alt = node.getAttributes().get("alt");
            if (alt == null) {
                Result ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.1.1.2", "Missing 'alt' attribute for 'area' element", new Object[]{shapeValue}), this.getContextForArea(node, source), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.1.1.2.example", ""));
                this.setPosition(node, source, ve);
                return ve;
            }
            String altValue = WAIValidator.text2XMLEntityRef(alt.getValue());
            int length = altValue.length();
            if (length == 0) {
                Result ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.1.1.3", "'alt' attribute for 'area' element " + shapeValue + " is empty", new Object[]{shapeValue}), this.getContextForArea(node, source), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.1.1.3.example", ""), Result.Type.WARNING);
                this.setPosition(node, source, ve);
                return ve;
            }
        }
        return null;
    }

    private String getContextForArea(Element areaNode, Source source) {
        StartTag img;
        String ctx = areaNode.toString();
        Element map = areaNode.getParentElement();
        if (map.getName().equals("map") && map.getAttributeValue("name") != null && (img = source.getFirstStartTag("usemap", "#" + map.getAttributeValue("name"), false)) != null) {
            ctx = img.getElement().toString();
        }
        return ctx;
    }

    protected List<Result> validateTable(Element node, int level, Source source) {
        logger.debug("validateTable");
        ArrayList<Result> errors = new ArrayList<Result>();
        if (!this.isDataTable) {
            return errors;
        }
        int headerCellCount = 0;
        for (Element tableChildElement : node.getChildElements()) {
            if ("thead".equals(tableChildElement.getName())) {
                headerCellCount += this.countHeadersInRows(tableChildElement.getChildElements());
                continue;
            }
            if ("tr".equals(tableChildElement.getName())) {
                headerCellCount += this.countHeadersInRow(tableChildElement);
                continue;
            }
            if (!"tbody".equals(tableChildElement.getName())) continue;
            headerCellCount += this.countHeadersInRows(tableChildElement.getChildElements());
        }
        if (headerCellCount == 0) {
            Result ve = new Result(this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.5.3", "No header cell was found in the table"), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.5.3.example", ""), Result.Type.WARNING);
            this.setPosition(node, source, ve);
            errors.add(ve);
        }
        Element firstLine = null;
        for (Element childElement : node.getChildElements()) {
            if ("thead".equals(childElement.getName())) {
                firstLine = (Element)childElement.getChildElements().get(0);
                break;
            }
            if ("tr".equals(childElement.getName())) {
                firstLine = childElement;
                break;
            }
            if (!"tbody".equals(childElement.getName())) continue;
            firstLine = (Element)childElement.getChildElements().get(0);
            break;
        }
        if (firstLine == null) {
            logger.debug("No table data, returning...");
            return errors;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("First line: " + firstLine.getName());
        }
        HashSet<String> ids = new HashSet<String>();
        int scopes = 0;
        int elementCount = -1;
        for (Element element : firstLine.getChildElements()) {
            ++elementCount;
            if (logger.isDebugEnabled()) {
                logger.debug("First line in loop: " + element.getName());
            }
            if (!"th".equals(element.getName())) continue;
            Attribute scope = element.getAttributes().get("scope");
            Attribute id = element.getAttributes().get("id");
            if (scope == null && id == null || scope != null && id != null) {
                Result ve = new Result(this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.5.3.2", "'th' elements should have an attribute 'scope', set to 'col' or 'row' OR an 'id' attribute, but not both at the same time"), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.5.3.2.example", ""));
                this.setPosition(node, source, ve);
                errors.add(ve);
                return errors;
            }
            if (id == null) {
                if (!"col".equals(scope.getValue().toLowerCase()) && elementCount > 0) {
                    Result ve = new Result(this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.5.3.3", "The 'th' elements of the first row of the table should have a 'col' scope"), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.5.3.3.example", ""));
                    this.setPosition(node, source, ve);
                    errors.add(ve);
                    return errors;
                }
                ++scopes;
                continue;
            }
            ids.add(id.getValue());
        }
        if (scopes > 0 && !ids.isEmpty()) {
            Result ve = new Result(this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.5.3.4", "The 'th' elements of the first row of the table should all use the same attribute"), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.5.3.4.example", ""));
            this.setPosition(node, source, ve);
            errors.add(ve);
            return errors;
        }
        if (!ids.isEmpty()) {
            HashSet<String> headers = new HashSet<String>();
            this.processTable(node, headers, ids, errors, level, source);
            HashSet<String> ids2 = new HashSet<String>(ids);
            for (String value : ids2) {
                if (!headers.contains(value)) continue;
                headers.remove(value);
                ids.remove(value);
            }
            for (String headerAttribute : headers) {
                Result ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.5.3.5", "Attribute 'header' (" + headerAttribute + ") has no corresponding 'id'", new Object[]{headerAttribute}), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.5.3.5.example", ""));
                this.setPosition(node, source, ve);
                errors.add(ve);
            }
        }
        return errors;
    }

    protected void processTable(Element node, Set<String> headers, Set<String> ids, List<Result> errors, int level, Source source) {
        Attribute id;
        if ("td".equals(node.getName().toLowerCase())) {
            Attribute header = node.getAttributes().get("headers");
            if (header == null) {
                Result ve = new Result(this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.5.4", "Missing 'headers' attribute for 'td' element"), node.getParentElement().getParentElement().toString(), node.getParentElement().getParentElement().toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.5.4.example", ""));
                this.setPosition(node, source, ve);
                errors.add(ve);
            } else {
                String value = header.getValue();
                for (String token : PATTERN.split(value)) {
                    headers.add(token);
                }
            }
        } else if ("th".equals(node.getName().toLowerCase()) && (id = node.getAttributes().get("id")) != null) {
            ids.add(id.getValue());
        }
        for (Element element : node.getChildElements()) {
            if (!this.processNode(element, errors, level, source)) continue;
            this.processTable(element, headers, ids, errors, level, source);
        }
    }

    protected int countHeadersInRows(List<Element> rowElements) {
        int headerCellCount = 0;
        for (Element rowElement : rowElements) {
            if (!"tr".equals(rowElement.getName())) continue;
            headerCellCount += this.countHeadersInRow(rowElement);
        }
        return headerCellCount;
    }

    protected int countHeadersInRow(Element rowElement) {
        int headerCellCount = 0;
        for (Element cellElement : rowElement.getChildElements()) {
            if (!"th".equals(cellElement.getName())) continue;
            ++headerCellCount;
        }
        return headerCellCount;
    }

    protected List<Result> validateForm(Element node, int level, Source source) {
        Result ve;
        logger.debug("validateForm");
        this.setIsDataTable(level);
        HashSet<String> fors = new HashSet<String>();
        HashSet<String> ids = new HashSet<String>();
        ArrayList<Result> errors = new ArrayList<Result>();
        this.processForm(node, fors, ids, errors, level, source);
        ArrayList<String> fors2 = new ArrayList<String>(fors);
        for (String value : fors2) {
            if (!ids.contains(value)) continue;
            fors.remove(value);
            ids.remove(value);
        }
        for (String forAtt : fors) {
            ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.11.1.3", "There is no 'id' attribute in any 'input' element for attribute 'for' (" + forAtt + "). Check all your 'label' elements in the 'form'", new Object[]{forAtt}));
            this.setPosition(node, source, ve);
            errors.add(ve);
        }
        for (String id : ids) {
            ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.11.1.4", "All text 'input' elements should have a corresponding 'label' element.'Input' element with id (" + id + ") has no label", new Object[]{id}));
            this.setPosition(node, source, ve);
            errors.add(ve);
        }
        return errors;
    }

    private void processForm(Element node, Set<String> fors, Set<String> ids, List<Result> errors, int level, Source source) {
        Result ve;
        if ("label".equals(node.getName())) {
            Attribute forAttr = node.getAttributes().get("for");
            if (forAttr == null) {
                ve = new Result(this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.11.1", "Missing 'for' attribute for 'label' element"), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.11.1.example", ""));
                this.setPosition(node, source, ve);
                errors.add(ve);
            } else {
                fors.add(forAttr.getValue());
            }
        } else if ("input".equals(node.getName()) && "text".equalsIgnoreCase(node.getAttributeValue("type"))) {
            Attribute idAttr = node.getAttributes().get("id");
            if (idAttr == null) {
                ve = new Result(this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.11.1.2", "Missing 'id' attribute for 'input' element"), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.11.2.example", ""));
                this.setPosition(node, source, ve);
                errors.add(ve);
            } else {
                ids.add(idAttr.getValue());
            }
        }
        for (Element element : node.getChildElements()) {
            if (!this.processNode(element, errors, level, source)) continue;
            this.processForm(element, fors, ids, errors, level, source);
        }
    }

    protected List<Result> validateFrameset(Element node, int level, Source source) {
        ArrayList<Result> errors = new ArrayList<Result>();
        HashSet<String> noframes = new HashSet<String>();
        for (Element childElement : node.getChildElements()) {
            this.processFrameset(childElement, noframes, errors, level, source);
        }
        if (noframes.isEmpty()) {
            Result ve = new Result(this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.2.3", "Missing <NOFRAMES> tag after frameset definition"));
            this.setPosition(node, source, ve);
            errors.add(ve);
        }
        return errors;
    }

    protected void processFrameset(Element node, Set<String> noframes, List<Result> errors, int level, Source source) {
        if ("frame".equals(node.getName().toLowerCase())) {
            logger.debug("validateFrame");
            Attribute name = node.getAttributes().get("name");
            if (name == null) {
                Result ve = new Result(this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.2.1", "Missing 'name' attribute for 'frame' element"), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.2.1.example", ""));
                this.setPosition(node, source, ve);
                errors.add(ve);
            } else {
                Result ve;
                String nameValue = WAIValidator.text2XMLEntityRef(name.getValue());
                if (nameValue.indexOf(32) > -1) {
                    Result ve2 = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.2.1.2", "Attribute 'name' cannot contain any white space", new Object[]{nameValue}), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.2.1.2.example", ""));
                    this.setPosition(node, source, ve2);
                    errors.add(ve2);
                } else {
                    Attribute title = node.getAttributes().get("title");
                    if (title == null) {
                        ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.2.5", "Missing 'title' attribute for 'frame' element", new Object[]{nameValue}), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.2.5.example", ""));
                        this.setPosition(node, source, ve);
                        errors.add(ve);
                    }
                }
                Attribute scrolling = node.getAttributes().get("scrolling");
                if (scrolling != null && "no".equals(scrolling.getValue().toLowerCase())) {
                    ve = new Result(this.getFormatted("org.jahia.services.htmlvalidator.WAIValidator.2.10", "Scrolling should be set to at least 'auto' for frame " + nameValue, new Object[]{nameValue}), node.toString(), node.toString(), this.getMessage("org.jahia.services.htmlvalidator.WAIValidator.2.10.example", ""));
                    this.setPosition(node, source, ve);
                    errors.add(ve);
                }
            }
        } else if ("noframes".equals(node.getName().toLowerCase())) {
            noframes.add(node.getName());
        }
        for (Element element : node.getChildElements()) {
            if (!this.processNode(element, errors, level, source)) continue;
            this.processFrameset(element, noframes, errors, level, source);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    private void setPosition(Element node, Source source, Result result) {
        result.setColumn(source.getColumn(node.getBegin()));
        result.setLine(source.getRow(node.getBegin()));
    }

    private String getFormatted(String key, String defaultValue, Object[] args) {
        return Messages.format(this.getMessage(key, defaultValue), this.uiLocale, args);
    }

    private String getMessage(String key, String defaultValue) {
        return Messages.get(this.bundle, key, defaultValue);
    }

    private static String text2XMLEntityRef(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        str = StringEscapeUtils.unescapeHtml((String)str);
        str = StringUtils.replace((String)str, (String)"&amp;", (String)"&");
        str = StringUtils.replace((String)str, (String)"&lt;", (String)"<");
        str = StringUtils.replace((String)str, (String)"&gt;", (String)">");
        str = StringUtils.replace((String)str, (String)"&quot;", (String)"\"");
        str = StringUtils.replace((String)str, (String)"&apos;", (String)"'");
        return str;
    }
}

