/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.lang.StringUtils;
import org.drools.core.spi.KnowledgeHelper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.rules.AbstractNodeFact;
import org.jahia.services.content.rules.AddedNodeFact;
import org.jahia.services.content.rules.NodeFact;

public class DeletedNodeFact
implements NodeFact {
    private String path;
    private String identifier;
    private JCRSessionWrapper session;
    private String name;
    private AddedNodeFact parent;
    private String workspace;
    private List<String> types;
    private List<String> resolvedTypes;
    private String operationType;

    public DeletedNodeFact(AddedNodeFact nodeWrapper, KnowledgeHelper drools) throws RepositoryException {
        this.path = nodeWrapper.getPath();
        JCRNodeWrapper node = nodeWrapper.getNode();
        this.workspace = node.getSession().getWorkspace().getName();
        this.resolvedTypes = AbstractNodeFact.recurseOnTypes(node.getPrimaryNodeType(), (NodeType[])node.getMixinNodeTypes());
        node.remove();
        drools.retract((Object)nodeWrapper);
    }

    public DeletedNodeFact(AddedNodeFact parent, String path) throws RepositoryException {
        this.parent = parent;
        this.path = path;
        this.name = StringUtils.substringAfterLast((String)path, (String)"/");
        this.workspace = parent.getNode().getSession().getWorkspace().getName();
    }

    public String toString() {
        return "deleted " + this.path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public AddedNodeFact getParent() {
        return this.parent;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public JCRSessionWrapper getSession() throws RepositoryException {
        return this.session;
    }

    public void setSession(JCRSessionWrapper session) {
        this.session = session;
    }

    @Override
    public String getWorkspace() throws RepositoryException {
        return this.workspace;
    }

    @Override
    public String getLanguage() throws RepositoryException {
        return this.parent.getLanguage();
    }

    @Override
    public String getOperationType() {
        return this.operationType;
    }

    @Override
    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getTypes() throws RepositoryException {
        if (this.resolvedTypes == null && this.types != null) {
            this.resolvedTypes = AbstractNodeFact.recurseOnTypes(this.types);
        }
        return this.resolvedTypes;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }
}

