/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.jahia.bin.Jahia;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ModuleImageChoiceListInitializerImpl
implements ChoiceListInitializer {
    private static transient Logger logger = LoggerFactory.getLogger(ModuleImageChoiceListInitializerImpl.class);

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        if (values != null && values.size() > 0) {
            JahiaTemplatesPackage template = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(epd.getDeclaringNodeType().getSystemId());
            for (ChoiceListValue value : values) {
                try {
                    Resource imagePath = template.getResource("/img/" + value.getValue().getString() + "." + param);
                    if (imagePath != null && imagePath.exists()) {
                        String s = Jahia.getContextPath();
                        if (s.equals("/")) {
                            s = "";
                        }
                        value.addProperty("image", s + (template.getRootFolderPath().startsWith("/") ? "" : "/") + template.getRootFolderPath() + "/img/" + value.getValue().getString() + "." + param);
                        continue;
                    }
                    logger.debug("ModuleImageChoiceListInitializerImpl : unable to find image /img/" + value.getValue().getString() + "." + param + " in module " + template.getName() + " for property " + epd.getName() + " for type " + epd.getDeclaringNodeType().getName());
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return values;
        }
        return new ArrayList<ChoiceListValue>();
    }
}

