/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

public class ParseException
extends Exception {
    private static final long serialVersionUID = -2210995894762804559L;
    private final int lineNumber;
    private final int colNumber;
    private final String filename;

    public ParseException(int lineNumber, int colNumber, String filename) {
        this.lineNumber = lineNumber;
        this.colNumber = colNumber;
        this.filename = filename;
    }

    public ParseException(String message, int lineNumber, int colNumber, String filename) {
        super(message);
        this.lineNumber = lineNumber;
        this.colNumber = colNumber;
        this.filename = filename;
    }

    public ParseException(String message, Throwable rootCause, int lineNumber, int colNumber, String filename) {
        super(message, rootCause);
        this.lineNumber = lineNumber;
        this.colNumber = colNumber;
        this.filename = filename;
    }

    public ParseException(Throwable rootCause, int lineNumber, int colNumber, String filename) {
        super(rootCause);
        this.lineNumber = lineNumber;
        this.colNumber = colNumber;
        this.filename = filename;
    }

    @Override
    public String getMessage() {
        StringBuilder b = new StringBuilder(super.getMessage());
        String delim = " (";
        if (this.filename != null && !this.filename.equals("")) {
            b.append(delim);
            b.append(this.filename);
            delim = ", ";
        }
        if (this.lineNumber >= 0) {
            b.append(delim);
            b.append("line ");
            b.append(this.lineNumber);
            delim = ", ";
        }
        if (this.colNumber >= 0) {
            b.append(delim);
            b.append("col ");
            b.append(this.colNumber);
            delim = ", ";
        }
        if (delim.equals(", ")) {
            b.append(")");
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

