/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.interceptor;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRValueFactoryImpl;
import org.jahia.services.content.interceptor.BaseInterceptor;
import org.jahia.services.render.RenderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateModuleInterceptor
extends BaseInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TemplateModuleInterceptor.class);
    public static final ThreadLocal<RenderContext> renderContextThreadLocal = new ThreadLocal();
    private static final int TEMPLATES_TOKEN_POSITION = 3;

    @Override
    public Value afterGetValue(JCRPropertyWrapper property, Value storedValue) throws ValueFormatException, RepositoryException {
        String[] propertyPathTokens;
        String propertyPath;
        String contextSitePath;
        RenderContext renderContext = renderContextThreadLocal.get();
        if (renderContext != null && StringUtils.startsWith((String)(contextSitePath = renderContext.getSite().getPath()), (String)"/sites") && (propertyPath = property.getPath()).startsWith("/modules/") && (propertyPathTokens = StringUtils.split((String)propertyPath, (String)"/", (int)5)).length >= 5 && "templates".equals(propertyPathTokens[3])) {
            try {
                String[] path;
                String referencePath = property.getSession().getNodeByIdentifier(storedValue.getString()).getPath();
                if (referencePath.startsWith("/modules/") && (path = StringUtils.split((String)referencePath, (String)"/")).length >= 3 && !"templates".equals(path[3])) {
                    StringBuilder sitePath = new StringBuilder(64);
                    sitePath.append(contextSitePath);
                    for (int i = 3; i < path.length; ++i) {
                        sitePath.append("/").append(path[i]);
                    }
                    return JCRValueFactoryImpl.getInstance().createValue((Node)property.getSession().getNode(sitePath.toString()));
                }
            }
            catch (PathNotFoundException e) {
                logger.warn("Cannot get reference in local site " + e.getMessage());
                renderContext.getRequest().setAttribute("expiration", (Object)"0");
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
        }
        return storedValue;
    }
}

